/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.support.v4.util.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Polygons;
import java.util.ArrayList;
import java.util.List;

class PolygonContainer
implements Polygons {
    private final NativeMap nativeMap;
    private final LongSparseArray<Annotation> annotations;

    PolygonContainer(NativeMap nativeMap, LongSparseArray<Annotation> annotations) {
        this.nativeMap = nativeMap;
        this.annotations = annotations;
    }

    @Override
    public Polygon addBy(@NonNull PolygonOptions polygonOptions, @NonNull MapboxMap mapboxMap) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.nativeMap != null ? this.nativeMap.addPolygon(polygon) : 0L;
            polygon.setId(id2);
            polygon.setMapboxMap(mapboxMap);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    @Override
    @NonNull
    public List<Polygon> addBy(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (this.nativeMap != null && count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = this.nativeMap.addPolygons(polygons);
            for (int i = 0; i < ids.length; ++i) {
                polygon = (Polygon)polygons.get(i);
                polygon.setMapboxMap(mapboxMap);
                polygon.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polygon);
            }
        }
        return polygons;
    }

    @Override
    public void update(@NonNull Polygon polygon) {
        this.nativeMap.updatePolygon(polygon);
        this.annotations.setValueAt(this.annotations.indexOfKey(polygon.getId()), (Object)polygon);
    }

    @Override
    @NonNull
    public List<Polygon> obtainAll() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }
}

