/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.MultiFingerTapGestureDetector;
import com.mapbox.android.gestures.R;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

final class MapGestureDetector {
    private final Transform transform;
    private final Projection projection;
    private final UiSettings uiSettings;
    private final AnnotationManager annotationManager;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private final CopyOnWriteArrayList<MapboxMap.OnMapClickListener> onMapClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMapLongClickListener> onMapLongClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnFlingListener> onFlingListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMoveListener> onMoveListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnRotateListener> onRotateListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnScaleListener> onScaleListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnShoveListener> onShoveListenerList = new CopyOnWriteArrayList();
    @Nullable
    private PointF constantFocalPoint;
    @NonNull
    private PointF doubleTapFocalPoint = new PointF();
    private AndroidGesturesManager gesturesManager;
    private Animator scaleAnimator;
    private Animator rotateAnimator;
    private final List<Animator> scheduledAnimators = new ArrayList<Animator>();
    @NonNull
    private Handler animationsTimeoutHandler = new Handler();
    private boolean doubleTapRegistered;
    @NonNull
    private final Runnable cancelAnimatorsRunnable = new Runnable(){

        @Override
        public void run() {
            MapGestureDetector.this.cancelAnimators();
        }
    };

    MapGestureDetector(@Nullable Context context, Transform transform, Projection projection, UiSettings uiSettings, AnnotationManager annotationManager, CameraChangeDispatcher cameraChangeDispatcher) {
        this.annotationManager = annotationManager;
        this.transform = transform;
        this.projection = projection;
        this.uiSettings = uiSettings;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        if (context != null) {
            AndroidGesturesManager androidGesturesManager = new AndroidGesturesManager(context);
            this.initializeGesturesManager(androidGesturesManager, true);
            this.initializeGestureListeners(context, true);
        }
    }

    private void initializeGestureListeners(@NonNull Context context, boolean attachDefaultListeners) {
        if (attachDefaultListeners) {
            StandardGestureListener standardGestureListener = new StandardGestureListener(context.getResources().getDimension(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold));
            MoveGestureListener moveGestureListener = new MoveGestureListener();
            ScaleGestureListener scaleGestureListener = new ScaleGestureListener(context.getResources().getDimension(R.dimen.mapbox_density_constant), context.getResources().getDimension(R.dimen.mapbox_minimum_scale_speed), context.getResources().getDimension(R.dimen.mapbox_minimum_angled_scale_speed), context.getResources().getDimension(R.dimen.mapbox_minimum_scale_velocity));
            RotateGestureListener rotateGestureListener = new RotateGestureListener(context.getResources().getDimension(R.dimen.mapbox_minimum_scale_span_when_rotating), context.getResources().getDimension(R.dimen.mapbox_density_constant), context.getResources().getDimension(R.dimen.mapbox_angular_velocity_multiplier), context.getResources().getDimension(R.dimen.mapbox_minimum_angular_velocity), context.getResources().getDimension(R.dimen.mapbox_defaultScaleSpanSinceStartThreshold));
            ShoveGestureListener shoveGestureListener = new ShoveGestureListener();
            TapGestureListener tapGestureListener = new TapGestureListener();
            this.gesturesManager.setStandardGestureListener((StandardGestureDetector.StandardOnGestureListener)standardGestureListener);
            this.gesturesManager.setMoveGestureListener((MoveGestureDetector.OnMoveGestureListener)moveGestureListener);
            this.gesturesManager.setStandardScaleGestureListener((StandardScaleGestureDetector.StandardOnScaleGestureListener)scaleGestureListener);
            this.gesturesManager.setRotateGestureListener((RotateGestureDetector.OnRotateGestureListener)rotateGestureListener);
            this.gesturesManager.setShoveGestureListener((ShoveGestureDetector.OnShoveGestureListener)shoveGestureListener);
            this.gesturesManager.setMultiFingerTapGestureListener((MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener)tapGestureListener);
        }
    }

    private void initializeGesturesManager(@NonNull AndroidGesturesManager androidGesturesManager, boolean setDefaultMutuallyExclusives) {
        if (setDefaultMutuallyExclusives) {
            HashSet<Integer> shoveScaleSet = new HashSet<Integer>();
            shoveScaleSet.add(3);
            shoveScaleSet.add(1);
            HashSet<Integer> shoveRotateSet = new HashSet<Integer>();
            shoveRotateSet.add(3);
            shoveRotateSet.add(2);
            HashSet<Integer> ScaleLongPressSet = new HashSet<Integer>();
            ScaleLongPressSet.add(1);
            ScaleLongPressSet.add(6);
            androidGesturesManager.setMutuallyExclusiveGestures(new Set[]{shoveScaleSet, shoveRotateSet, ScaleLongPressSet});
        }
        this.gesturesManager = androidGesturesManager;
        this.gesturesManager.getRotateGestureDetector().setAngleThreshold(3.0f);
    }

    void setFocalPoint(@Nullable PointF focalPoint) {
        if (focalPoint == null && this.uiSettings.getFocalPoint() != null) {
            focalPoint = this.uiSettings.getFocalPoint();
        }
        this.constantFocalPoint = focalPoint;
    }

    boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        if (motionEvent.getButtonState() != 0 && motionEvent.getButtonState() != 1) {
            return false;
        }
        if (motionEvent.getActionMasked() == 0) {
            this.cancelAnimators();
            this.transform.setGestureInProgress(true);
        }
        boolean result = this.gesturesManager.onTouchEvent(motionEvent);
        switch (motionEvent.getActionMasked()) {
            case 5: {
                this.doubleTapFinished();
                break;
            }
            case 1: {
                this.doubleTapFinished();
                this.transform.setGestureInProgress(false);
                if (this.scheduledAnimators.isEmpty()) break;
                this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
                for (Animator animator : this.scheduledAnimators) {
                    animator.start();
                }
                this.scheduledAnimators.clear();
                break;
            }
            case 3: {
                this.scheduledAnimators.clear();
                this.transform.setGestureInProgress(false);
                this.doubleTapFinished();
            }
        }
        return result;
    }

    void cancelAnimators() {
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.scheduledAnimators.clear();
        this.cancelAnimator(this.scaleAnimator);
        this.cancelAnimator(this.rotateAnimator);
        this.dispatchCameraIdle();
    }

    private void cancelAnimator(@Nullable Animator animator) {
        if (animator != null && animator.isStarted()) {
            animator.cancel();
        }
    }

    private void scheduleAnimator(Animator animator) {
        this.scheduledAnimators.add(animator);
        this.animationsTimeoutHandler.removeCallbacksAndMessages(null);
        this.animationsTimeoutHandler.postDelayed(this.cancelAnimatorsRunnable, 150L);
    }

    boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.uiSettings.isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.transform.zoomBy(scrollDist, new PointF(event.getX(), event.getY()));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void doubleTapStarted() {
        this.gesturesManager.getMoveGestureDetector().setEnabled(false);
        this.doubleTapRegistered = true;
    }

    private void doubleTapFinished() {
        if (this.doubleTapRegistered) {
            this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            this.doubleTapRegistered = false;
        }
    }

    private Animator createScaleAnimator(double currentZoom, double zoomAddition, final @NonNull PointF animationFocalPoint, long animationTime) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{(float)currentZoom, (float)(currentZoom + zoomAddition)});
        animator.setDuration(animationTime);
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                MapGestureDetector.this.transform.setZoom(((Float)animation.getAnimatedValue()).floatValue(), animationFocalPoint);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MapGestureDetector.this.transform.cancelTransitions();
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            }

            public void onAnimationCancel(Animator animation) {
                MapGestureDetector.this.transform.cancelTransitions();
            }

            public void onAnimationEnd(Animator animation) {
                MapGestureDetector.this.dispatchCameraIdle();
            }
        });
        return animator;
    }

    void zoomInAnimated(@NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.zoomAnimated(true, zoomFocalPoint, runImmediately);
    }

    void zoomOutAnimated(@NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.zoomAnimated(false, zoomFocalPoint, runImmediately);
    }

    private void zoomAnimated(boolean zoomIn, @NonNull PointF zoomFocalPoint, boolean runImmediately) {
        this.cancelAnimator(this.scaleAnimator);
        double currentZoom = this.transform.getRawZoom();
        this.scaleAnimator = this.createScaleAnimator(currentZoom, zoomIn ? 1.0 : -1.0, zoomFocalPoint, 300L);
        if (runImmediately) {
            this.scaleAnimator.start();
        } else {
            this.scheduleAnimator(this.scaleAnimator);
        }
    }

    private void dispatchCameraIdle() {
        if (this.noGesturesInProgress()) {
            this.transform.invalidateCameraPosition();
            this.cameraChangeDispatcher.onCameraIdle();
        }
    }

    private void cancelTransitionsIfRequired() {
        if (this.noGesturesInProgress()) {
            this.transform.cancelTransitions();
        }
    }

    private boolean noGesturesInProgress() {
        return !(this.uiSettings.isScrollGesturesEnabled() && this.gesturesManager.getMoveGestureDetector().isInProgress() || this.uiSettings.isZoomGesturesEnabled() && this.gesturesManager.getStandardScaleGestureDetector().isInProgress() || this.uiSettings.isRotateGesturesEnabled() && this.gesturesManager.getRotateGestureDetector().isInProgress() || this.uiSettings.isTiltGesturesEnabled() && this.gesturesManager.getShoveGestureDetector().isInProgress());
    }

    void notifyOnMapClickListeners(@NonNull PointF tapPoint) {
        for (MapboxMap.OnMapClickListener listener : this.onMapClickListenerList) {
            if (!listener.onMapClick(this.projection.fromScreenLocation(tapPoint))) continue;
            return;
        }
    }

    void notifyOnMapLongClickListeners(@NonNull PointF longClickPoint) {
        for (MapboxMap.OnMapLongClickListener listener : this.onMapLongClickListenerList) {
            if (!listener.onMapLongClick(this.projection.fromScreenLocation(longClickPoint))) continue;
            return;
        }
    }

    void notifyOnFlingListeners() {
        for (MapboxMap.OnFlingListener listener : this.onFlingListenerList) {
            listener.onFling();
        }
    }

    void notifyOnMoveBeginListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMoveBegin(detector);
        }
    }

    void notifyOnMoveListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMove(detector);
        }
    }

    void notifyOnMoveEndListeners(@NonNull MoveGestureDetector detector) {
        for (MapboxMap.OnMoveListener listener : this.onMoveListenerList) {
            listener.onMoveEnd(detector);
        }
    }

    void notifyOnRotateBeginListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotateBegin(detector);
        }
    }

    void notifyOnRotateListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotate(detector);
        }
    }

    void notifyOnRotateEndListeners(@NonNull RotateGestureDetector detector) {
        for (MapboxMap.OnRotateListener listener : this.onRotateListenerList) {
            listener.onRotateEnd(detector);
        }
    }

    void notifyOnScaleBeginListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScaleBegin(detector);
        }
    }

    void notifyOnScaleListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScale(detector);
        }
    }

    void notifyOnScaleEndListeners(@NonNull StandardScaleGestureDetector detector) {
        for (MapboxMap.OnScaleListener listener : this.onScaleListenerList) {
            listener.onScaleEnd(detector);
        }
    }

    void notifyOnShoveBeginListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShoveBegin(detector);
        }
    }

    void notifyOnShoveListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShove(detector);
        }
    }

    void notifyOnShoveEndListeners(@NonNull ShoveGestureDetector detector) {
        for (MapboxMap.OnShoveListener listener : this.onShoveListenerList) {
            listener.onShoveEnd(detector);
        }
    }

    void addOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.add(onMapClickListener);
    }

    void removeOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.remove(onMapClickListener);
    }

    void addOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.add(onMapLongClickListener);
    }

    void removeOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.remove(onMapLongClickListener);
    }

    void addOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.add(onFlingListener);
    }

    void removeOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.remove(onFlingListener);
    }

    void addOnMoveListener(MapboxMap.OnMoveListener listener) {
        this.onMoveListenerList.add(listener);
    }

    void removeOnMoveListener(MapboxMap.OnMoveListener listener) {
        this.onMoveListenerList.remove(listener);
    }

    void addOnRotateListener(MapboxMap.OnRotateListener listener) {
        this.onRotateListenerList.add(listener);
    }

    void removeOnRotateListener(MapboxMap.OnRotateListener listener) {
        this.onRotateListenerList.remove(listener);
    }

    void addOnScaleListener(MapboxMap.OnScaleListener listener) {
        this.onScaleListenerList.add(listener);
    }

    void removeOnScaleListener(MapboxMap.OnScaleListener listener) {
        this.onScaleListenerList.remove(listener);
    }

    void addShoveListener(MapboxMap.OnShoveListener listener) {
        this.onShoveListenerList.add(listener);
    }

    void removeShoveListener(MapboxMap.OnShoveListener listener) {
        this.onShoveListenerList.remove(listener);
    }

    AndroidGesturesManager getGesturesManager() {
        return this.gesturesManager;
    }

    void setGesturesManager(@NonNull Context context, @NonNull AndroidGesturesManager gesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
        this.initializeGesturesManager(gesturesManager, setDefaultMutuallyExclusives);
        this.initializeGestureListeners(context, attachDefaultListeners);
    }

    private final class TapGestureListener
    implements MultiFingerTapGestureDetector.OnMultiFingerTapGestureListener {
        private TapGestureListener() {
        }

        public boolean onMultiFingerTap(@NonNull MultiFingerTapGestureDetector detector, int pointersCount) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() || pointersCount != 2) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            PointF zoomFocalPoint = MapGestureDetector.this.constantFocalPoint != null ? MapGestureDetector.this.constantFocalPoint : detector.getFocalPoint();
            MapGestureDetector.this.zoomOutAnimated(zoomFocalPoint, false);
            return true;
        }
    }

    private final class ShoveGestureListener
    extends ShoveGestureDetector.SimpleOnShoveGestureListener {
        private ShoveGestureListener() {
        }

        public boolean onShoveBegin(@NonNull ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
            MapGestureDetector.this.notifyOnShoveBeginListeners(detector);
            return true;
        }

        public boolean onShove(@NonNull ShoveGestureDetector detector, float deltaPixelsSinceLast, float deltaPixelsSinceStart) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double pitch = MapGestureDetector.this.transform.getTilt();
            pitch -= (double)(0.1f * deltaPixelsSinceLast);
            pitch = MathUtils.clamp(pitch, 0.0, 60.0);
            MapGestureDetector.this.transform.setTilt(pitch);
            MapGestureDetector.this.notifyOnShoveListeners(detector);
            return true;
        }

        public void onShoveEnd(@NonNull ShoveGestureDetector detector, float velocityX, float velocityY) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            MapGestureDetector.this.notifyOnShoveEndListeners(detector);
        }
    }

    private final class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        private final float minimumScaleSpanWhenRotating;
        private final float angularVelocityMultiplier;
        private final float minimumAngularVelocity;
        private final double rotateVelocityRatioThreshold;
        private final float defaultSpanSinceStartThreshold;

        RotateGestureListener(float minimumScaleSpanWhenRotating, double densityMultiplier, float angularVelocityMultiplier, float minimumAngularVelocity, float defaultSpanSinceStartThreshold) {
            this.minimumScaleSpanWhenRotating = minimumScaleSpanWhenRotating;
            this.angularVelocityMultiplier = angularVelocityMultiplier;
            this.minimumAngularVelocity = minimumAngularVelocity;
            this.rotateVelocityRatioThreshold = 2.2000000000000003E-4 * densityMultiplier;
            this.defaultSpanSinceStartThreshold = defaultSpanSinceStartThreshold;
        }

        public boolean onRotateBegin(@NonNull RotateGestureDetector detector) {
            double prevTime;
            if (!MapGestureDetector.this.uiSettings.isRotateGesturesEnabled()) {
                return false;
            }
            float deltaSinceLast = Math.abs(detector.getDeltaSinceLast());
            double currTime = detector.getCurrentEvent().getEventTime();
            if (currTime == (prevTime = (double)detector.getPreviousEvent().getEventTime())) {
                return false;
            }
            double speed = (double)deltaSinceLast / (currTime - prevTime);
            float deltaSinceStart = Math.abs(detector.getDeltaSinceStart());
            if (speed < 0.04 || speed > 0.07 && deltaSinceStart < 5.0f || speed > 0.15 && deltaSinceStart < 7.0f || speed > 0.5 && deltaSinceStart < 15.0f) {
                return false;
            }
            if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.minimumScaleSpanWhenRotating);
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().interrupt();
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.notifyOnRotateBeginListeners(detector);
            return true;
        }

        public boolean onRotate(@NonNull RotateGestureDetector detector, float rotationDegreesSinceLast, float rotationDegreesSinceFirst) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double bearing = MapGestureDetector.this.transform.getRawBearing() + (double)rotationDegreesSinceLast;
            PointF focalPoint = this.getRotateFocalPoint(detector);
            MapGestureDetector.this.transform.setBearing(bearing, focalPoint.x, focalPoint.y);
            MapGestureDetector.this.notifyOnRotateListeners(detector);
            return true;
        }

        public void onRotateEnd(@NonNull RotateGestureDetector detector, float velocityX, float velocityY, float angularVelocity) {
            if (MapGestureDetector.this.uiSettings.isIncreaseScaleThresholdWhenRotating()) {
                MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().setSpanSinceStartThreshold(this.defaultSpanSinceStartThreshold);
            }
            MapGestureDetector.this.notifyOnRotateEndListeners(detector);
            angularVelocity *= this.angularVelocityMultiplier;
            angularVelocity = MathUtils.clamp(angularVelocity, -30.0f, 30.0f);
            float velocityXY = Math.abs(velocityX) + Math.abs(velocityY);
            float delta = Math.abs(detector.getDeltaSinceLast());
            double ratio = delta / velocityXY;
            if (!MapGestureDetector.this.uiSettings.isRotateVelocityAnimationEnabled() || Math.abs(angularVelocity) < this.minimumAngularVelocity || MapGestureDetector.this.gesturesManager.getStandardScaleGestureDetector().isInProgress() && ratio < this.rotateVelocityRatioThreshold) {
                MapGestureDetector.this.dispatchCameraIdle();
                return;
            }
            long animationTime = (long)((Math.log((double)Math.abs(angularVelocity) + 1.0 / Math.pow(Math.E, 2.0)) + 2.0) * 150.0);
            PointF focalPoint = this.getRotateFocalPoint(detector);
            MapGestureDetector.this.rotateAnimator = this.createRotateAnimator(angularVelocity, animationTime, focalPoint);
            MapGestureDetector.this.scheduleAnimator(MapGestureDetector.this.rotateAnimator);
        }

        @NonNull
        private PointF getRotateFocalPoint(@NonNull RotateGestureDetector detector) {
            if (MapGestureDetector.this.constantFocalPoint != null) {
                return MapGestureDetector.this.constantFocalPoint;
            }
            return detector.getFocalPoint();
        }

        private Animator createRotateAnimator(float angularVelocity, long animationTime, final @NonNull PointF animationFocalPoint) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{angularVelocity, 0.0f});
            animator.setDuration(animationTime);
            animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                    MapGestureDetector.this.transform.setBearing(MapGestureDetector.this.transform.getRawBearing() + (double)((Float)animation.getAnimatedValue()).floatValue(), animationFocalPoint.x, animationFocalPoint.y, 0L);
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    MapGestureDetector.this.transform.cancelTransitions();
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                }

                public void onAnimationCancel(Animator animation) {
                    MapGestureDetector.this.transform.cancelTransitions();
                }

                public void onAnimationEnd(Animator animation) {
                    MapGestureDetector.this.dispatchCameraIdle();
                }
            });
            return animator;
        }
    }

    private final class ScaleGestureListener
    extends StandardScaleGestureDetector.SimpleStandardOnScaleGestureListener {
        private final float minimumGestureSpeed;
        private final float minimumAngledGestureSpeed;
        private final float minimumVelocity;
        private final double scaleVelocityRatioThreshold;
        private boolean quickZoom;
        private float spanSinceLast;
        private double screenHeight;
        private double startZoom;

        ScaleGestureListener(double densityMultiplier, float minimumGestureSpeed, float minimumAngledGestureSpeed, float minimumVelocity) {
            this.minimumGestureSpeed = minimumGestureSpeed;
            this.minimumAngledGestureSpeed = minimumAngledGestureSpeed;
            this.minimumVelocity = minimumVelocity;
            this.scaleVelocityRatioThreshold = 0.004 * densityMultiplier;
        }

        public boolean onScaleBegin(@NonNull StandardScaleGestureDetector detector) {
            boolean bl = this.quickZoom = detector.getPointersCount() == 1;
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            if (this.quickZoom) {
                if (!MapGestureDetector.this.uiSettings.isQuickZoomGesturesEnabled()) {
                    return false;
                }
                MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(false);
            } else if (detector.getPreviousSpan() > 0.0f) {
                double prevTime;
                float currSpan = detector.getCurrentSpan();
                float prevSpan = detector.getPreviousSpan();
                double currTime = detector.getCurrentEvent().getEventTime();
                if (currTime == (prevTime = (double)detector.getPreviousEvent().getEventTime())) {
                    return false;
                }
                double speed = (double)Math.abs(currSpan - prevSpan) / (currTime - prevTime);
                if (speed < (double)this.minimumGestureSpeed) {
                    return false;
                }
                if (!MapGestureDetector.this.gesturesManager.getRotateGestureDetector().isInProgress()) {
                    float rotationDeltaSinceLast = MapGestureDetector.this.gesturesManager.getRotateGestureDetector().getDeltaSinceLast();
                    if ((double)Math.abs(rotationDeltaSinceLast) > 0.4 && speed < (double)this.minimumAngledGestureSpeed) {
                        return false;
                    }
                    if (MapGestureDetector.this.uiSettings.isDisableRotateWhenScaling()) {
                        MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setEnabled(false);
                    }
                }
            } else {
                return false;
            }
            this.screenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;
            this.startZoom = MapGestureDetector.this.transform.getRawZoom();
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.notifyOnScaleBeginListeners(detector);
            this.spanSinceLast = Math.abs(detector.getCurrentSpan() - detector.getPreviousSpan());
            return true;
        }

        public boolean onScale(@NonNull StandardScaleGestureDetector detector) {
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            PointF focalPoint = this.getScaleFocalPoint(detector);
            if (this.quickZoom) {
                double pixelDeltaChange = Math.abs(detector.getCurrentEvent().getY() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y);
                boolean zoomedOut = detector.getCurrentEvent().getY() < ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y;
                double normalizedDeltaChange = MathUtils.normalize(pixelDeltaChange, 0.0, this.screenHeight, 0.0, 4.0);
                double targetZoom = zoomedOut ? this.startZoom - normalizedDeltaChange : this.startZoom + normalizedDeltaChange;
                MapGestureDetector.this.transform.setZoom(targetZoom *= (double)MapGestureDetector.this.uiSettings.getZoomRate(), focalPoint);
            } else {
                double zoomBy = Math.log(detector.getScaleFactor()) / Math.log(1.5707963267948966) * (double)0.65f * (double)MapGestureDetector.this.uiSettings.getZoomRate();
                MapGestureDetector.this.transform.zoomBy(zoomBy, focalPoint);
            }
            MapGestureDetector.this.notifyOnScaleListeners(detector);
            this.spanSinceLast = Math.abs(detector.getCurrentSpan() - detector.getPreviousSpan());
            return true;
        }

        public void onScaleEnd(@NonNull StandardScaleGestureDetector detector, float velocityX, float velocityY) {
            if (this.quickZoom) {
                MapGestureDetector.this.gesturesManager.getMoveGestureDetector().setEnabled(true);
            } else {
                MapGestureDetector.this.gesturesManager.getRotateGestureDetector().setEnabled(true);
            }
            MapGestureDetector.this.notifyOnScaleEndListeners(detector);
            float velocityXY = Math.abs(velocityX) + Math.abs(velocityY);
            if (!MapGestureDetector.this.uiSettings.isScaleVelocityAnimationEnabled() || velocityXY < this.minimumVelocity || (double)(this.spanSinceLast / velocityXY) < this.scaleVelocityRatioThreshold) {
                MapGestureDetector.this.dispatchCameraIdle();
                return;
            }
            double zoomAddition = this.calculateScale(velocityXY, detector.isScalingOut());
            double currentZoom = MapGestureDetector.this.transform.getRawZoom();
            PointF focalPoint = this.getScaleFocalPoint(detector);
            long animationTime = (long)((Math.log(Math.abs(zoomAddition) + 1.0 / Math.pow(Math.E, 2.0)) + 2.0) * 150.0);
            MapGestureDetector.this.scaleAnimator = MapGestureDetector.this.createScaleAnimator(currentZoom, zoomAddition, focalPoint, animationTime);
            MapGestureDetector.this.scheduleAnimator(MapGestureDetector.this.scaleAnimator);
        }

        @NonNull
        private PointF getScaleFocalPoint(@NonNull StandardScaleGestureDetector detector) {
            if (MapGestureDetector.this.constantFocalPoint != null) {
                return MapGestureDetector.this.constantFocalPoint;
            }
            if (this.quickZoom) {
                return new PointF(MapGestureDetector.this.uiSettings.getWidth() / 2.0f, MapGestureDetector.this.uiSettings.getHeight() / 2.0f);
            }
            return detector.getFocalPoint();
        }

        private double calculateScale(double velocityXY, boolean isScalingOut) {
            double zoomAddition = velocityXY * 2.5 * 1.0E-4;
            zoomAddition = MathUtils.clamp(zoomAddition, 0.0, 2.5);
            if (isScalingOut) {
                zoomAddition = -zoomAddition;
            }
            return zoomAddition;
        }
    }

    private final class MoveGestureListener
    extends MoveGestureDetector.SimpleOnMoveGestureListener {
        private MoveGestureListener() {
        }

        public boolean onMoveBegin(@NonNull MoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cancelTransitionsIfRequired();
            MapGestureDetector.this.notifyOnMoveBeginListeners(detector);
            return true;
        }

        public boolean onMove(@NonNull MoveGestureDetector detector, float distanceX, float distanceY) {
            if (distanceX != 0.0f || distanceY != 0.0f) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                MapGestureDetector.this.transform.moveBy(-distanceX, -distanceY, 0L);
                MapGestureDetector.this.notifyOnMoveListeners(detector);
            }
            return true;
        }

        public void onMoveEnd(@NonNull MoveGestureDetector detector, float velocityX, float velocityY) {
            MapGestureDetector.this.dispatchCameraIdle();
            MapGestureDetector.this.notifyOnMoveEndListeners(detector);
        }
    }

    private final class StandardGestureListener
    extends StandardGestureDetector.SimpleStandardOnGestureListener {
        private final float doubleTapMovementThreshold;

        StandardGestureListener(float doubleTapMovementThreshold) {
            this.doubleTapMovementThreshold = doubleTapMovementThreshold;
        }

        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            MapGestureDetector.this.transform.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            PointF tapPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            boolean tapHandled = MapGestureDetector.this.annotationManager.onTap(tapPoint);
            if (!tapHandled) {
                if (MapGestureDetector.this.uiSettings.isDeselectMarkersOnTap()) {
                    MapGestureDetector.this.annotationManager.deselectMarkers();
                }
                MapGestureDetector.this.notifyOnMapClickListeners(tapPoint);
            }
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            int action = motionEvent.getActionMasked();
            if (action == 0) {
                MapGestureDetector.this.doubleTapFocalPoint = new PointF(motionEvent.getX(), motionEvent.getY());
                MapGestureDetector.this.doubleTapStarted();
            }
            if (motionEvent.getActionMasked() == 1) {
                float diffX = Math.abs(motionEvent.getX() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.x);
                float diffY = Math.abs(motionEvent.getY() - ((MapGestureDetector)MapGestureDetector.this).doubleTapFocalPoint.y);
                if (diffX > this.doubleTapMovementThreshold || diffY > this.doubleTapMovementThreshold) {
                    return false;
                }
                if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() || !MapGestureDetector.this.uiSettings.isDoubleTapGesturesEnabled()) {
                    return false;
                }
                if (MapGestureDetector.this.constantFocalPoint != null) {
                    MapGestureDetector.this.doubleTapFocalPoint = MapGestureDetector.this.constantFocalPoint;
                }
                MapGestureDetector.this.zoomInAnimated(MapGestureDetector.this.doubleTapFocalPoint, false);
                return true;
            }
            return super.onDoubleTapEvent(motionEvent);
        }

        public void onLongPress(MotionEvent motionEvent) {
            PointF longClickPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            MapGestureDetector.this.notifyOnMapLongClickListeners(longClickPoint);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapGestureDetector.this.uiSettings.isScrollGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.notifyOnFlingListeners();
            if (!MapGestureDetector.this.uiSettings.isFlingVelocityAnimationEnabled()) {
                return false;
            }
            float screenDensity = MapGestureDetector.this.uiSettings.getPixelRatio();
            double velocityXY = Math.hypot(velocityX / screenDensity, velocityY / screenDensity);
            if (velocityXY < 1000.0) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double tilt = MapGestureDetector.this.transform.getTilt();
            double tiltFactor = 1.5 + (tilt != 0.0 ? tilt / 10.0 : 0.0);
            double offsetX = (double)velocityX / tiltFactor / (double)screenDensity;
            double offsetY = (double)velocityY / tiltFactor / (double)screenDensity;
            long animationTime = (long)(velocityXY / 7.0 / tiltFactor + 150.0);
            MapGestureDetector.this.transform.moveBy(offsetX, offsetY, animationTime);
            return true;
        }
    }
}

