/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.Mapbox;

public class HttpRequestUrl {
    private HttpRequestUrl() {
    }

    public static String buildResourceUrl(@NonNull String host, String resourceUrl, int querySize, boolean offline) {
        if (HttpRequestUrl.isValidMapboxEndpoint(host)) {
            resourceUrl = querySize == 0 ? resourceUrl + "?" : resourceUrl + "&";
            resourceUrl = offline ? resourceUrl + "offline=true" : resourceUrl + "sku=" + Mapbox.getSkuToken();
        }
        return resourceUrl;
    }

    private static boolean isValidMapboxEndpoint(String host) {
        return host.equals("mapbox.com") || host.endsWith(".mapbox.com") || host.equals("mapbox.cn") || host.endsWith(".mapbox.cn");
    }
}

