/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Source {
    private static final String TAG = "Mbgl-Source";
    @Keep
    private long nativePtr;
    protected boolean detached;

    @Keep
    protected Source(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public Source() {
        this.checkThread();
    }

    protected void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    @NonNull
    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    @NonNull
    public String getAttribution() {
        this.checkThread();
        return this.nativeGetAttribution();
    }

    public long getNativePtr() {
        return this.nativePtr;
    }

    @NonNull
    @Keep
    protected native String nativeGetId();

    @NonNull
    @Keep
    protected native String nativeGetAttribution();

    public void setDetached() {
        this.detached = true;
    }

    static {
        LibraryLoader.load();
    }
}

