/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Style {
    static final String EMPTY_JSON = "{\"version\": 8,\"sources\": {},\"layers\": []}";
    private final NativeMap nativeMap;
    private final HashMap<String, Source> sources = new HashMap();
    private final HashMap<String, Layer> layers = new HashMap();
    private final HashMap<String, Bitmap> images = new HashMap();
    private final Builder builder;
    private boolean fullyLoaded;
    public static final String MAPBOX_STREETS = "mapbox://styles/mapbox/streets-v11";
    public static final String OUTDOORS = "mapbox://styles/mapbox/outdoors-v11";
    public static final String LIGHT = "mapbox://styles/mapbox/light-v10";
    public static final String DARK = "mapbox://styles/mapbox/dark-v10";
    public static final String SATELLITE = "mapbox://styles/mapbox/satellite-v9";
    public static final String SATELLITE_STREETS = "mapbox://styles/mapbox/satellite-streets-v11";
    public static final String TRAFFIC_DAY = "mapbox://styles/mapbox/traffic-day-v2";
    public static final String TRAFFIC_NIGHT = "mapbox://styles/mapbox/traffic-night-v2";

    private Style(@NonNull Builder builder, @NonNull NativeMap nativeMap) {
        this.builder = builder;
        this.nativeMap = nativeMap;
    }

    @Deprecated
    @NonNull
    public String getUrl() {
        this.validateState("getUrl");
        return this.nativeMap.getStyleUri();
    }

    @NonNull
    public String getUri() {
        this.validateState("getUri");
        return this.nativeMap.getStyleUri();
    }

    @NonNull
    public String getJson() {
        this.validateState("getJson");
        return this.nativeMap.getStyleJson();
    }

    @NonNull
    public List<Source> getSources() {
        this.validateState("getSources");
        return this.nativeMap.getSources();
    }

    public void addSource(@NonNull Source source) {
        this.validateState("addSource");
        this.nativeMap.addSource(source);
        this.sources.put(source.getId(), source);
    }

    @Nullable
    public Source getSource(String id2) {
        this.validateState("getSource");
        Source source = this.sources.get(id2);
        if (source == null) {
            source = this.nativeMap.getSource(id2);
        }
        return source;
    }

    @Nullable
    public <T extends Source> T getSourceAs(@NonNull String sourceId) {
        this.validateState("getSourceAs");
        if (this.sources.containsKey(sourceId)) {
            return (T)this.sources.get(sourceId);
        }
        return (T)this.nativeMap.getSource(sourceId);
    }

    public boolean removeSource(@NonNull String sourceId) {
        this.validateState("removeSource");
        this.sources.remove(sourceId);
        return this.nativeMap.removeSource(sourceId);
    }

    public boolean removeSource(@NonNull Source source) {
        this.validateState("removeSource");
        this.sources.remove(source.getId());
        return this.nativeMap.removeSource(source);
    }

    public void addLayer(@NonNull Layer layer) {
        this.validateState("addLayer");
        this.nativeMap.addLayer(layer);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        this.validateState("addLayerBelow");
        this.nativeMap.addLayerBelow(layer, below);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        this.validateState("addLayerAbove");
        this.nativeMap.addLayerAbove(layer, above);
        this.layers.put(layer.getId(), layer);
    }

    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        this.validateState("addLayerAbove");
        this.nativeMap.addLayerAt(layer, index);
        this.layers.put(layer.getId(), layer);
    }

    @Nullable
    public Layer getLayer(@NonNull String id2) {
        this.validateState("getLayer");
        Layer layer = this.layers.get(id2);
        if (layer == null) {
            layer = this.nativeMap.getLayer(id2);
        }
        return layer;
    }

    @Nullable
    public <T extends Layer> T getLayerAs(@NonNull String layerId) {
        this.validateState("getLayerAs");
        return (T)this.nativeMap.getLayer(layerId);
    }

    @NonNull
    public List<Layer> getLayers() {
        this.validateState("getLayers");
        return this.nativeMap.getLayers();
    }

    public boolean removeLayer(@NonNull String layerId) {
        this.validateState("removeLayer");
        this.layers.remove(layerId);
        return this.nativeMap.removeLayer(layerId);
    }

    public boolean removeLayer(@NonNull Layer layer) {
        this.validateState("removeLayer");
        this.layers.remove(layer.getId());
        return this.nativeMap.removeLayer(layer);
    }

    public boolean removeLayerAt(@IntRange(from=0L) int index) {
        this.validateState("removeLayerAt");
        return this.nativeMap.removeLayerAt(index);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        this.addImage(name, image, false);
    }

    public void addImage(@NonNull String name, @NonNull Drawable drawable2) {
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (bitmap == null) {
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }
        this.addImage(name, bitmap, false);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap bitmap, boolean sdf) {
        this.validateState("addImage");
        this.nativeMap.addImages(new Image[]{Style.toImage(new Builder.ImageWrapper(name, bitmap, sdf))});
    }

    public void addImageAsync(@NonNull String name, @NonNull Bitmap image) {
        this.addImageAsync(name, image, false);
    }

    public void addImageAsync(@NonNull String name, @NonNull Drawable drawable2) {
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (bitmap == null) {
            throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
        }
        this.addImageAsync(name, bitmap, false);
    }

    public void addImageAsync(@NonNull String name, @NonNull Bitmap bitmap, boolean sdf) {
        this.validateState("addImage");
        new BitmapImageConversionTask(this.nativeMap).execute(new Builder.ImageWrapper[]{new Builder.ImageWrapper(name, bitmap, sdf)});
    }

    public void addImages(@NonNull HashMap<String, Bitmap> images) {
        this.addImages(images, false);
    }

    public void addImages(@NonNull HashMap<String, Bitmap> images, boolean sdf) {
        this.validateState("addImage");
        Image[] convertedImages = new Image[images.size()];
        int index = 0;
        for (Builder.ImageWrapper imageWrapper : Builder.ImageWrapper.convertToImageArray(images, sdf)) {
            convertedImages[index] = Style.toImage(imageWrapper);
            ++index;
        }
        this.nativeMap.addImages(convertedImages);
    }

    public void addImagesAsync(@NonNull HashMap<String, Bitmap> images) {
        this.addImagesAsync(images, false);
    }

    public void addImagesAsync(@NonNull HashMap<String, Bitmap> images, boolean sdf) {
        this.validateState("addImages");
        new BitmapImageConversionTask(this.nativeMap).execute(Builder.ImageWrapper.convertToImageArray(images, sdf));
    }

    public void removeImage(@NonNull String name) {
        this.validateState("removeImage");
        this.nativeMap.removeImage(name);
    }

    @Nullable
    public Bitmap getImage(@NonNull String id2) {
        this.validateState("getImage");
        return this.nativeMap.getImage(id2);
    }

    public void setTransition(@NonNull TransitionOptions transitionOptions) {
        this.validateState("setTransition");
        this.nativeMap.setTransitionOptions(transitionOptions);
    }

    @NonNull
    public TransitionOptions getTransition() {
        this.validateState("getTransition");
        return this.nativeMap.getTransitionOptions();
    }

    @Nullable
    public Light getLight() {
        this.validateState("getLight");
        return this.nativeMap.getLight();
    }

    void clear() {
        this.fullyLoaded = false;
        for (Layer layer : this.layers.values()) {
            if (layer == null) continue;
            layer.setDetached();
        }
        for (Source source : this.sources.values()) {
            if (source == null) continue;
            source.setDetached();
        }
        for (Map.Entry entry : this.images.entrySet()) {
            this.nativeMap.removeImage((String)entry.getKey());
            ((Bitmap)entry.getValue()).recycle();
        }
        this.sources.clear();
        this.layers.clear();
        this.images.clear();
    }

    void onDidFinishLoadingStyle() {
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            for (Source source : this.builder.sources) {
                this.addSource(source);
            }
            for (Builder.LayerWrapper layerWrapper : this.builder.layers) {
                if (layerWrapper instanceof Builder.LayerAtWrapper) {
                    this.addLayerAt(layerWrapper.layer, ((Builder.LayerAtWrapper)layerWrapper).index);
                    continue;
                }
                if (layerWrapper instanceof Builder.LayerAboveWrapper) {
                    this.addLayerAbove(layerWrapper.layer, ((Builder.LayerAboveWrapper)layerWrapper).aboveLayer);
                    continue;
                }
                if (layerWrapper instanceof Builder.LayerBelowWrapper) {
                    this.addLayerBelow(layerWrapper.layer, ((Builder.LayerBelowWrapper)layerWrapper).belowLayer);
                    continue;
                }
                this.addLayerBelow(layerWrapper.layer, "com.mapbox.annotations.points");
            }
            for (Builder.ImageWrapper image : this.builder.images) {
                this.addImage(image.id, image.bitmap, image.sdf);
            }
            if (this.builder.transitionOptions != null) {
                this.setTransition(this.builder.transitionOptions);
            }
        }
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    private void validateState(String methodCall) {
        if (!this.fullyLoaded) {
            throw new IllegalStateException(String.format("Calling %s when a newer style is loading/has loaded.", methodCall));
        }
    }

    private static Image toImage(Builder.ImageWrapper imageWrapper) {
        Bitmap bitmap = imageWrapper.bitmap;
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getByteCount());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        float pixelRatio = (float)bitmap.getDensity() / 160.0f;
        return new Image(buffer.array(), pixelRatio, imageWrapper.id, bitmap.getWidth(), bitmap.getHeight(), imageWrapper.sdf);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleUrl {
    }

    public static interface OnStyleLoaded {
        public void onStyleLoaded(@NonNull Style var1);
    }

    private static class BitmapImageConversionTask
    extends AsyncTask<Builder.ImageWrapper, Void, Image[]> {
        private WeakReference<NativeMap> nativeMap;

        BitmapImageConversionTask(NativeMap nativeMap) {
            this.nativeMap = new WeakReference<NativeMap>(nativeMap);
        }

        @NonNull
        protected Image[] doInBackground(Builder.ImageWrapper ... params) {
            ArrayList<Image> images = new ArrayList<Image>();
            for (Builder.ImageWrapper param : params) {
                images.add(Style.toImage(param));
            }
            return images.toArray(new Image[images.size()]);
        }

        protected void onPostExecute(@NonNull Image[] images) {
            super.onPostExecute((Object)images);
            NativeMap nativeMap = (NativeMap)this.nativeMap.get();
            if (nativeMap != null && !nativeMap.isDestroyed()) {
                nativeMap.addImages(images);
            }
        }
    }

    public static class Builder {
        private final List<Source> sources = new ArrayList<Source>();
        private final List<LayerWrapper> layers = new ArrayList<LayerWrapper>();
        private final List<ImageWrapper> images = new ArrayList<ImageWrapper>();
        private TransitionOptions transitionOptions;
        private String styleUri;
        private String styleJson;

        @Deprecated
        @NonNull
        public Builder fromUrl(@NonNull String url) {
            this.styleUri = url;
            return this;
        }

        @NonNull
        public Builder fromUri(@NonNull String uri) {
            this.styleUri = uri;
            return this;
        }

        @NonNull
        public Builder fromJson(@NonNull String styleJson) {
            this.styleJson = styleJson;
            return this;
        }

        @NonNull
        public Builder withSource(@NonNull Source source) {
            this.sources.add(source);
            return this;
        }

        @NonNull
        public Builder withSources(Source ... sources) {
            this.sources.addAll(Arrays.asList(sources));
            return this;
        }

        @NonNull
        public Builder withLayer(@NonNull Layer layer) {
            this.layers.add(new LayerWrapper(layer));
            return this;
        }

        @NonNull
        public Builder withLayers(Layer ... layers) {
            for (Layer layer : layers) {
                this.layers.add(new LayerWrapper(layer));
            }
            return this;
        }

        @NonNull
        public Builder withLayerAt(@NonNull Layer layer, int index) {
            this.layers.add(new LayerAtWrapper(layer, index));
            return this;
        }

        @NonNull
        public Builder withLayerAbove(@NonNull Layer layer, @NonNull String aboveLayerId) {
            this.layers.add(new LayerAboveWrapper(layer, aboveLayerId));
            return this;
        }

        @NonNull
        public Builder withLayerBelow(@NonNull Layer layer, @NonNull String belowLayerId) {
            this.layers.add(new LayerBelowWrapper(layer, belowLayerId));
            return this;
        }

        @NonNull
        public Builder withTransition(@NonNull TransitionOptions transition) {
            this.transitionOptions = transition;
            return this;
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Drawable drawable2) {
            Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
            if (bitmap == null) {
                throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
            }
            return this.withImage(id2, bitmap, false);
        }

        @NonNull
        public Builder withDrawableImages(Pair<String, Drawable> ... values) {
            return this.withDrawableImages(false, values);
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Bitmap image) {
            return this.withImage(id2, image, false);
        }

        @NonNull
        public Builder withBitmapImages(Pair<String, Bitmap> ... values) {
            for (Pair<String, Bitmap> value : values) {
                this.withImage((String)value.first, (Bitmap)value.second, false);
            }
            return this;
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Drawable drawable2, boolean sdf) {
            Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
            if (bitmap == null) {
                throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
            }
            return this.withImage(id2, bitmap, sdf);
        }

        @NonNull
        public Builder withDrawableImages(boolean sdf, Pair<String, Drawable> ... values) {
            for (Pair<String, Drawable> value : values) {
                Bitmap bitmap = BitmapUtils.getBitmapFromDrawable((Drawable)value.second);
                if (bitmap == null) {
                    throw new IllegalArgumentException("Provided drawable couldn't be converted to a Bitmap.");
                }
                this.withImage((String)value.first, bitmap, sdf);
            }
            return this;
        }

        @NonNull
        public Builder withImage(@NonNull String id2, @NonNull Bitmap image, boolean sdf) {
            this.images.add(new ImageWrapper(id2, image, sdf));
            return this;
        }

        @NonNull
        public Builder withBitmapImages(boolean sdf, Pair<String, Bitmap> ... values) {
            for (Pair<String, Bitmap> value : values) {
                this.withImage((String)value.first, (Bitmap)value.second, sdf);
            }
            return this;
        }

        String getUri() {
            return this.styleUri;
        }

        String getJson() {
            return this.styleJson;
        }

        List<Source> getSources() {
            return this.sources;
        }

        List<LayerWrapper> getLayers() {
            return this.layers;
        }

        List<ImageWrapper> getImages() {
            return this.images;
        }

        TransitionOptions getTransitionOptions() {
            return this.transitionOptions;
        }

        Style build(@NonNull NativeMap nativeMap) {
            return new Style(this, nativeMap);
        }

        class LayerAtWrapper
        extends LayerWrapper {
            int index;

            LayerAtWrapper(Layer layer, int index) {
                super(layer);
                this.index = index;
            }
        }

        class LayerBelowWrapper
        extends LayerWrapper {
            String belowLayer;

            LayerBelowWrapper(Layer layer, String belowLayer) {
                super(layer);
                this.belowLayer = belowLayer;
            }
        }

        class LayerAboveWrapper
        extends LayerWrapper {
            String aboveLayer;

            LayerAboveWrapper(Layer layer, String aboveLayer) {
                super(layer);
                this.aboveLayer = aboveLayer;
            }
        }

        class LayerWrapper {
            Layer layer;

            LayerWrapper(Layer layer) {
                this.layer = layer;
            }
        }

        static class ImageWrapper {
            Bitmap bitmap;
            String id;
            boolean sdf;

            ImageWrapper(String id2, Bitmap bitmap, boolean sdf) {
                this.id = id2;
                this.bitmap = bitmap;
                this.sdf = sdf;
            }

            static ImageWrapper[] convertToImageArray(HashMap<String, Bitmap> bitmapHashMap, boolean sdf) {
                ImageWrapper[] images = new ImageWrapper[bitmapHashMap.size()];
                ArrayList<String> keyList = new ArrayList<String>(bitmapHashMap.keySet());
                for (int i = 0; i < bitmapHashMap.size(); ++i) {
                    String id2 = (String)keyList.get(i);
                    images[i] = new ImageWrapper(id2, bitmapHashMap.get(id2), sdf);
                }
                return images;
            }
        }
    }
}

