/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.res.ResourcesCompat;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.AttributionLayout;
import com.mapbox.mapboxsdk.attribution.AttributionMeasure;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.snapshotter.MapSnapshot;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.FontUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

@UiThread
public class MapSnapshotter {
    private static final String TAG = "Mbgl-MapSnapshotter";
    private static final int LOGO_MARGIN_DP = 4;
    @Keep
    private long nativePtr = 0L;
    private final Context context;
    @Nullable
    private SnapshotReadyCallback callback;
    @Nullable
    private ErrorHandler errorHandler;

    public MapSnapshotter(@NonNull Context context, @NonNull Options options) {
        this.checkThread();
        this.context = context.getApplicationContext();
        TelemetryDefinition telemetry = Mapbox.getTelemetry();
        if (telemetry != null) {
            telemetry.onAppUserTurnstileEvent();
        }
        FileSource fileSource = FileSource.getInstance(context);
        String apiBaseUrl = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            fileSource.setApiBaseUrl(apiBaseUrl);
        }
        String programCacheDir = FileSource.getInternalCachePath(context);
        this.nativeInitialize(this, fileSource, options.pixelRatio, options.width, options.height, options.styleUri, options.styleJson, options.region, options.cameraPosition, options.showLogo, programCacheDir, options.localIdeographFontFamily);
    }

    public void start(@NonNull SnapshotReadyCallback callback) {
        this.start(callback, null);
    }

    public void start(@NonNull SnapshotReadyCallback callback, ErrorHandler errorHandler) {
        if (this.callback != null) {
            throw new IllegalStateException("Snapshotter was already started");
        }
        this.checkThread();
        this.callback = callback;
        this.errorHandler = errorHandler;
        this.nativeStart();
    }

    @Keep
    public native void setSize(int var1, int var2);

    @Keep
    public native void setCameraPosition(CameraPosition var1);

    @Keep
    public native void setRegion(LatLngBounds var1);

    @Keep
    public native void setStyleUrl(String var1);

    @Keep
    public native void setStyleJson(String var1);

    public void cancel() {
        this.checkThread();
        this.reset();
        this.nativeCancel();
    }

    protected void addOverlay(@NonNull MapSnapshot mapSnapshot) {
        Bitmap snapshot = mapSnapshot.getBitmap();
        Canvas canvas = new Canvas(snapshot);
        int margin = (int)this.context.getResources().getDisplayMetrics().density * 4;
        this.drawOverlay(mapSnapshot, snapshot, canvas, margin);
    }

    private void drawOverlay(@NonNull MapSnapshot mapSnapshot, @NonNull Bitmap snapshot, @NonNull Canvas canvas, int margin) {
        AttributionMeasure measure = this.getAttributionMeasure(mapSnapshot, snapshot, margin);
        AttributionLayout layout2 = measure.measure();
        this.drawLogo(mapSnapshot, canvas, margin, layout2);
        this.drawAttribution(mapSnapshot, canvas, measure, layout2);
    }

    @NonNull
    private AttributionMeasure getAttributionMeasure(@NonNull MapSnapshot mapSnapshot, @NonNull Bitmap snapshot, int margin) {
        Logo logo = this.createScaledLogo(snapshot);
        TextView longText = this.createTextView(mapSnapshot, false, logo.getScale());
        TextView shortText = this.createTextView(mapSnapshot, true, logo.getScale());
        return new AttributionMeasure.Builder().setSnapshot(snapshot).setLogo(logo.getLarge()).setLogoSmall(logo.getSmall()).setTextView(longText).setTextViewShort(shortText).setMarginPadding(margin).build();
    }

    private void drawLogo(MapSnapshot mapSnapshot, @NonNull Canvas canvas, int margin, @NonNull AttributionLayout layout2) {
        if (mapSnapshot.isShowLogo()) {
            this.drawLogo(mapSnapshot.getBitmap(), canvas, margin, layout2);
        }
    }

    private void drawLogo(@NonNull Bitmap snapshot, @NonNull Canvas canvas, int margin, AttributionLayout placement) {
        Bitmap selectedLogo = placement.getLogo();
        if (selectedLogo != null) {
            canvas.drawBitmap(selectedLogo, (float)margin, (float)(snapshot.getHeight() - selectedLogo.getHeight() - margin), null);
        }
    }

    private void drawAttribution(@NonNull MapSnapshot mapSnapshot, @NonNull Canvas canvas, @NonNull AttributionMeasure measure, AttributionLayout layout2) {
        PointF anchorPoint = layout2.getAnchorPoint();
        if (anchorPoint != null) {
            this.drawAttribution(canvas, measure, anchorPoint);
        } else {
            Bitmap snapshot = mapSnapshot.getBitmap();
            Logger.e(TAG, String.format("Could not generate attribution for snapshot size: %s x %s. You are required to provide your own attribution for the used sources: %s", snapshot.getWidth(), snapshot.getHeight(), mapSnapshot.getAttributions()));
        }
    }

    private void drawAttribution(Canvas canvas, AttributionMeasure measure, PointF anchorPoint) {
        canvas.save();
        canvas.translate(anchorPoint.x, anchorPoint.y);
        measure.getTextView().draw(canvas);
        canvas.restore();
    }

    @NonNull
    private TextView createTextView(@NonNull MapSnapshot mapSnapshot, boolean shortText, float scale) {
        int textColor = ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.mapbox_gray_dark, (Resources.Theme)this.context.getTheme());
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        TextView textView = new TextView(this.context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        textView.setSingleLine(true);
        textView.setTextSize(10.0f * scale);
        textView.setTextColor(textColor);
        textView.setBackgroundResource(R.drawable.mapbox_rounded_corner);
        textView.setText((CharSequence)Html.fromHtml((String)this.createAttributionString(mapSnapshot, shortText)));
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
        return textView;
    }

    @NonNull
    private String createAttributionString(MapSnapshot mapSnapshot, boolean shortText) {
        AttributionParser attributionParser = new AttributionParser.Options(this.context).withAttributionData(mapSnapshot.getAttributions()).withCopyrightSign(false).withImproveMap(false).build();
        return attributionParser.createAttributionString(shortText);
    }

    private Logo createScaledLogo(@NonNull Bitmap snapshot) {
        Bitmap logo = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_icon, null);
        float scale = this.calculateLogoScale(snapshot, logo);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap helmet = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_helmet, null);
        Bitmap large = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
        Bitmap small = Bitmap.createBitmap((Bitmap)helmet, (int)0, (int)0, (int)helmet.getWidth(), (int)helmet.getHeight(), (Matrix)matrix, (boolean)true);
        return new Logo(large, small, scale);
    }

    private float calculateLogoScale(Bitmap snapshot, Bitmap logo) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float widthRatio = displayMetrics.widthPixels / snapshot.getWidth();
        float heightRatio = displayMetrics.heightPixels / snapshot.getHeight();
        float prefWidth = (float)logo.getWidth() / widthRatio;
        float prefHeight = (float)logo.getHeight() / heightRatio;
        float calculatedScale = Math.min(prefWidth / (float)logo.getWidth(), prefHeight / (float)logo.getHeight()) * 2.0f;
        if (calculatedScale > 1.0f) {
            calculatedScale = 1.0f;
        } else if (calculatedScale < 0.6f) {
            calculatedScale = 0.6f;
        }
        return calculatedScale;
    }

    @Keep
    protected void onSnapshotReady(final @NonNull MapSnapshot snapshot) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (MapSnapshotter.this.callback != null) {
                    MapSnapshotter.this.addOverlay(snapshot);
                    MapSnapshotter.this.callback.onSnapshotReady(snapshot);
                    MapSnapshotter.this.reset();
                }
            }
        });
    }

    @Keep
    protected void onSnapshotFailed(String reason) {
        if (this.errorHandler != null) {
            this.errorHandler.onError(reason);
            this.reset();
        }
    }

    private void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    protected void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    @Keep
    protected native void nativeInitialize(MapSnapshotter var1, FileSource var2, float var3, int var4, int var5, String var6, String var7, LatLngBounds var8, CameraPosition var9, boolean var10, String var11, String var12);

    @Keep
    protected native void nativeStart();

    @Keep
    protected native void nativeCancel();

    @Keep
    protected native void finalize() throws Throwable;

    private class Logo {
        private Bitmap large;
        private Bitmap small;
        private float scale;

        public Logo(Bitmap large, Bitmap small, float scale) {
            this.large = large;
            this.small = small;
            this.scale = scale;
        }

        public Bitmap getLarge() {
            return this.large;
        }

        public Bitmap getSmall() {
            return this.small;
        }

        public float getScale() {
            return this.scale;
        }
    }

    public static class Options {
        private float pixelRatio = 1.0f;
        private int width;
        private int height;
        private String styleUri = "mapbox://styles/mapbox/streets-v11";
        private String styleJson;
        private LatLngBounds region;
        private CameraPosition cameraPosition;
        private boolean showLogo = true;
        private String localIdeographFontFamily = "sans-serif";
        private String apiBaseUrl;

        public Options(int width, int height) {
            if (width == 0 || height == 0) {
                throw new IllegalArgumentException("Unable to create a snapshot with width or height set to 0");
            }
            this.width = width;
            this.height = height;
        }

        @NonNull
        public Options withStyle(String uri) {
            this.styleUri = uri;
            return this;
        }

        @NonNull
        public Options withStyleJson(String styleJson) {
            this.styleJson = styleJson;
            return this;
        }

        @NonNull
        public Options withRegion(LatLngBounds region) {
            this.region = region;
            return this;
        }

        @NonNull
        public Options withPixelRatio(float pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        @NonNull
        public Options withCameraPosition(CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        @NonNull
        public Options withLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        @NonNull
        public Options withLocalIdeographFontFamily(String fontFamily) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamily);
            return this;
        }

        @NonNull
        public Options withLocalIdeographFontFamily(String ... fontFamilies) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamilies);
            return this;
        }

        @Deprecated
        @NonNull
        public Options withApiBaseUrl(String apiBaseUrl) {
            this.apiBaseUrl = apiBaseUrl;
            return this;
        }

        @NonNull
        public Options withApiBaseUri(String apiBaseUri) {
            this.apiBaseUrl = apiBaseUri;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getPixelRatio() {
            return this.pixelRatio;
        }

        @Nullable
        public LatLngBounds getRegion() {
            return this.region;
        }

        @Deprecated
        public String getStyleUrl() {
            return this.styleUri;
        }

        public String getStyleUri() {
            return this.styleUri;
        }

        @Nullable
        public CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }

        public String getLocalIdeographFontFamily() {
            return this.localIdeographFontFamily;
        }

        @Deprecated
        @Nullable
        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }

        @Nullable
        public String getApiBaseUri() {
            return this.apiBaseUrl;
        }
    }

    public static interface ErrorHandler {
        public void onError(String var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(MapSnapshot var1);
    }
}

