/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.graphics.Typeface;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.log.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FontUtils {
    private static final String TAG = "Mbgl-FontUtils";

    private FontUtils() {
    }

    public static String extractValidFont(String ... fontNames) {
        if (fontNames == null) {
            return null;
        }
        List<String> validFonts = FontUtils.getAvailableFonts();
        for (String fontName : fontNames) {
            if (!validFonts.contains(fontName)) continue;
            return fontName;
        }
        Logger.i(TAG, String.format("Couldn't map font family for local ideograph, using %s instead", "sans-serif"));
        return "sans-serif";
    }

    private static List<String> getAvailableFonts() {
        ArrayList<String> fonts = new ArrayList<String>();
        try {
            Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            Field f = Typeface.class.getDeclaredField("sSystemFontMap");
            f.setAccessible(true);
            Map fontMap = (Map)f.get(typeface);
            fonts.addAll(fontMap.keySet());
        }
        catch (Exception exception) {
            Logger.e(TAG, "Couldn't load fonts from Typeface", exception);
            MapStrictMode.strictModeViolation("Couldn't load fonts from Typeface", exception);
        }
        return fonts;
    }
}

