/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.graphics.PointF;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.location.OnLocationCameraTransitionListener;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Transform;
import java.util.HashSet;
import java.util.Set;

final class LocationCameraController {
    private int cameraMode;
    private final MapboxMap mapboxMap;
    private final Transform transform;
    private final OnCameraTrackingChangedListener internalCameraTrackingChangedListener;
    private LocationComponentOptions options;
    private boolean adjustFocalPoint;
    private final MoveGestureDetector moveGestureDetector;
    private final OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private final AndroidGesturesManager initialGesturesManager;
    private final AndroidGesturesManager internalGesturesManager;
    private boolean isTransitioning;
    private final MapboxAnimator.AnimationsValueChangeListener<LatLng> latLngValueListener = new MapboxAnimator.AnimationsValueChangeListener<LatLng>(){

        @Override
        public void onNewAnimationValue(LatLng value) {
            LocationCameraController.this.setLatLng(value);
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> gpsBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            boolean trackingNorth;
            boolean bl = trackingNorth = LocationCameraController.this.cameraMode == 36 && ((LocationCameraController)LocationCameraController.this).mapboxMap.getCameraPosition().bearing == 0.0;
            if (!trackingNorth) {
                LocationCameraController.this.setBearing(value.floatValue());
            }
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> compassBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            if (LocationCameraController.this.cameraMode == 32 || LocationCameraController.this.cameraMode == 16) {
                LocationCameraController.this.setBearing(value.floatValue());
            }
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> zoomValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            LocationCameraController.this.setZoom(value.floatValue());
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> tiltValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            LocationCameraController.this.setTilt(value.floatValue());
        }
    };
    @NonNull
    @VisibleForTesting
    MapboxMap.OnMoveListener onMoveListener = new MapboxMap.OnMoveListener(){
        private boolean interrupt;

        @Override
        public void onMoveBegin(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && detector.getPointersCount() > 1 && detector.getMoveThreshold() != LocationCameraController.this.options.trackingMultiFingerMoveThreshold() && LocationCameraController.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingMultiFingerMoveThreshold());
                this.interrupt = true;
            } else {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        @Override
        public void onMove(@NonNull MoveGestureDetector detector) {
            if (this.interrupt) {
                detector.interrupt();
                return;
            }
            if (LocationCameraController.this.isLocationTracking() || LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
                detector.interrupt();
            }
        }

        @Override
        public void onMoveEnd(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && !this.interrupt && LocationCameraController.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
            }
            this.interrupt = false;
        }
    };
    @NonNull
    private MapboxMap.OnRotateListener onRotateListener = new MapboxMap.OnRotateListener(){

        @Override
        public void onRotateBegin(@NonNull RotateGestureDetector detector) {
            if (LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        @Override
        public void onRotate(@NonNull RotateGestureDetector detector) {
        }

        @Override
        public void onRotateEnd(@NonNull RotateGestureDetector detector) {
        }
    };
    @NonNull
    private MapboxMap.OnFlingListener onFlingListener = new MapboxMap.OnFlingListener(){

        @Override
        public void onFling() {
            LocationCameraController.this.setCameraMode(8);
        }
    };

    LocationCameraController(Context context, MapboxMap mapboxMap, Transform transform, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, @NonNull LocationComponentOptions options, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener) {
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        this.initialGesturesManager = mapboxMap.getGesturesManager();
        this.internalGesturesManager = new LocationGesturesManager(context);
        this.moveGestureDetector = this.internalGesturesManager.getMoveGestureDetector();
        mapboxMap.addOnRotateListener(this.onRotateListener);
        mapboxMap.addOnFlingListener(this.onFlingListener);
        mapboxMap.addOnMoveListener(this.onMoveListener);
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.initializeOptions(options);
    }

    LocationCameraController(MapboxMap mapboxMap, Transform transform, MoveGestureDetector moveGestureDetector, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener, AndroidGesturesManager initialGesturesManager, AndroidGesturesManager internalGesturesManager) {
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        this.moveGestureDetector = moveGestureDetector;
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.internalGesturesManager = internalGesturesManager;
        this.initialGesturesManager = initialGesturesManager;
    }

    void initializeOptions(LocationComponentOptions options) {
        this.options = options;
        if (options.trackingGesturesManagement()) {
            if (this.mapboxMap.getGesturesManager() != this.internalGesturesManager) {
                this.mapboxMap.setGesturesManager(this.internalGesturesManager, true, true);
            }
            this.adjustGesturesThresholds();
        } else if (this.mapboxMap.getGesturesManager() != this.initialGesturesManager) {
            this.mapboxMap.setGesturesManager(this.initialGesturesManager, true, true);
        }
    }

    void setCameraMode(int cameraMode) {
        this.setCameraMode(cameraMode, null, 750L, null, null, null, null);
    }

    void setCameraMode(int cameraMode, @Nullable Location lastLocation, long transitionDuration, @Nullable Double zoom, @Nullable Double bearing, @Nullable Double tilt, @Nullable OnLocationCameraTransitionListener internalTransitionListener) {
        boolean wasTracking = this.isLocationTracking();
        this.cameraMode = cameraMode;
        if (cameraMode != 8) {
            this.mapboxMap.cancelTransitions();
        }
        this.adjustGesturesThresholds();
        this.notifyCameraTrackingChangeListener(wasTracking);
        this.transitionToCurrentLocation(wasTracking, lastLocation, transitionDuration, zoom, bearing, tilt, internalTransitionListener);
    }

    private void transitionToCurrentLocation(boolean wasTracking, Location lastLocation, long transitionDuration, Double zoom, Double bearing, Double tilt, final OnLocationCameraTransitionListener internalTransitionListener) {
        if (!wasTracking && this.isLocationTracking() && lastLocation != null) {
            this.isTransitioning = true;
            LatLng target = new LatLng(lastLocation);
            CameraPosition.Builder builder = new CameraPosition.Builder().target(target);
            if (zoom != null) {
                builder.zoom(zoom);
            }
            if (tilt != null) {
                builder.tilt(tilt);
            }
            if (bearing != null) {
                builder.bearing(bearing);
            } else if (this.isLocationBearingTracking()) {
                builder.bearing(this.cameraMode == 36 ? 0.0 : (double)lastLocation.getBearing());
            }
            CameraUpdate update = CameraUpdateFactory.newCameraPosition(builder.build());
            MapboxMap.CancelableCallback callback = new MapboxMap.CancelableCallback(){

                @Override
                public void onCancel() {
                    LocationCameraController.this.isTransitioning = false;
                    if (internalTransitionListener != null) {
                        internalTransitionListener.onLocationCameraTransitionCanceled(LocationCameraController.this.cameraMode);
                    }
                }

                @Override
                public void onFinish() {
                    LocationCameraController.this.isTransitioning = false;
                    if (internalTransitionListener != null) {
                        internalTransitionListener.onLocationCameraTransitionFinished(LocationCameraController.this.cameraMode);
                    }
                }
            };
            CameraPosition currentPosition = this.mapboxMap.getCameraPosition();
            if (Utils.immediateAnimation(this.mapboxMap.getProjection(), currentPosition.target, target)) {
                this.transform.moveCamera(this.mapboxMap, update, callback);
            } else {
                this.transform.animateCamera(this.mapboxMap, update, (int)transitionDuration, callback);
            }
        } else if (internalTransitionListener != null) {
            internalTransitionListener.onLocationCameraTransitionFinished(this.cameraMode);
        }
    }

    int getCameraMode() {
        return this.cameraMode;
    }

    private void setBearing(float bearing) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.bearingTo(bearing), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setLatLng(@NonNull LatLng latLng) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.newLatLng(latLng), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
        if (this.adjustFocalPoint) {
            PointF focalPoint = this.mapboxMap.getProjection().toScreenLocation(latLng);
            this.mapboxMap.getUiSettings().setFocalPoint(focalPoint);
            this.adjustFocalPoint = false;
        }
    }

    private void setZoom(float zoom) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.zoomTo(zoom), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setTilt(float tilt) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapboxMap, CameraUpdateFactory.tiltTo(tilt), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    Set<AnimatorListenerHolder> getAnimationListeners() {
        HashSet<AnimatorListenerHolder> holders = new HashSet<AnimatorListenerHolder>();
        if (this.isLocationTracking()) {
            holders.add(new AnimatorListenerHolder(1, this.latLngValueListener));
        }
        if (this.isLocationBearingTracking()) {
            holders.add(new AnimatorListenerHolder(4, this.gpsBearingValueListener));
        }
        if (this.isConsumingCompass()) {
            holders.add(new AnimatorListenerHolder(5, this.compassBearingValueListener));
        }
        holders.add(new AnimatorListenerHolder(7, this.zoomValueListener));
        holders.add(new AnimatorListenerHolder(8, this.tiltValueListener));
        return holders;
    }

    boolean isTransitioning() {
        return this.isTransitioning;
    }

    private void adjustGesturesThresholds() {
        if (this.options.trackingGesturesManagement()) {
            if (this.isLocationTracking()) {
                this.adjustFocalPoint = true;
                this.moveGestureDetector.setMoveThreshold(this.options.trackingInitialMoveThreshold());
            } else {
                this.moveGestureDetector.setMoveThreshold(0.0f);
            }
        }
    }

    boolean isConsumingCompass() {
        return this.cameraMode == 32 || this.cameraMode == 16;
    }

    private boolean isLocationTracking() {
        return this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isBearingTracking() {
        return this.cameraMode == 16 || this.cameraMode == 32 || this.cameraMode == 22 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isLocationBearingTracking() {
        return this.cameraMode == 34 || this.cameraMode == 36 || this.cameraMode == 22;
    }

    private void notifyCameraTrackingChangeListener(boolean wasTracking) {
        this.internalCameraTrackingChangedListener.onCameraTrackingChanged(this.cameraMode);
        if (wasTracking && !this.isLocationTracking()) {
            this.mapboxMap.getUiSettings().setFocalPoint(null);
            this.internalCameraTrackingChangedListener.onCameraTrackingDismissed();
        }
    }

    private class LocationGesturesManager
    extends AndroidGesturesManager {
        LocationGesturesManager(Context context) {
            super(context);
        }

        public boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
            int action;
            if (motionEvent != null && (action = motionEvent.getActionMasked()) == 1) {
                LocationCameraController.this.adjustGesturesThresholds();
            }
            return super.onTouchEvent(motionEvent);
        }
    }
}

