/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class MapChangeReceiver
implements NativeMapView.StateCallback {
    private static final String TAG = "Mbgl-MapChangeReceiver";
    private final List<MapView.OnCameraWillChangeListener> onCameraWillChangeListenerList = new CopyOnWriteArrayList<MapView.OnCameraWillChangeListener>();
    private final List<MapView.OnCameraIsChangingListener> onCameraIsChangingListenerList = new CopyOnWriteArrayList<MapView.OnCameraIsChangingListener>();
    private final List<MapView.OnCameraDidChangeListener> onCameraDidChangeListenerList = new CopyOnWriteArrayList<MapView.OnCameraDidChangeListener>();
    private final List<MapView.OnWillStartLoadingMapListener> onWillStartLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnWillStartLoadingMapListener>();
    private final List<MapView.OnDidFinishLoadingMapListener> onDidFinishLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishLoadingMapListener>();
    private final List<MapView.OnDidFailLoadingMapListener> onDidFailLoadingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFailLoadingMapListener>();
    private final List<MapView.OnWillStartRenderingFrameListener> onWillStartRenderingFrameList = new CopyOnWriteArrayList<MapView.OnWillStartRenderingFrameListener>();
    private final List<MapView.OnDidFinishRenderingFrameListener> onDidFinishRenderingFrameList = new CopyOnWriteArrayList<MapView.OnDidFinishRenderingFrameListener>();
    private final List<MapView.OnWillStartRenderingMapListener> onWillStartRenderingMapListenerList = new CopyOnWriteArrayList<MapView.OnWillStartRenderingMapListener>();
    private final List<MapView.OnDidFinishRenderingMapListener> onDidFinishRenderingMapListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishRenderingMapListener>();
    private final List<MapView.OnDidBecomeIdleListener> onDidBecomeIdleListenerList = new CopyOnWriteArrayList<MapView.OnDidBecomeIdleListener>();
    private final List<MapView.OnDidFinishLoadingStyleListener> onDidFinishLoadingStyleListenerList = new CopyOnWriteArrayList<MapView.OnDidFinishLoadingStyleListener>();
    private final List<MapView.OnSourceChangedListener> onSourceChangedListenerList = new CopyOnWriteArrayList<MapView.OnSourceChangedListener>();
    private final List<MapView.OnStyleImageMissingListener> onStyleImageMissingListenerList = new CopyOnWriteArrayList<MapView.OnStyleImageMissingListener>();

    MapChangeReceiver() {
    }

    @Override
    public void onCameraWillChange(boolean animated) {
        try {
            if (!this.onCameraWillChangeListenerList.isEmpty()) {
                for (MapView.OnCameraWillChangeListener onCameraWillChangeListener : this.onCameraWillChangeListenerList) {
                    onCameraWillChangeListener.onCameraWillChange(animated);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraWillChange", err);
            throw err;
        }
    }

    @Override
    public void onCameraIsChanging() {
        try {
            if (!this.onCameraIsChangingListenerList.isEmpty()) {
                for (MapView.OnCameraIsChangingListener onCameraIsChangingListener : this.onCameraIsChangingListenerList) {
                    onCameraIsChangingListener.onCameraIsChanging();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraIsChanging", err);
            throw err;
        }
    }

    @Override
    public void onCameraDidChange(boolean animated) {
        try {
            if (!this.onCameraDidChangeListenerList.isEmpty()) {
                for (MapView.OnCameraDidChangeListener onCameraDidChangeListener : this.onCameraDidChangeListenerList) {
                    onCameraDidChangeListener.onCameraDidChange(animated);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onCameraDidChange", err);
            throw err;
        }
    }

    @Override
    public void onWillStartLoadingMap() {
        try {
            if (!this.onWillStartLoadingMapListenerList.isEmpty()) {
                for (MapView.OnWillStartLoadingMapListener onWillStartLoadingMapListener : this.onWillStartLoadingMapListenerList) {
                    onWillStartLoadingMapListener.onWillStartLoadingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishLoadingMap() {
        try {
            if (!this.onDidFinishLoadingMapListenerList.isEmpty()) {
                for (MapView.OnDidFinishLoadingMapListener onDidFinishLoadingMapListener : this.onDidFinishLoadingMapListenerList) {
                    onDidFinishLoadingMapListener.onDidFinishLoadingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFailLoadingMap(String error) {
        try {
            if (!this.onDidFailLoadingMapListenerList.isEmpty()) {
                for (MapView.OnDidFailLoadingMapListener onDidFailLoadingMapListener : this.onDidFailLoadingMapListenerList) {
                    onDidFailLoadingMapListener.onDidFailLoadingMap(error);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFailLoadingMap", err);
            throw err;
        }
    }

    @Override
    public void onWillStartRenderingFrame() {
        try {
            if (!this.onWillStartRenderingFrameList.isEmpty()) {
                for (MapView.OnWillStartRenderingFrameListener listener : this.onWillStartRenderingFrameList) {
                    listener.onWillStartRenderingFrame();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartRenderingFrame", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishRenderingFrame(boolean fully) {
        try {
            if (!this.onDidFinishRenderingFrameList.isEmpty()) {
                for (MapView.OnDidFinishRenderingFrameListener listener : this.onDidFinishRenderingFrameList) {
                    listener.onDidFinishRenderingFrame(fully);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishRenderingFrame", err);
            throw err;
        }
    }

    @Override
    public void onWillStartRenderingMap() {
        try {
            if (!this.onWillStartRenderingMapListenerList.isEmpty()) {
                for (MapView.OnWillStartRenderingMapListener listener : this.onWillStartRenderingMapListenerList) {
                    listener.onWillStartRenderingMap();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onWillStartRenderingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishRenderingMap(boolean fully) {
        try {
            if (!this.onDidFinishRenderingMapListenerList.isEmpty()) {
                for (MapView.OnDidFinishRenderingMapListener listener : this.onDidFinishRenderingMapListenerList) {
                    listener.onDidFinishRenderingMap(fully);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishRenderingMap", err);
            throw err;
        }
    }

    @Override
    public void onDidBecomeIdle() {
        try {
            if (!this.onDidBecomeIdleListenerList.isEmpty()) {
                for (MapView.OnDidBecomeIdleListener listener : this.onDidBecomeIdleListenerList) {
                    listener.onDidBecomeIdle();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidBecomeIdle", err);
            throw err;
        }
    }

    @Override
    public void onDidFinishLoadingStyle() {
        try {
            if (!this.onDidFinishLoadingStyleListenerList.isEmpty()) {
                for (MapView.OnDidFinishLoadingStyleListener listener : this.onDidFinishLoadingStyleListenerList) {
                    listener.onDidFinishLoadingStyle();
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onDidFinishLoadingStyle", err);
            throw err;
        }
    }

    @Override
    public void onSourceChanged(String sourceId) {
        try {
            if (!this.onSourceChangedListenerList.isEmpty()) {
                for (MapView.OnSourceChangedListener onSourceChangedListener : this.onSourceChangedListenerList) {
                    onSourceChangedListener.onSourceChangedListener(sourceId);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSourceChanged", err);
            throw err;
        }
    }

    @Override
    public void onStyleImageMissing(String imageId) {
        try {
            if (!this.onStyleImageMissingListenerList.isEmpty()) {
                for (MapView.OnStyleImageMissingListener listener : this.onStyleImageMissingListenerList) {
                    listener.onStyleImageMissing(imageId);
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onStyleImageMissing", err);
            throw err;
        }
    }

    void addOnCameraWillChangeListener(MapView.OnCameraWillChangeListener listener) {
        this.onCameraWillChangeListenerList.add(listener);
    }

    void removeOnCameraWillChangeListener(MapView.OnCameraWillChangeListener listener) {
        this.onCameraWillChangeListenerList.remove(listener);
    }

    void addOnCameraIsChangingListener(MapView.OnCameraIsChangingListener listener) {
        this.onCameraIsChangingListenerList.add(listener);
    }

    void removeOnCameraIsChangingListener(MapView.OnCameraIsChangingListener listener) {
        this.onCameraIsChangingListenerList.remove(listener);
    }

    void addOnCameraDidChangeListener(MapView.OnCameraDidChangeListener listener) {
        this.onCameraDidChangeListenerList.add(listener);
    }

    void removeOnCameraDidChangeListener(MapView.OnCameraDidChangeListener listener) {
        this.onCameraDidChangeListenerList.remove(listener);
    }

    void addOnWillStartLoadingMapListener(MapView.OnWillStartLoadingMapListener listener) {
        this.onWillStartLoadingMapListenerList.add(listener);
    }

    void removeOnWillStartLoadingMapListener(MapView.OnWillStartLoadingMapListener listener) {
        this.onWillStartLoadingMapListenerList.remove(listener);
    }

    void addOnDidFinishLoadingMapListener(MapView.OnDidFinishLoadingMapListener listener) {
        this.onDidFinishLoadingMapListenerList.add(listener);
    }

    void removeOnDidFinishLoadingMapListener(MapView.OnDidFinishLoadingMapListener listener) {
        this.onDidFinishLoadingMapListenerList.remove(listener);
    }

    void addOnDidFailLoadingMapListener(MapView.OnDidFailLoadingMapListener listener) {
        this.onDidFailLoadingMapListenerList.add(listener);
    }

    void removeOnDidFailLoadingMapListener(MapView.OnDidFailLoadingMapListener listener) {
        this.onDidFailLoadingMapListenerList.remove(listener);
    }

    void addOnWillStartRenderingFrameListener(MapView.OnWillStartRenderingFrameListener listener) {
        this.onWillStartRenderingFrameList.add(listener);
    }

    void removeOnWillStartRenderingFrameListener(MapView.OnWillStartRenderingFrameListener listener) {
        this.onWillStartRenderingFrameList.remove(listener);
    }

    void addOnDidFinishRenderingFrameListener(MapView.OnDidFinishRenderingFrameListener listener) {
        this.onDidFinishRenderingFrameList.add(listener);
    }

    void removeOnDidFinishRenderingFrameListener(MapView.OnDidFinishRenderingFrameListener listener) {
        this.onDidFinishRenderingFrameList.remove(listener);
    }

    void addOnWillStartRenderingMapListener(MapView.OnWillStartRenderingMapListener listener) {
        this.onWillStartRenderingMapListenerList.add(listener);
    }

    void removeOnWillStartRenderingMapListener(MapView.OnWillStartRenderingMapListener listener) {
        this.onWillStartRenderingMapListenerList.remove(listener);
    }

    void addOnDidFinishRenderingMapListener(MapView.OnDidFinishRenderingMapListener listener) {
        this.onDidFinishRenderingMapListenerList.add(listener);
    }

    void removeOnDidFinishRenderingMapListener(MapView.OnDidFinishRenderingMapListener listener) {
        this.onDidFinishRenderingMapListenerList.remove(listener);
    }

    void addOnDidBecomeIdleListener(MapView.OnDidBecomeIdleListener listener) {
        this.onDidBecomeIdleListenerList.add(listener);
    }

    void removeOnDidBecomeIdleListener(MapView.OnDidBecomeIdleListener listener) {
        this.onDidBecomeIdleListenerList.remove(listener);
    }

    void addOnDidFinishLoadingStyleListener(MapView.OnDidFinishLoadingStyleListener listener) {
        this.onDidFinishLoadingStyleListenerList.add(listener);
    }

    void removeOnDidFinishLoadingStyleListener(MapView.OnDidFinishLoadingStyleListener listener) {
        this.onDidFinishLoadingStyleListenerList.remove(listener);
    }

    void addOnSourceChangedListener(MapView.OnSourceChangedListener listener) {
        this.onSourceChangedListenerList.add(listener);
    }

    void removeOnSourceChangedListener(MapView.OnSourceChangedListener listener) {
        this.onSourceChangedListenerList.remove(listener);
    }

    void addOnStyleImageMissingListener(MapView.OnStyleImageMissingListener listener) {
        this.onStyleImageMissingListenerList.add(listener);
    }

    void removeOnStyleImageMissingListener(MapView.OnStyleImageMissingListener listener) {
        this.onStyleImageMissingListenerList.remove(listener);
    }

    void clear() {
        this.onCameraWillChangeListenerList.clear();
        this.onCameraIsChangingListenerList.clear();
        this.onCameraDidChangeListenerList.clear();
        this.onWillStartLoadingMapListenerList.clear();
        this.onDidFinishLoadingMapListenerList.clear();
        this.onDidFailLoadingMapListenerList.clear();
        this.onWillStartRenderingFrameList.clear();
        this.onDidFinishRenderingFrameList.clear();
        this.onWillStartRenderingMapListenerList.clear();
        this.onDidFinishRenderingMapListenerList.clear();
        this.onDidBecomeIdleListenerList.clear();
        this.onDidFinishLoadingStyleListenerList.clear();
        this.onSourceChangedListenerList.clear();
        this.onStyleImageMissingListenerList.clear();
    }
}

