/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer.textureview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.TextureView;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewRenderThread;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class TextureViewMapRenderer
extends MapRenderer {
    private TextureViewRenderThread renderThread;
    private boolean translucentSurface;

    public TextureViewMapRenderer(@NonNull Context context, @NonNull TextureView textureView, String localIdeographFontFamily, boolean translucentSurface) {
        super(context, localIdeographFontFamily);
        this.translucentSurface = translucentSurface;
        this.renderThread = new TextureViewRenderThread(textureView, this);
        this.renderThread.start();
    }

    @Override
    protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
        super.onSurfaceCreated(gl, config);
        this.hasSurface.set(true);
    }

    @Override
    protected void onSurfaceChanged(GL10 gl, int width, int height) {
        super.onSurfaceChanged(gl, width, height);
    }

    @Override
    protected void onSurfaceDestroyed() {
        this.hasSurface.set(false);
        super.onSurfaceDestroyed();
    }

    @Override
    protected void onDrawFrame(GL10 gl) {
        super.onDrawFrame(gl);
    }

    @Override
    public void requestRender() {
        this.renderThread.requestRender();
    }

    @Override
    public void queueEvent(Runnable runnable) {
        this.renderThread.queueEvent(runnable);
    }

    @Override
    public void onStop() {
        this.renderThread.onPause();
    }

    @Override
    public void onStart() {
        this.renderThread.onResume();
    }

    @Override
    public void onDestroy() {
        this.renderThread.onDestroy();
    }

    public boolean isTranslucentSurface() {
        return this.translucentSurface;
    }
}

