/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mapbox.android.accounts.v1.MapboxAccounts;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;

class AccountsManager {
    private static final String TAG = "Mbgl-AccountsManager";
    private static final String PREFERENCE_USER_ID = "com.mapbox.mapboxsdk.accounts.userid";
    private static final String PREFERENCE_TIMESTAMP = "com.mapbox.mapboxsdk.accounts.timestamp";
    private static final String PREFERENCE_SKU_TOKEN = "com.mapbox.mapboxsdk.accounts.skutoken";
    private long timestamp;
    @Nullable
    private String skuToken;
    private boolean isEnabled = this.isSkuTokenEnabled();

    AccountsManager() {
        if (this.isEnabled) {
            String userId = this.validateUserId();
            this.validateRotation(userId);
        } else {
            this.timestamp = 0L;
            this.skuToken = null;
        }
    }

    private boolean isSkuTokenEnabled() {
        boolean value = false;
        try {
            ApplicationInfo appInfo = Mapbox.getApplicationContext().getPackageManager().getApplicationInfo(Mapbox.getApplicationContext().getPackageName(), 128);
            if (appInfo.metaData != null) {
                value = appInfo.metaData.getBoolean("com.mapbox.EnableSkuToken", false);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the package metadata: ", exception);
        }
        return value;
    }

    private String validateUserId() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String userId = sharedPreferences.getString(PREFERENCE_USER_ID, "");
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = this.generateUserId();
            SharedPreferences.Editor editor = this.getSharedPreferences().edit();
            editor.putString(PREFERENCE_USER_ID, userId);
            editor.apply();
        }
        return userId;
    }

    private void validateRotation(String userId) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        this.timestamp = sharedPreferences.getLong(PREFERENCE_TIMESTAMP, 0L);
        this.skuToken = sharedPreferences.getString(PREFERENCE_SKU_TOKEN, "");
        if (this.timestamp == 0L || TextUtils.isEmpty((CharSequence)this.skuToken)) {
            this.skuToken = this.generateSkuToken(userId);
            this.timestamp = this.persistRotation(this.skuToken);
        }
    }

    @Nullable
    String getSkuToken() {
        if (this.isEnabled && this.isExpired()) {
            SharedPreferences sharedPreferences = this.getSharedPreferences();
            String userId = sharedPreferences.getString(PREFERENCE_USER_ID, "");
            this.skuToken = this.generateSkuToken(userId);
            this.timestamp = this.persistRotation(this.skuToken);
        }
        return this.skuToken;
    }

    private boolean isExpired() {
        return AccountsManager.isExpired(AccountsManager.getNow(), this.timestamp);
    }

    static boolean isExpired(long now, long then) {
        return now - then > 3600000L;
    }

    private long persistRotation(String skuToken) {
        long now = AccountsManager.getNow();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putLong(PREFERENCE_TIMESTAMP, now);
        editor.putString(PREFERENCE_SKU_TOKEN, skuToken);
        editor.apply();
        return now;
    }

    @NonNull
    private SharedPreferences getSharedPreferences() {
        return Mapbox.getApplicationContext().getSharedPreferences("MapboxSharedPreferences", 0);
    }

    static long getNow() {
        return System.currentTimeMillis();
    }

    @NonNull
    private String generateUserId() {
        return MapboxAccounts.obtainEndUserId();
    }

    @NonNull
    private String generateSkuToken(String userId) {
        return MapboxAccounts.obtainMapsSkuUserToken((String)userId);
    }
}

