/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.types;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Arrays;
import java.util.HashMap;

@Keep
public class FormattedSection {
    private String text;
    private Number fontScale;
    private String[] fontStack;
    private String textColor;

    public FormattedSection(@NonNull String text) {
        this(text, null, null, null);
    }

    public FormattedSection(@NonNull String text, @Nullable Number fontScale, @Nullable String[] fontStack, @Nullable String textColor) {
        this.text = text;
        this.fontScale = fontScale;
        this.fontStack = fontStack;
        this.textColor = textColor;
    }

    @Deprecated
    public FormattedSection(@NonNull String text, @Nullable Number fontScale, @Nullable String[] fontStack) {
        this(text, fontScale, fontStack, null);
    }

    @Deprecated
    public FormattedSection(@NonNull String text, @Nullable Number fontScale) {
        this(text, fontScale, null, null);
    }

    @Deprecated
    public FormattedSection(@NonNull String text, @Nullable String[] fontStack) {
        this(text, null, fontStack, null);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @Nullable
    public Number getFontScale() {
        return this.fontScale;
    }

    @Nullable
    public String[] getFontStack() {
        return this.fontStack;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setFontScale(@Nullable Number fontScale) {
        this.fontScale = fontScale;
    }

    public void setFontStack(@Nullable String[] fontStack) {
        this.fontStack = fontStack;
    }

    public void setTextColor(@Nullable String textColor) {
        this.textColor = textColor;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = ColorUtils.colorToRgbaString(textColor);
    }

    void setTextColor(@NonNull Object textColor) {
        this.setTextColor(ColorUtils.colorToRgbaString(ColorUtils.rgbaToColor((String)textColor)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattedSection that = (FormattedSection)o;
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.fontScale != null ? !this.fontScale.equals(that.fontScale) : that.fontScale != null) {
            return false;
        }
        if (!Arrays.equals(this.fontStack, that.fontStack)) {
            return false;
        }
        return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
    }

    public int hashCode() {
        int result = this.text != null ? this.text.hashCode() : 0;
        result = 31 * result + (this.fontScale != null ? this.fontScale.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.fontStack);
        result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
        return result;
    }

    Object[] toArray() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("font-scale", this.fontScale);
        params.put("text-font", this.fontStack);
        params.put("text-color", this.textColor);
        return new Object[]{this.text, params};
    }

    public String toString() {
        return "FormattedSection{text='" + this.text + '\'' + ", fontScale=" + this.fontScale + ", fontStack=" + Arrays.toString(this.fontStack) + ", textColor='" + this.textColor + '\'' + '}';
    }
}

