/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.ArrayList;

public class Projection {
    @NonNull
    private final NativeMapView nativeMapView;
    private int[] contentPadding;

    Projection(@NonNull NativeMapView nativeMapView) {
        this.nativeMapView = nativeMapView;
        this.contentPadding = new int[]{0, 0, 0, 0};
    }

    void setContentPadding(int[] contentPadding) {
        this.contentPadding = contentPadding;
        float[] output = new float[contentPadding.length];
        for (int i = 0; i < contentPadding.length; ++i) {
            output[i] = contentPadding[i];
        }
        this.nativeMapView.setContentPadding(output);
    }

    int[] getContentPadding() {
        return this.contentPadding;
    }

    public void invalidateContentPadding() {
        this.setContentPadding(this.contentPadding);
    }

    @NonNull
    public ProjectedMeters getProjectedMetersForLatLng(@NonNull LatLng latLng) {
        return this.nativeMapView.projectedMetersForLatLng(latLng);
    }

    @NonNull
    public LatLng getLatLngForProjectedMeters(@NonNull ProjectedMeters projectedMeters) {
        return this.nativeMapView.latLngForProjectedMeters(projectedMeters);
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        return this.nativeMapView.getMetersPerPixelAtLatitude(latitude);
    }

    @NonNull
    public LatLng fromScreenLocation(@NonNull PointF point) {
        return this.nativeMapView.latLngForPixel(point);
    }

    @NonNull
    public VisibleRegion getVisibleRegion() {
        return this.getVisibleRegion(true);
    }

    @NonNull
    public VisibleRegion getVisibleRegion(boolean ignorePadding) {
        float bottom;
        float top;
        float right;
        float left;
        if (ignorePadding) {
            left = 0.0f;
            right = this.nativeMapView.getWidth();
            top = 0.0f;
            bottom = this.nativeMapView.getHeight();
        } else {
            left = this.contentPadding[0];
            right = this.nativeMapView.getWidth() - this.contentPadding[2];
            top = this.contentPadding[1];
            bottom = this.nativeMapView.getHeight() - this.contentPadding[3];
        }
        LatLng center = this.fromScreenLocation(new PointF(left + (right - left) / 2.0f, top + (bottom - top) / 2.0f));
        LatLng topLeft = this.fromScreenLocation(new PointF(left, top));
        LatLng topRight = this.fromScreenLocation(new PointF(right, top));
        LatLng bottomRight = this.fromScreenLocation(new PointF(right, bottom));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(left, bottom));
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        latLngs.add(topRight);
        latLngs.add(bottomRight);
        latLngs.add(bottomLeft);
        latLngs.add(topLeft);
        double maxEastLonSpan = 0.0;
        double maxWestLonSpan = 0.0;
        double east = 0.0;
        double west = 0.0;
        double north = -90.0;
        double south = 90.0;
        for (LatLng latLng : latLngs) {
            double span;
            double bearing = Projection.bearing(center, latLng);
            if (bearing >= 0.0) {
                span = Projection.getLongitudeSpan(latLng.getLongitude(), center.getLongitude());
                if (span > maxEastLonSpan) {
                    maxEastLonSpan = span;
                    east = latLng.getLongitude();
                }
            } else {
                span = Projection.getLongitudeSpan(center.getLongitude(), latLng.getLongitude());
                if (span > maxWestLonSpan) {
                    maxWestLonSpan = span;
                    west = latLng.getLongitude();
                }
            }
            if (north < latLng.getLatitude()) {
                north = latLng.getLatitude();
            }
            if (!(south > latLng.getLatitude())) continue;
            south = latLng.getLatitude();
        }
        if (east < west) {
            return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, LatLngBounds.from(north, east + 360.0, south, west));
        }
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, LatLngBounds.from(north, east, south, west));
    }

    static double bearing(@NonNull LatLng latLng1, @NonNull LatLng latLng2) {
        double lon1 = Projection.degreesToRadians(latLng1.getLongitude());
        double lon2 = Projection.degreesToRadians(latLng2.getLongitude());
        double lat1 = Projection.degreesToRadians(latLng1.getLatitude());
        double lat2 = Projection.degreesToRadians(latLng2.getLatitude());
        double value1 = Math.sin(lon2 - lon1) * Math.cos(lat2);
        double value2 = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1);
        return Projection.radiansToDegrees(Math.atan2(value1, value2));
    }

    static double degreesToRadians(double degrees) {
        double radians = degrees % 360.0;
        return radians * Math.PI / 180.0;
    }

    static double radiansToDegrees(double radians) {
        double degrees = radians % (Math.PI * 2);
        return degrees * 180.0 / Math.PI;
    }

    static double getLongitudeSpan(double east, double west) {
        double longSpan = Math.abs(east - west);
        if (east > west) {
            return longSpan;
        }
        return 360.0 - longSpan;
    }

    @NonNull
    public PointF toScreenLocation(@NonNull LatLng location) {
        return this.nativeMapView.pixelForLatLng(location);
    }

    float getHeight() {
        return this.nativeMapView.getHeight();
    }

    float getWidth() {
        return this.nativeMapView.getWidth();
    }

    public double calculateZoom(float minScale) {
        return this.nativeMapView.getZoom() + Math.log(minScale) / Math.log(2.0);
    }
}

