/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.support.annotation.Keep;

public class OfflineRegionStatus {
    private int downloadState = 0;
    private long completedResourceCount = 0L;
    private long completedResourceSize = 0L;
    private long completedTileCount = 0L;
    private long completedTileSize = 0L;
    private long requiredResourceCount = 0L;
    private boolean requiredResourceCountIsPrecise = true;

    @Keep
    private OfflineRegionStatus(int downloadState, long completedResourceCount, long completedResourceSize, long completedTileCount, long completedTileSize, long requiredResourceCount, boolean requiredResourceCountIsPrecise) {
        this.downloadState = downloadState;
        this.completedResourceCount = completedResourceCount;
        this.completedResourceSize = completedResourceSize;
        this.completedTileCount = completedTileCount;
        this.completedTileSize = completedTileSize;
        this.requiredResourceCount = requiredResourceCount;
        this.requiredResourceCountIsPrecise = requiredResourceCountIsPrecise;
    }

    public boolean isComplete() {
        return this.completedResourceCount == this.requiredResourceCount && this.downloadState == 0;
    }

    public int getDownloadState() {
        return this.downloadState;
    }

    public long getCompletedResourceCount() {
        return this.completedResourceCount;
    }

    public long getCompletedResourceSize() {
        return this.completedResourceSize;
    }

    public long getCompletedTileCount() {
        return this.completedTileCount;
    }

    public long getCompletedTileSize() {
        return this.completedTileSize;
    }

    public long getRequiredResourceCount() {
        return this.requiredResourceCount;
    }

    public boolean isRequiredResourceCountPrecise() {
        return this.requiredResourceCountIsPrecise;
    }
}

