/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.content.res.AppCompatResources;
import android.view.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BitmapUtils {
    public static Bitmap createBitmapFromView(@NonNull View view) {
        view.setDrawingCacheEnabled(true);
        view.setDrawingCacheQuality(524288);
        view.buildDrawingCache();
        if (view.getDrawingCache() == null) {
            return null;
        }
        Bitmap snapshot = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        view.destroyDrawingCache();
        return snapshot;
    }

    public static Bitmap mergeBitmap(@NonNull Bitmap background, @NonNull Bitmap foreground) {
        Bitmap result = Bitmap.createBitmap((int)background.getWidth(), (int)background.getHeight(), (Bitmap.Config)background.getConfig());
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(background, 0.0f, 0.0f, null);
        canvas.drawBitmap(foreground, 10.0f, 10.0f, null);
        return result;
    }

    @Nullable
    public static Bitmap getBitmapFromDrawable(@Nullable Drawable sourceDrawable) {
        if (sourceDrawable == null) {
            return null;
        }
        if (sourceDrawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)sourceDrawable).getBitmap();
        }
        Drawable.ConstantState constantState = sourceDrawable.getConstantState();
        if (constantState == null) {
            return null;
        }
        Drawable drawable2 = constantState.newDrawable().mutate();
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    @Nullable
    public static byte[] getByteArrayFromDrawable(@Nullable Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    @Nullable
    public static Drawable getDrawableFromByteArray(@NonNull Context context, @Nullable byte[] array) {
        if (array == null) {
            return null;
        }
        Bitmap compass = BitmapFactory.decodeByteArray((byte[])array, (int)0, (int)array.length);
        return new BitmapDrawable(context.getResources(), compass);
    }

    @Nullable
    public static Drawable getDrawableFromRes(@NonNull Context context, @DrawableRes int drawableRes) {
        return BitmapUtils.getDrawableFromRes(context, drawableRes, null);
    }

    @Nullable
    public static Drawable getDrawableFromRes(@NonNull Context context, @DrawableRes int drawableRes, @Nullable @ColorInt Integer tintColor) {
        Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)drawableRes);
        if (drawable2 == null) {
            return null;
        }
        if (tintColor == null) {
            return drawable2;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            drawable2.setTint(tintColor.intValue());
        } else {
            drawable2.mutate().setColorFilter(tintColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
        return drawable2;
    }

    @VisibleForTesting
    public static boolean equals(Bitmap bitmap, Bitmap other) {
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getHeight() * bitmap.getRowBytes());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        ByteBuffer bufferOther = ByteBuffer.allocate(other.getHeight() * other.getRowBytes());
        other.copyPixelsToBuffer((Buffer)bufferOther);
        return Arrays.equals(buffer.array(), bufferOther.array());
    }
}

