/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.animation.Animator;
import android.location.Location;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.MapboxAnimatorProvider;
import com.mapbox.mapboxsdk.location.MapboxAnimatorSetProvider;
import com.mapbox.mapboxsdk.location.MapboxFloatAnimator;
import com.mapbox.mapboxsdk.location.MapboxLatLngAnimator;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import java.util.ArrayList;
import java.util.Set;

final class LocationAnimatorCoordinator {
    private static final String TAG = "Mbgl-LocationAnimatorCoordinator";
    @VisibleForTesting
    final SparseArray<MapboxAnimator> animatorArray = new SparseArray();
    private final Projection projection;
    private Location previousLocation;
    private float previousAccuracyRadius = -1.0f;
    private float previousCompassBearing = -1.0f;
    private long locationUpdateTimestamp = -1L;
    private float durationMultiplier;
    private final MapboxAnimatorProvider animatorProvider;
    private final MapboxAnimatorSetProvider animatorSetProvider;
    private boolean compassAnimationEnabled;
    private boolean accuracyAnimationEnabled;
    @VisibleForTesting
    int maxAnimationFps = Integer.MAX_VALUE;
    @VisibleForTesting
    final SparseArray<MapboxAnimator.AnimationsValueChangeListener> listeners = new SparseArray();

    LocationAnimatorCoordinator(@NonNull Projection projection, @NonNull MapboxAnimatorSetProvider animatorSetProvider, @NonNull MapboxAnimatorProvider animatorProvider) {
        this.projection = projection;
        this.animatorProvider = animatorProvider;
        this.animatorSetProvider = animatorSetProvider;
    }

    void updateAnimatorListenerHolders(@NonNull Set<AnimatorListenerHolder> listenerHolders) {
        this.listeners.clear();
        for (AnimatorListenerHolder holder : listenerHolders) {
            this.listeners.append(holder.getAnimatorType(), (Object)holder.getListener());
        }
    }

    void feedNewLocation(@NonNull Location newLocation, @NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        if (this.previousLocation == null) {
            this.previousLocation = newLocation;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime() - 750L;
        }
        LatLng previousLayerLatLng = this.getPreviousLayerLatLng();
        float previousLayerBearing = this.getPreviousLayerGpsBearing();
        LatLng previousCameraLatLng = currentCameraPosition.target;
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        LatLng targetLatLng = new LatLng(newLocation);
        float targetLayerBearing = newLocation.getBearing();
        float targetCameraBearing = newLocation.getBearing();
        targetCameraBearing = this.checkGpsNorth(isGpsNorth, targetCameraBearing);
        this.updateLayerAnimators(previousLayerLatLng, targetLatLng, previousLayerBearing, targetLayerBearing);
        this.updateCameraAnimators(previousCameraLatLng, previousCameraBearing, targetLatLng, targetCameraBearing);
        boolean snap = Utils.immediateAnimation(this.projection, previousCameraLatLng, targetLatLng) || Utils.immediateAnimation(this.projection, previousLayerLatLng, targetLatLng);
        this.playAnimators(snap ? 0L : this.getAnimationDuration(), 0, 2, 1, 4);
        this.previousLocation = newLocation;
    }

    void feedNewCompassBearing(float targetCompassBearing, @NonNull CameraPosition currentCameraPosition) {
        if (this.previousCompassBearing < 0.0f) {
            this.previousCompassBearing = targetCompassBearing;
        }
        float previousLayerBearing = this.getPreviousLayerCompassBearing();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        this.updateCompassAnimators(targetCompassBearing, previousLayerBearing, previousCameraBearing);
        this.playAnimators(this.compassAnimationEnabled ? 500L : 0L, 3, 5);
        this.previousCompassBearing = targetCompassBearing;
    }

    void feedNewAccuracyRadius(float targetAccuracyRadius, boolean noAnimation) {
        if (this.previousAccuracyRadius < 0.0f) {
            this.previousAccuracyRadius = targetAccuracyRadius;
        }
        float previousAccuracyRadius = this.getPreviousAccuracyRadius();
        this.updateAccuracyAnimators(targetAccuracyRadius, previousAccuracyRadius);
        this.playAnimators(noAnimation || !this.accuracyAnimationEnabled ? 0L : 250L, 6);
        this.previousAccuracyRadius = targetAccuracyRadius;
    }

    void feedNewZoomLevel(double targetZoomLevel, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        this.updateZoomAnimator((float)targetZoomLevel, (float)currentCameraPosition.zoom, callback);
        this.playAnimators(animationDuration, 7);
    }

    void feedNewTilt(double targetTilt, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        this.updateTiltAnimator((float)targetTilt, (float)currentCameraPosition.tilt, callback);
        this.playAnimators(animationDuration, 8);
    }

    private LatLng getPreviousLayerLatLng() {
        MapboxAnimator latLngAnimator = (MapboxAnimator)((Object)this.animatorArray.get(0));
        LatLng previousLatLng = latLngAnimator != null ? (LatLng)latLngAnimator.getAnimatedValue() : new LatLng(this.previousLocation);
        return previousLatLng;
    }

    private float getPreviousLayerGpsBearing() {
        MapboxFloatAnimator animator = (MapboxFloatAnimator)((Object)this.animatorArray.get(2));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousLocation.getBearing();
        return previousBearing;
    }

    private float getPreviousLayerCompassBearing() {
        MapboxFloatAnimator animator = (MapboxFloatAnimator)((Object)this.animatorArray.get(3));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousCompassBearing;
        return previousBearing;
    }

    private float getPreviousAccuracyRadius() {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(6));
        float previousRadius = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousAccuracyRadius;
        return previousRadius;
    }

    private void updateLayerAnimators(LatLng previousLatLng, LatLng targetLatLng, float previousBearing, float targetBearing) {
        this.createNewLatLngAnimator(0, previousLatLng, targetLatLng);
        float normalizedLayerBearing = Utils.shortestRotation(targetBearing, previousBearing);
        this.createNewFloatAnimator(2, previousBearing, normalizedLayerBearing);
    }

    private void updateCameraAnimators(LatLng previousCameraLatLng, float previousCameraBearing, LatLng targetLatLng, float targetBearing) {
        this.createNewLatLngAnimator(1, previousCameraLatLng, targetLatLng);
        float normalizedCameraBearing = Utils.shortestRotation(targetBearing, previousCameraBearing);
        this.createNewFloatAnimator(4, previousCameraBearing, normalizedCameraBearing);
    }

    private void updateCompassAnimators(float targetCompassBearing, float previousLayerBearing, float previousCameraBearing) {
        float normalizedLayerBearing = Utils.shortestRotation(targetCompassBearing, previousLayerBearing);
        this.createNewFloatAnimator(3, previousLayerBearing, normalizedLayerBearing);
        float normalizedCameraBearing = Utils.shortestRotation(targetCompassBearing, previousCameraBearing);
        this.createNewFloatAnimator(5, previousCameraBearing, normalizedCameraBearing);
    }

    private void updateAccuracyAnimators(float targetAccuracyRadius, float previousAccuracyRadius) {
        this.createNewFloatAnimator(6, previousAccuracyRadius, targetAccuracyRadius);
    }

    private void updateZoomAnimator(float targetZoomLevel, float previousZoomLevel, @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(7, previousZoomLevel, targetZoomLevel, cancelableCallback);
    }

    private void updateTiltAnimator(float targetTilt, float previousTiltLevel, @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(8, previousTiltLevel, targetTilt, cancelableCallback);
    }

    private void createNewLatLngAnimator(int animatorType, LatLng previous, LatLng target) {
        this.cancelAnimator(animatorType);
        MapboxAnimator.AnimationsValueChangeListener listener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.latLngAnimator(previous, target, listener, this.maxAnimationFps));
        }
    }

    private void createNewFloatAnimator(int animatorType, float previous, float target) {
        this.cancelAnimator(animatorType);
        MapboxAnimator.AnimationsValueChangeListener listener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.floatAnimator(Float.valueOf(previous), Float.valueOf(target), listener, this.maxAnimationFps));
        }
    }

    private void createNewCameraAdapterAnimator(int animatorType, float previous, float target, @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        this.cancelAnimator(animatorType);
        MapboxAnimator.AnimationsValueChangeListener listener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.cameraAnimator(Float.valueOf(previous), Float.valueOf(target), listener, cancelableCallback));
        }
    }

    private long getAnimationDuration() {
        long previousUpdateTimeStamp = this.locationUpdateTimestamp;
        this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
        long animationDuration = previousUpdateTimeStamp == 0L ? 0L : (long)((float)(this.locationUpdateTimestamp - previousUpdateTimeStamp) * this.durationMultiplier);
        animationDuration = Math.min(animationDuration, 2000L);
        return animationDuration;
    }

    private float checkGpsNorth(boolean isGpsNorth, float targetCameraBearing) {
        if (isGpsNorth) {
            targetCameraBearing = 0.0f;
        }
        return targetCameraBearing;
    }

    private void playAnimators(long duration, int ... animatorTypes) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (int animatorType : animatorTypes) {
            Animator animator = (Animator)this.animatorArray.get(animatorType);
            if (animator == null) continue;
            animators.add(animator);
        }
        this.animatorSetProvider.startAnimation(animators, (Interpolator)new LinearInterpolator(), duration);
    }

    void resetAllCameraAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraCompassAnimation(currentCameraPosition);
        boolean snap = this.resetCameraLocationAnimations(currentCameraPosition, isGpsNorth);
        this.playAnimators(snap ? 0L : 750L, 1, 4);
    }

    private boolean resetCameraLocationAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraGpsBearingAnimation(currentCameraPosition, isGpsNorth);
        return this.resetCameraLatLngAnimation(currentCameraPosition);
    }

    private boolean resetCameraLatLngAnimation(@NonNull CameraPosition currentCameraPosition) {
        MapboxLatLngAnimator animator = (MapboxLatLngAnimator)((Object)this.animatorArray.get(1));
        if (animator == null) {
            return false;
        }
        LatLng currentTarget = (LatLng)animator.getTarget();
        LatLng previousCameraTarget = currentCameraPosition.target;
        this.createNewLatLngAnimator(1, previousCameraTarget, currentTarget);
        return Utils.immediateAnimation(this.projection, previousCameraTarget, currentTarget);
    }

    private void resetCameraGpsBearingAnimation(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        MapboxFloatAnimator animator = (MapboxFloatAnimator)((Object)this.animatorArray.get(4));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        currentTargetBearing = this.checkGpsNorth(isGpsNorth, currentTargetBearing);
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewFloatAnimator(4, previousCameraBearing, normalizedCameraBearing);
    }

    private void resetCameraCompassAnimation(@NonNull CameraPosition currentCameraPosition) {
        MapboxFloatAnimator animator = (MapboxFloatAnimator)((Object)this.animatorArray.get(5));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewFloatAnimator(5, previousCameraBearing, normalizedCameraBearing);
    }

    void cancelZoomAnimation() {
        this.cancelAnimator(7);
    }

    void cancelTiltAnimation() {
        this.cancelAnimator(8);
    }

    void cancelAllAnimations() {
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            int animatorType = this.animatorArray.keyAt(i);
            this.cancelAnimator(animatorType);
        }
    }

    private void cancelAnimator(int animatorType) {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(animatorType));
        if (animator != null) {
            animator.cancel();
            animator.removeAllUpdateListeners();
            animator.removeAllListeners();
            this.animatorArray.put(animatorType, null);
        }
    }

    void setTrackingAnimationDurationMultiplier(float trackingAnimationDurationMultiplier) {
        this.durationMultiplier = trackingAnimationDurationMultiplier;
    }

    void setCompassAnimationEnabled(boolean compassAnimationEnabled) {
        this.compassAnimationEnabled = compassAnimationEnabled;
    }

    void setAccuracyAnimationEnabled(boolean accuracyAnimationEnabled) {
        this.accuracyAnimationEnabled = accuracyAnimationEnabled;
    }

    void setMaxAnimationFps(int maxAnimationFps) {
        if (maxAnimationFps <= 0) {
            Logger.e(TAG, "Max animation FPS cannot be less or equal to 0.");
            return;
        }
        this.maxAnimationFps = maxAnimationFps;
    }
}

