/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.types;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;

@Keep
public class FormattedSection {
    private final String text;
    private final Number fontScale;
    private final String[] fontStack;

    public FormattedSection(@NonNull String text, @Nullable Number fontScale, @Nullable String[] fontStack) {
        this.text = text;
        this.fontScale = fontScale;
        this.fontStack = fontStack;
    }

    public FormattedSection(@NonNull String text, @Nullable Number fontScale) {
        this(text, fontScale, null);
    }

    public FormattedSection(@NonNull String text) {
        this(text, null, null);
    }

    public FormattedSection(@NonNull String text, @Nullable String[] fontStack) {
        this(text, null, fontStack);
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    @Nullable
    public Number getFontScale() {
        return this.fontScale;
    }

    @Nullable
    public String[] getFontStack() {
        return this.fontStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattedSection that = (FormattedSection)o;
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.fontScale != null ? !this.fontScale.equals(that.fontScale) : that.fontScale != null) {
            return false;
        }
        return Arrays.equals(this.fontStack, that.fontStack);
    }

    public int hashCode() {
        int result = this.text != null ? this.text.hashCode() : 0;
        result = 31 * result + (this.fontScale != null ? this.fontScale.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.fontStack);
        return result;
    }

    Object[] toArray() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("font-scale", this.fontScale);
        params.put("text-font", this.fontStack);
        return new Object[]{this.text, params};
    }
}

