/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.types.Formatted;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class SymbolLayer
extends Layer {
    @Keep
    SymbolLayer(long nativePtr) {
        super(nativePtr);
    }

    public SymbolLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public SymbolLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public SymbolLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    @NonNull
    public SymbolLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<String> getSymbolPlacement() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-placement", this.nativeGetSymbolPlacement());
    }

    @NonNull
    public PropertyValue<Float> getSymbolSpacing() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-spacing", this.nativeGetSymbolSpacing());
    }

    @NonNull
    public PropertyValue<Boolean> getSymbolAvoidEdges() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-avoid-edges", this.nativeGetSymbolAvoidEdges());
    }

    @NonNull
    public PropertyValue<String> getSymbolZOrder() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-z-order", this.nativeGetSymbolZOrder());
    }

    @NonNull
    public PropertyValue<Boolean> getIconAllowOverlap() {
        this.checkThread();
        return new PropertyValue<Object>("icon-allow-overlap", this.nativeGetIconAllowOverlap());
    }

    @NonNull
    public PropertyValue<Boolean> getIconIgnorePlacement() {
        this.checkThread();
        return new PropertyValue<Object>("icon-ignore-placement", this.nativeGetIconIgnorePlacement());
    }

    @NonNull
    public PropertyValue<Boolean> getIconOptional() {
        this.checkThread();
        return new PropertyValue<Object>("icon-optional", this.nativeGetIconOptional());
    }

    @NonNull
    public PropertyValue<String> getIconRotationAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("icon-rotation-alignment", this.nativeGetIconRotationAlignment());
    }

    @NonNull
    public PropertyValue<Float> getIconSize() {
        this.checkThread();
        return new PropertyValue<Object>("icon-size", this.nativeGetIconSize());
    }

    @NonNull
    public PropertyValue<String> getIconTextFit() {
        this.checkThread();
        return new PropertyValue<Object>("icon-text-fit", this.nativeGetIconTextFit());
    }

    @NonNull
    public PropertyValue<Float[]> getIconTextFitPadding() {
        this.checkThread();
        return new PropertyValue<Object>("icon-text-fit-padding", this.nativeGetIconTextFitPadding());
    }

    @NonNull
    public PropertyValue<String> getIconImage() {
        this.checkThread();
        return new PropertyValue<Object>("icon-image", this.nativeGetIconImage());
    }

    @NonNull
    public PropertyValue<Float> getIconRotate() {
        this.checkThread();
        return new PropertyValue<Object>("icon-rotate", this.nativeGetIconRotate());
    }

    @NonNull
    public PropertyValue<Float> getIconPadding() {
        this.checkThread();
        return new PropertyValue<Object>("icon-padding", this.nativeGetIconPadding());
    }

    @NonNull
    public PropertyValue<Boolean> getIconKeepUpright() {
        this.checkThread();
        return new PropertyValue<Object>("icon-keep-upright", this.nativeGetIconKeepUpright());
    }

    @NonNull
    public PropertyValue<Float[]> getIconOffset() {
        this.checkThread();
        return new PropertyValue<Object>("icon-offset", this.nativeGetIconOffset());
    }

    @NonNull
    public PropertyValue<String> getIconAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-anchor", this.nativeGetIconAnchor());
    }

    @NonNull
    public PropertyValue<String> getIconPitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("icon-pitch-alignment", this.nativeGetIconPitchAlignment());
    }

    @NonNull
    public PropertyValue<String> getTextPitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("text-pitch-alignment", this.nativeGetTextPitchAlignment());
    }

    @NonNull
    public PropertyValue<String> getTextRotationAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("text-rotation-alignment", this.nativeGetTextRotationAlignment());
    }

    @NonNull
    public PropertyValue<Formatted> getTextField() {
        this.checkThread();
        return new PropertyValue<Object>("text-field", this.nativeGetTextField());
    }

    @NonNull
    public PropertyValue<String[]> getTextFont() {
        this.checkThread();
        return new PropertyValue<Object>("text-font", this.nativeGetTextFont());
    }

    @NonNull
    public PropertyValue<Float> getTextSize() {
        this.checkThread();
        return new PropertyValue<Object>("text-size", this.nativeGetTextSize());
    }

    @NonNull
    public PropertyValue<Float> getTextMaxWidth() {
        this.checkThread();
        return new PropertyValue<Object>("text-max-width", this.nativeGetTextMaxWidth());
    }

    @NonNull
    public PropertyValue<Float> getTextLineHeight() {
        this.checkThread();
        return new PropertyValue<Object>("text-line-height", this.nativeGetTextLineHeight());
    }

    @NonNull
    public PropertyValue<Float> getTextLetterSpacing() {
        this.checkThread();
        return new PropertyValue<Object>("text-letter-spacing", this.nativeGetTextLetterSpacing());
    }

    @NonNull
    public PropertyValue<String> getTextJustify() {
        this.checkThread();
        return new PropertyValue<Object>("text-justify", this.nativeGetTextJustify());
    }

    @NonNull
    public PropertyValue<String> getTextAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("text-anchor", this.nativeGetTextAnchor());
    }

    @NonNull
    public PropertyValue<Float> getTextMaxAngle() {
        this.checkThread();
        return new PropertyValue<Object>("text-max-angle", this.nativeGetTextMaxAngle());
    }

    @NonNull
    public PropertyValue<Float> getTextRotate() {
        this.checkThread();
        return new PropertyValue<Object>("text-rotate", this.nativeGetTextRotate());
    }

    @NonNull
    public PropertyValue<Float> getTextPadding() {
        this.checkThread();
        return new PropertyValue<Object>("text-padding", this.nativeGetTextPadding());
    }

    @NonNull
    public PropertyValue<Boolean> getTextKeepUpright() {
        this.checkThread();
        return new PropertyValue<Object>("text-keep-upright", this.nativeGetTextKeepUpright());
    }

    @NonNull
    public PropertyValue<String> getTextTransform() {
        this.checkThread();
        return new PropertyValue<Object>("text-transform", this.nativeGetTextTransform());
    }

    @NonNull
    public PropertyValue<Float[]> getTextOffset() {
        this.checkThread();
        return new PropertyValue<Object>("text-offset", this.nativeGetTextOffset());
    }

    @NonNull
    public PropertyValue<Boolean> getTextAllowOverlap() {
        this.checkThread();
        return new PropertyValue<Object>("text-allow-overlap", this.nativeGetTextAllowOverlap());
    }

    @NonNull
    public PropertyValue<Boolean> getTextIgnorePlacement() {
        this.checkThread();
        return new PropertyValue<Object>("text-ignore-placement", this.nativeGetTextIgnorePlacement());
    }

    @NonNull
    public PropertyValue<Boolean> getTextOptional() {
        this.checkThread();
        return new PropertyValue<Object>("text-optional", this.nativeGetTextOptional());
    }

    @NonNull
    public PropertyValue<Float> getIconOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("icon-opacity", this.nativeGetIconOpacity());
    }

    @NonNull
    public TransitionOptions getIconOpacityTransition() {
        this.checkThread();
        return this.nativeGetIconOpacityTransition();
    }

    public void setIconOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getIconColor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-color", this.nativeGetIconColor());
    }

    @ColorInt
    public int getIconColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getIconColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getIconColorTransition() {
        this.checkThread();
        return this.nativeGetIconColorTransition();
    }

    public void setIconColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getIconHaloColor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-color", this.nativeGetIconHaloColor());
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getIconHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-halo-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getIconHaloColorTransition() {
        this.checkThread();
        return this.nativeGetIconHaloColorTransition();
    }

    public void setIconHaloColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getIconHaloWidth() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-width", this.nativeGetIconHaloWidth());
    }

    @NonNull
    public TransitionOptions getIconHaloWidthTransition() {
        this.checkThread();
        return this.nativeGetIconHaloWidthTransition();
    }

    public void setIconHaloWidthTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getIconHaloBlur() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-blur", this.nativeGetIconHaloBlur());
    }

    @NonNull
    public TransitionOptions getIconHaloBlurTransition() {
        this.checkThread();
        return this.nativeGetIconHaloBlurTransition();
    }

    public void setIconHaloBlurTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getIconTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("icon-translate", this.nativeGetIconTranslate());
    }

    @NonNull
    public TransitionOptions getIconTranslateTransition() {
        this.checkThread();
        return this.nativeGetIconTranslateTransition();
    }

    public void setIconTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getIconTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-translate-anchor", this.nativeGetIconTranslateAnchor());
    }

    @NonNull
    public PropertyValue<Float> getTextOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("text-opacity", this.nativeGetTextOpacity());
    }

    @NonNull
    public TransitionOptions getTextOpacityTransition() {
        this.checkThread();
        return this.nativeGetTextOpacityTransition();
    }

    public void setTextOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getTextColor() {
        this.checkThread();
        return new PropertyValue<Object>("text-color", this.nativeGetTextColor());
    }

    @ColorInt
    public int getTextColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getTextColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getTextColorTransition() {
        this.checkThread();
        return this.nativeGetTextColorTransition();
    }

    public void setTextColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getTextHaloColor() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-color", this.nativeGetTextHaloColor());
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getTextHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-halo-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getTextHaloColorTransition() {
        this.checkThread();
        return this.nativeGetTextHaloColorTransition();
    }

    public void setTextHaloColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getTextHaloWidth() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-width", this.nativeGetTextHaloWidth());
    }

    @NonNull
    public TransitionOptions getTextHaloWidthTransition() {
        this.checkThread();
        return this.nativeGetTextHaloWidthTransition();
    }

    public void setTextHaloWidthTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getTextHaloBlur() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-blur", this.nativeGetTextHaloBlur());
    }

    @NonNull
    public TransitionOptions getTextHaloBlurTransition() {
        this.checkThread();
        return this.nativeGetTextHaloBlurTransition();
    }

    public void setTextHaloBlurTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getTextTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("text-translate", this.nativeGetTextTranslate());
    }

    @NonNull
    public TransitionOptions getTextTranslateTransition() {
        this.checkThread();
        return this.nativeGetTextTranslateTransition();
    }

    public void setTextTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getTextTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("text-translate-anchor", this.nativeGetTextTranslateAnchor());
    }

    @NonNull
    @Keep
    private native Object nativeGetSymbolPlacement();

    @NonNull
    @Keep
    private native Object nativeGetSymbolSpacing();

    @NonNull
    @Keep
    private native Object nativeGetSymbolAvoidEdges();

    @NonNull
    @Keep
    private native Object nativeGetSymbolZOrder();

    @NonNull
    @Keep
    private native Object nativeGetIconAllowOverlap();

    @NonNull
    @Keep
    private native Object nativeGetIconIgnorePlacement();

    @NonNull
    @Keep
    private native Object nativeGetIconOptional();

    @NonNull
    @Keep
    private native Object nativeGetIconRotationAlignment();

    @NonNull
    @Keep
    private native Object nativeGetIconSize();

    @NonNull
    @Keep
    private native Object nativeGetIconTextFit();

    @NonNull
    @Keep
    private native Object nativeGetIconTextFitPadding();

    @NonNull
    @Keep
    private native Object nativeGetIconImage();

    @NonNull
    @Keep
    private native Object nativeGetIconRotate();

    @NonNull
    @Keep
    private native Object nativeGetIconPadding();

    @NonNull
    @Keep
    private native Object nativeGetIconKeepUpright();

    @NonNull
    @Keep
    private native Object nativeGetIconOffset();

    @NonNull
    @Keep
    private native Object nativeGetIconAnchor();

    @NonNull
    @Keep
    private native Object nativeGetIconPitchAlignment();

    @NonNull
    @Keep
    private native Object nativeGetTextPitchAlignment();

    @NonNull
    @Keep
    private native Object nativeGetTextRotationAlignment();

    @NonNull
    @Keep
    private native Object nativeGetTextField();

    @NonNull
    @Keep
    private native Object nativeGetTextFont();

    @NonNull
    @Keep
    private native Object nativeGetTextSize();

    @NonNull
    @Keep
    private native Object nativeGetTextMaxWidth();

    @NonNull
    @Keep
    private native Object nativeGetTextLineHeight();

    @NonNull
    @Keep
    private native Object nativeGetTextLetterSpacing();

    @NonNull
    @Keep
    private native Object nativeGetTextJustify();

    @NonNull
    @Keep
    private native Object nativeGetTextAnchor();

    @NonNull
    @Keep
    private native Object nativeGetTextMaxAngle();

    @NonNull
    @Keep
    private native Object nativeGetTextRotate();

    @NonNull
    @Keep
    private native Object nativeGetTextPadding();

    @NonNull
    @Keep
    private native Object nativeGetTextKeepUpright();

    @NonNull
    @Keep
    private native Object nativeGetTextTransform();

    @NonNull
    @Keep
    private native Object nativeGetTextOffset();

    @NonNull
    @Keep
    private native Object nativeGetTextAllowOverlap();

    @NonNull
    @Keep
    private native Object nativeGetTextIgnorePlacement();

    @NonNull
    @Keep
    private native Object nativeGetTextOptional();

    @NonNull
    @Keep
    private native Object nativeGetIconOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconOpacityTransition();

    @Keep
    private native void nativeSetIconOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconColorTransition();

    @Keep
    private native void nativeSetIconColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconHaloColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconHaloColorTransition();

    @Keep
    private native void nativeSetIconHaloColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconHaloWidth();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconHaloWidthTransition();

    @Keep
    private native void nativeSetIconHaloWidthTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconHaloBlur();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconHaloBlurTransition();

    @Keep
    private native void nativeSetIconHaloBlurTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetIconTranslateTransition();

    @Keep
    private native void nativeSetIconTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetIconTranslateAnchor();

    @NonNull
    @Keep
    private native Object nativeGetTextOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextOpacityTransition();

    @Keep
    private native void nativeSetTextOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextColorTransition();

    @Keep
    private native void nativeSetTextColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextHaloColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextHaloColorTransition();

    @Keep
    private native void nativeSetTextHaloColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextHaloWidth();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextHaloWidthTransition();

    @Keep
    private native void nativeSetTextHaloWidthTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextHaloBlur();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextHaloBlurTransition();

    @Keep
    private native void nativeSetTextHaloBlurTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTextTranslateTransition();

    @Keep
    private native void nativeSetTextTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTextTranslateAnchor();

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

