/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;

public class OfflineTilePyramidRegionDefinition
implements OfflineRegionDefinition,
Parcelable {
    @Keep
    private String styleURL;
    @Keep
    private LatLngBounds bounds;
    @Keep
    private double minZoom;
    @Keep
    private double maxZoom;
    @Keep
    private float pixelRatio;
    @Keep
    private boolean includeIdeographs;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineTilePyramidRegionDefinition createFromParcel(@NonNull Parcel in) {
            return new OfflineTilePyramidRegionDefinition(in);
        }

        public OfflineTilePyramidRegionDefinition[] newArray(int size) {
            return new OfflineTilePyramidRegionDefinition[size];
        }
    };

    @Keep
    public OfflineTilePyramidRegionDefinition(String styleURL, LatLngBounds bounds, double minZoom, double maxZoom, float pixelRatio) {
        this(styleURL, bounds, minZoom, maxZoom, pixelRatio, true);
    }

    @Keep
    public OfflineTilePyramidRegionDefinition(String styleURL, LatLngBounds bounds, double minZoom, double maxZoom, float pixelRatio, boolean includeIdeographs) {
        this.styleURL = styleURL;
        this.bounds = bounds;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.pixelRatio = pixelRatio;
        this.includeIdeographs = includeIdeographs;
    }

    public OfflineTilePyramidRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.bounds = new LatLngBounds.Builder().include(new LatLng(parcel.readDouble(), parcel.readDouble())).include(new LatLng(parcel.readDouble(), parcel.readDouble())).build();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
    }

    @Override
    public String getStyleURL() {
        return this.styleURL;
    }

    @Override
    public LatLngBounds getBounds() {
        return this.bounds;
    }

    @Override
    public double getMinZoom() {
        return this.minZoom;
    }

    @Override
    public double getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public boolean getIncludeIdeographs() {
        return this.includeIdeographs;
    }

    @Override
    @NonNull
    public String getType() {
        return "tileregion";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.styleURL);
        dest.writeDouble(this.bounds.getLatNorth());
        dest.writeDouble(this.bounds.getLonEast());
        dest.writeDouble(this.bounds.getLatSouth());
        dest.writeDouble(this.bounds.getLonWest());
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeFloat(this.pixelRatio);
    }
}

