/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.location.Location;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.SparseArray;
import android.view.animation.LinearInterpolator;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.CameraCompassBearingAnimator;
import com.mapbox.mapboxsdk.location.CameraGpsBearingAnimator;
import com.mapbox.mapboxsdk.location.CameraLatLngAnimator;
import com.mapbox.mapboxsdk.location.LayerAccuracyAnimator;
import com.mapbox.mapboxsdk.location.LayerCompassBearingAnimator;
import com.mapbox.mapboxsdk.location.LayerGpsBearingAnimator;
import com.mapbox.mapboxsdk.location.LayerLatLngAnimator;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.TiltAnimator;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.location.ZoomAnimator;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.ArrayList;
import java.util.List;

final class LocationAnimatorCoordinator {
    final SparseArray<MapboxAnimator> animatorArray = new SparseArray();
    final List<MapboxAnimator.OnLayerAnimationsValuesChangeListener> layerListeners = new ArrayList<MapboxAnimator.OnLayerAnimationsValuesChangeListener>();
    final List<MapboxAnimator.OnCameraAnimationsValuesChangeListener> cameraListeners = new ArrayList<MapboxAnimator.OnCameraAnimationsValuesChangeListener>();
    private Location previousLocation;
    private float previousAccuracyRadius = -1.0f;
    private float previousCompassBearing = -1.0f;
    private long locationUpdateTimestamp = -1L;
    private float durationMultiplier;

    LocationAnimatorCoordinator() {
    }

    void addLayerListener(MapboxAnimator.OnLayerAnimationsValuesChangeListener listener) {
        this.layerListeners.add(listener);
    }

    void removeLayerListener(MapboxAnimator.OnLayerAnimationsValuesChangeListener listener) {
        this.layerListeners.remove(listener);
    }

    void addCameraListener(MapboxAnimator.OnCameraAnimationsValuesChangeListener listener) {
        this.cameraListeners.add(listener);
    }

    void removeCameraListener(MapboxAnimator.OnCameraAnimationsValuesChangeListener listener) {
        this.cameraListeners.remove(listener);
    }

    void feedNewLocation(@NonNull Location newLocation, @NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        if (this.previousLocation == null) {
            this.previousLocation = newLocation;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime() - 750L;
        }
        LatLng previousLayerLatLng = this.getPreviousLayerLatLng();
        float previousLayerBearing = this.getPreviousLayerGpsBearing();
        LatLng previousCameraLatLng = currentCameraPosition.target;
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        LatLng targetLatLng = new LatLng(newLocation);
        float targetLayerBearing = newLocation.getBearing();
        float targetCameraBearing = newLocation.getBearing();
        targetCameraBearing = this.checkGpsNorth(isGpsNorth, targetCameraBearing);
        this.updateLayerAnimators(previousLayerLatLng, targetLatLng, previousLayerBearing, targetLayerBearing);
        this.updateCameraAnimators(previousCameraLatLng, previousCameraBearing, targetLatLng, targetCameraBearing);
        boolean snap = this.immediateAnimation(previousCameraLatLng, targetLatLng, currentCameraPosition.zoom) || this.immediateAnimation(previousLayerLatLng, targetLatLng, currentCameraPosition.zoom);
        this.playLocationAnimators(snap ? 0L : this.getAnimationDuration());
        this.previousLocation = newLocation;
    }

    void feedNewCompassBearing(float targetCompassBearing, @NonNull CameraPosition currentCameraPosition) {
        if (this.previousCompassBearing < 0.0f) {
            this.previousCompassBearing = targetCompassBearing;
        }
        float previousLayerBearing = this.getPreviousLayerCompassBearing();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        this.updateCompassAnimators(targetCompassBearing, previousLayerBearing, previousCameraBearing);
        this.playCompassAnimators(500L);
        this.previousCompassBearing = targetCompassBearing;
    }

    void feedNewAccuracyRadius(float targetAccuracyRadius, boolean noAnimation) {
        if (this.previousAccuracyRadius < 0.0f) {
            this.previousAccuracyRadius = targetAccuracyRadius;
        }
        float previousAccuracyRadius = this.getPreviousAccuracyRadius();
        this.updateAccuracyAnimators(targetAccuracyRadius, previousAccuracyRadius);
        this.playAccuracyAnimator(noAnimation ? 0L : 250L);
        this.previousAccuracyRadius = targetAccuracyRadius;
    }

    void feedNewZoomLevel(double targetZoomLevel, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        this.updateZoomAnimator((float)targetZoomLevel, (float)currentCameraPosition.zoom, callback);
        this.playZoomAnimator(animationDuration);
    }

    void feedNewTilt(double targetTilt, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        this.updateTiltAnimator((float)targetTilt, (float)currentCameraPosition.tilt, callback);
        this.playTiltAnimator(animationDuration);
    }

    private LatLng getPreviousLayerLatLng() {
        MapboxAnimator latLngAnimator = (MapboxAnimator)((Object)this.animatorArray.get(0));
        LatLng previousLatLng = latLngAnimator != null ? (LatLng)latLngAnimator.getAnimatedValue() : new LatLng(this.previousLocation);
        return previousLatLng;
    }

    private float getPreviousLayerGpsBearing() {
        LayerGpsBearingAnimator animator = (LayerGpsBearingAnimator)((Object)this.animatorArray.get(2));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousLocation.getBearing();
        return previousBearing;
    }

    private float getPreviousLayerCompassBearing() {
        LayerCompassBearingAnimator animator = (LayerCompassBearingAnimator)((Object)this.animatorArray.get(3));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousCompassBearing;
        return previousBearing;
    }

    private float getPreviousAccuracyRadius() {
        LayerAccuracyAnimator animator = (LayerAccuracyAnimator)((Object)this.animatorArray.get(6));
        float previousRadius = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousAccuracyRadius;
        return previousRadius;
    }

    private void updateLayerAnimators(LatLng previousLatLng, LatLng targetLatLng, float previousBearing, float targetBearing) {
        this.createNewAnimator(0, new LayerLatLngAnimator(previousLatLng, targetLatLng, this.layerListeners));
        float normalizedLayerBearing = Utils.shortestRotation(targetBearing, previousBearing);
        this.createNewAnimator(2, new LayerGpsBearingAnimator(Float.valueOf(previousBearing), Float.valueOf(normalizedLayerBearing), this.layerListeners));
    }

    private void updateCameraAnimators(LatLng previousCameraLatLng, float previousCameraBearing, LatLng targetLatLng, float targetBearing) {
        this.createNewAnimator(1, new CameraLatLngAnimator(previousCameraLatLng, targetLatLng, this.cameraListeners));
        float normalizedCameraBearing = Utils.shortestRotation(targetBearing, previousCameraBearing);
        this.createNewAnimator(4, new CameraGpsBearingAnimator(Float.valueOf(previousCameraBearing), Float.valueOf(normalizedCameraBearing), this.cameraListeners));
    }

    private void updateCompassAnimators(float targetCompassBearing, float previousLayerBearing, float previousCameraBearing) {
        float normalizedLayerBearing = Utils.shortestRotation(targetCompassBearing, previousLayerBearing);
        this.createNewAnimator(3, new LayerCompassBearingAnimator(Float.valueOf(previousLayerBearing), Float.valueOf(normalizedLayerBearing), this.layerListeners));
        float normalizedCameraBearing = Utils.shortestRotation(targetCompassBearing, previousCameraBearing);
        this.createNewAnimator(5, new CameraCompassBearingAnimator(Float.valueOf(previousCameraBearing), Float.valueOf(normalizedCameraBearing), this.cameraListeners));
    }

    private void updateAccuracyAnimators(float targetAccuracyRadius, float previousAccuracyRadius) {
        this.createNewAnimator(6, new LayerAccuracyAnimator(Float.valueOf(previousAccuracyRadius), Float.valueOf(targetAccuracyRadius), this.layerListeners));
    }

    private void updateZoomAnimator(float targetZoomLevel, float previousZoomLevel, @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewAnimator(7, new ZoomAnimator(Float.valueOf(previousZoomLevel), Float.valueOf(targetZoomLevel), this.cameraListeners, cancelableCallback));
    }

    private void updateTiltAnimator(float targetTilt, float previousTiltLevel, @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewAnimator(8, new TiltAnimator(Float.valueOf(previousTiltLevel), Float.valueOf(targetTilt), this.cameraListeners, cancelableCallback));
    }

    private long getAnimationDuration() {
        long previousUpdateTimeStamp = this.locationUpdateTimestamp;
        this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
        long animationDuration = previousUpdateTimeStamp == 0L ? 0L : (long)((float)(this.locationUpdateTimestamp - previousUpdateTimeStamp) * this.durationMultiplier);
        animationDuration = Math.min(animationDuration, 2000L);
        return animationDuration;
    }

    private float checkGpsNorth(boolean isGpsNorth, float targetCameraBearing) {
        if (isGpsNorth) {
            targetCameraBearing = 0.0f;
        }
        return targetCameraBearing;
    }

    private void playLocationAnimators(long duration) {
        ArrayList<Object> locationAnimators = new ArrayList<Object>();
        locationAnimators.add(this.animatorArray.get(0));
        locationAnimators.add(this.animatorArray.get(2));
        locationAnimators.add(this.animatorArray.get(1));
        locationAnimators.add(this.animatorArray.get(4));
        AnimatorSet locationAnimatorSet = new AnimatorSet();
        locationAnimatorSet.playTogether(locationAnimators);
        locationAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        locationAnimatorSet.setDuration(duration);
        locationAnimatorSet.start();
    }

    private void playCompassAnimators(long duration) {
        ArrayList<Object> compassAnimators = new ArrayList<Object>();
        compassAnimators.add(this.animatorArray.get(3));
        compassAnimators.add(this.animatorArray.get(5));
        AnimatorSet compassAnimatorSet = new AnimatorSet();
        compassAnimatorSet.playTogether(compassAnimators);
        compassAnimatorSet.setDuration(duration);
        compassAnimatorSet.start();
    }

    private void playAccuracyAnimator(long duration) {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(6));
        animator.setDuration(duration);
        animator.start();
    }

    private void playZoomAnimator(long duration) {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(7));
        animator.setDuration(duration);
        animator.start();
    }

    private void playTiltAnimator(long duration) {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(8));
        animator.setDuration(duration);
        animator.start();
    }

    private void playCameraLocationAnimators(long duration) {
        ArrayList<Object> locationAnimators = new ArrayList<Object>();
        locationAnimators.add(this.animatorArray.get(1));
        locationAnimators.add(this.animatorArray.get(4));
        AnimatorSet locationAnimatorSet = new AnimatorSet();
        locationAnimatorSet.playTogether(locationAnimators);
        locationAnimatorSet.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        locationAnimatorSet.setDuration(duration);
        locationAnimatorSet.start();
    }

    void resetAllCameraAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraCompassAnimation(currentCameraPosition);
        boolean snap = this.resetCameraLocationAnimations(currentCameraPosition, isGpsNorth);
        this.playCameraLocationAnimators(snap ? 0L : 750L);
    }

    private boolean resetCameraLocationAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraGpsBearingAnimation(currentCameraPosition, isGpsNorth);
        return this.resetCameraLatLngAnimation(currentCameraPosition);
    }

    private boolean resetCameraLatLngAnimation(@NonNull CameraPosition currentCameraPosition) {
        CameraLatLngAnimator animator = (CameraLatLngAnimator)((Object)this.animatorArray.get(1));
        if (animator == null) {
            return false;
        }
        LatLng currentTarget = (LatLng)animator.getTarget();
        LatLng previousCameraTarget = currentCameraPosition.target;
        this.createNewAnimator(1, new CameraLatLngAnimator(previousCameraTarget, currentTarget, this.cameraListeners));
        return this.immediateAnimation(previousCameraTarget, currentTarget, currentCameraPosition.zoom);
    }

    private void resetCameraGpsBearingAnimation(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        CameraGpsBearingAnimator animator = (CameraGpsBearingAnimator)((Object)this.animatorArray.get(4));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        currentTargetBearing = this.checkGpsNorth(isGpsNorth, currentTargetBearing);
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewAnimator(4, new CameraGpsBearingAnimator(Float.valueOf(previousCameraBearing), Float.valueOf(normalizedCameraBearing), this.cameraListeners));
    }

    private void resetCameraCompassAnimation(@NonNull CameraPosition currentCameraPosition) {
        CameraCompassBearingAnimator animator = (CameraCompassBearingAnimator)((Object)this.animatorArray.get(5));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewAnimator(5, new CameraCompassBearingAnimator(Float.valueOf(previousCameraBearing), Float.valueOf(normalizedCameraBearing), this.cameraListeners));
    }

    private void createNewAnimator(int animatorType, MapboxAnimator animator) {
        this.cancelAnimator(animatorType);
        this.animatorArray.put(animatorType, (Object)animator);
    }

    void cancelZoomAnimation() {
        this.cancelAnimator(7);
    }

    void cancelTiltAnimation() {
        this.cancelAnimator(8);
    }

    void cancelAllAnimations() {
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            int animatorType = this.animatorArray.keyAt(i);
            this.cancelAnimator(animatorType);
        }
    }

    private void cancelAnimator(int animatorType) {
        MapboxAnimator animator = (MapboxAnimator)((Object)this.animatorArray.get(animatorType));
        if (animator != null) {
            animator.cancel();
            animator.removeAllUpdateListeners();
            animator.removeAllListeners();
            this.animatorArray.put(animatorType, null);
        }
    }

    void setTrackingAnimationDurationMultiplier(float trackingAnimationDurationMultiplier) {
        this.durationMultiplier = trackingAnimationDurationMultiplier;
    }

    private boolean immediateAnimation(LatLng current, @NonNull LatLng target, double zoom) {
        double distance = current.distanceTo(target);
        if (zoom > 10.0) {
            distance *= zoom;
        }
        return distance > 500000.0;
    }
}

