/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.content.Context;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapEventFactory;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.offline.OfflineGeometryRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineTilePyramidRegionDefinition;
import java.lang.reflect.Field;

public class TelemetryImpl
implements TelemetryDefinition {
    private static final String TAG = "Mbgl-TelemetryImpl";
    private static TelemetryImpl instance;
    private MapboxTelemetry telemetry;

    @Deprecated
    public static synchronized TelemetryImpl getInstance() {
        if (instance == null) {
            instance = new TelemetryImpl();
        }
        return instance;
    }

    private TelemetryImpl() {
        Context appContext = Mapbox.getApplicationContext();
        String accessToken = Mapbox.getAccessToken();
        this.telemetry = new MapboxTelemetry(appContext, accessToken, "mapbox-maps-android/6.8.2");
        TelemetryEnabler.State telemetryState = TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.telemetry.enable();
        }
    }

    @Override
    public void onAppUserTurnstileEvent() {
        AppUserTurnstile turnstileEvent = new AppUserTurnstile("mapbox-maps-android", "6.8.2");
        this.telemetry.push((Event)turnstileEvent);
        MapEventFactory mapEventFactory = new MapEventFactory();
        this.telemetry.push(mapEventFactory.createMapLoadEvent(Event.Type.MAP_LOAD));
    }

    @Override
    public void onGestureInteraction(String eventType, double latitude, double longitude, double zoom) {
        MapEventFactory mapEventFactory = new MapEventFactory();
        MapState state = new MapState(latitude, longitude, zoom);
        state.setGesture(eventType);
        this.telemetry.push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, state));
    }

    @Override
    public void setUserTelemetryRequestState(boolean enabledTelemetry) {
        if (enabledTelemetry) {
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.ENABLED);
            this.telemetry.enable();
        } else {
            this.telemetry.disable();
            TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.DISABLED);
        }
    }

    @Override
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.telemetry.updateDebugLoggingEnabled(debugLoggingEnabled);
    }

    @Override
    public boolean setSessionIdRotationInterval(int interval) {
        return this.telemetry.updateSessionIdRotationInterval(new SessionInterval(interval));
    }

    @Override
    public void onCreateOfflineRegion(@NonNull OfflineRegionDefinition offlineDefinition) {
        MapEventFactory mapEventFactory = new MapEventFactory();
        if (offlineDefinition instanceof OfflineTilePyramidRegionDefinition) {
            OfflineTilePyramidRegionDefinition tileDefinition = (OfflineTilePyramidRegionDefinition)offlineDefinition;
            this.telemetry.push(mapEventFactory.createOfflineDownloadStartEvent("tileregion", Double.valueOf(tileDefinition.getMinZoom()), Double.valueOf(tileDefinition.getMaxZoom()), tileDefinition.getStyleURL()));
        } else {
            OfflineGeometryRegionDefinition geometryDefinition = (OfflineGeometryRegionDefinition)offlineDefinition;
            this.telemetry.push(mapEventFactory.createOfflineDownloadStartEvent("shaperegion", Double.valueOf(geometryDefinition.getMinZoom()), Double.valueOf(geometryDefinition.getMaxZoom()), geometryDefinition.getStyleURL()));
        }
    }

    @Deprecated
    public static void updateDebugLoggingEnabled(boolean debugLoggingEnabled) {
        TelemetryDefinition definition = Mapbox.getTelemetry();
        if (definition != null) {
            definition.setDebugLoggingEnabled(debugLoggingEnabled);
        }
    }

    @Deprecated
    public static boolean updateSessionIdRotationInterval(SessionInterval interval) {
        try {
            Field field = interval.getClass().getDeclaredField("interval");
            field.setAccessible(true);
            Integer intervalValue = (Integer)field.get(interval);
            TelemetryDefinition definition = Mapbox.getTelemetry();
            if (definition != null) {
                return definition.setSessionIdRotationInterval(intervalValue);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Exception occurred when updating session id rotation interval", exception);
            MapStrictMode.strictModeViolation(exception);
        }
        return false;
    }

    @Deprecated
    public static void enableOnUserRequest() {
        TelemetryDefinition definition = Mapbox.getTelemetry();
        if (definition != null) {
            definition.setUserTelemetryRequestState(true);
        }
    }

    @Deprecated
    public static void disableOnUserRequest() {
        TelemetryDefinition definition = Mapbox.getTelemetry();
        if (definition != null) {
            definition.setUserTelemetryRequestState(false);
        }
    }
}

