/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.storage;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.utils.ThreadUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileSource {
    private static final String TAG = "Mbgl-FileSource";
    private static final Lock resourcesCachePathLoaderLock = new ReentrantLock();
    private static final Lock internalCachePathLoaderLock = new ReentrantLock();
    @Nullable
    private static String resourcesCachePath;
    private static String internalCachePath;
    private static FileSource INSTANCE;
    @Keep
    private long nativePtr;

    @UiThread
    public static synchronized FileSource getInstance(@NonNull Context context) {
        if (INSTANCE == null) {
            INSTANCE = new FileSource(FileSource.getResourcesCachePath(context), context.getResources().getAssets());
        }
        return INSTANCE;
    }

    @Deprecated
    @Nullable
    public static String getCachePath(@NonNull Context context) {
        boolean isExternalStorageConfiguration = false;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                isExternalStorageConfiguration = appInfo.metaData.getBoolean("com.mapbox.SetStorageExternal", false);
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Logger.e(TAG, "Failed to read the package metadata: ", exception);
            MapStrictMode.strictModeViolation((Exception)((Object)exception));
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the storage key: ", exception);
            MapStrictMode.strictModeViolation(exception);
        }
        String cachePath = null;
        if (isExternalStorageConfiguration && FileSource.isExternalStorageReadable()) {
            try {
                cachePath = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException exception) {
                Logger.e(TAG, "Failed to obtain the external storage path: ", exception);
                MapStrictMode.strictModeViolation(exception);
            }
        }
        if (cachePath == null) {
            cachePath = context.getFilesDir().getAbsolutePath();
        }
        return cachePath;
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            return true;
        }
        Logger.w(TAG, "External storage was requested but it isn't readable. For API level < 18 make sure you've requested READ_EXTERNAL_STORAGE or WRITE_EXTERNAL_STORAGE permissions in your app Manifest (defaulting to internal storage).");
        return false;
    }

    @UiThread
    public static void initializeFileDirsPaths(Context context) {
        ThreadUtils.checkThread("FileSource");
        FileSource.lockPathLoaders();
        if (resourcesCachePath == null || internalCachePath == null) {
            new FileDirsPathsTask().execute(new Context[]{context});
        }
    }

    @Nullable
    public static String getResourcesCachePath(@NonNull Context context) {
        resourcesCachePathLoaderLock.lock();
        try {
            if (resourcesCachePath == null) {
                resourcesCachePath = FileSource.getCachePath(context);
            }
            String string2 = resourcesCachePath;
            return string2;
        }
        finally {
            resourcesCachePathLoaderLock.unlock();
        }
    }

    public static String getInternalCachePath(@NonNull Context context) {
        internalCachePathLoaderLock.lock();
        try {
            if (internalCachePath == null) {
                internalCachePath = context.getCacheDir().getAbsolutePath();
            }
            String string2 = internalCachePath;
            return string2;
        }
        finally {
            internalCachePathLoaderLock.unlock();
        }
    }

    private static void lockPathLoaders() {
        internalCachePathLoaderLock.lock();
        resourcesCachePathLoaderLock.lock();
    }

    private static void unlockPathLoaders() {
        resourcesCachePathLoaderLock.unlock();
        internalCachePathLoaderLock.unlock();
    }

    private FileSource(String cachePath, AssetManager assetManager) {
        this.initialize(Mapbox.getAccessToken(), cachePath, assetManager);
    }

    @Keep
    public native boolean isActivated();

    @Keep
    public native void activate();

    @Keep
    public native void deactivate();

    @Keep
    public native void setAccessToken(@NonNull String var1);

    @NonNull
    @Keep
    public native String getAccessToken();

    @Keep
    public native void setApiBaseUrl(String var1);

    @Keep
    public native void setResourceTransform(ResourceTransformCallback var1);

    @Keep
    private native void initialize(String var1, String var2, AssetManager var3);

    @Keep
    protected native void finalize() throws Throwable;

    private static class FileDirsPathsTask
    extends AsyncTask<Context, Void, String[]> {
        private FileDirsPathsTask() {
        }

        protected void onCancelled() {
            FileSource.unlockPathLoaders();
        }

        @NonNull
        protected String[] doInBackground(Context ... contexts) {
            return new String[]{FileSource.getCachePath(contexts[0]), contexts[0].getCacheDir().getAbsolutePath()};
        }

        protected void onPostExecute(String[] paths) {
            resourcesCachePath = paths[0];
            internalCachePath = paths[1];
            FileSource.unlockPathLoaders();
        }
    }

    @Keep
    public static interface ResourceTransformCallback {
        public String onURL(int var1, String var2);
    }
}

