/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Markers;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import java.util.ArrayList;
import java.util.List;

class MarkerContainer
implements Markers {
    private final NativeMapView nativeMapView;
    private final MapView mapView;
    private final LongSparseArray<Annotation> annotations;
    private final IconManager iconManager;
    private final MarkerViewManager markerViewManager;

    MarkerContainer(NativeMapView nativeMapView, MapView mapView, LongSparseArray<Annotation> annotations, IconManager iconManager, MarkerViewManager markerViewManager) {
        this.nativeMapView = nativeMapView;
        this.mapView = mapView;
        this.annotations = annotations;
        this.iconManager = iconManager;
        this.markerViewManager = markerViewManager;
    }

    @Override
    public Marker addBy(@NonNull BaseMarkerOptions markerOptions, @NonNull MapboxMap mapboxMap) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.nativeMapView != null ? this.nativeMapView.addMarker(marker) : 0L;
        marker.setMapboxMap(mapboxMap);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        return marker;
    }

    @Override
    @NonNull
    public List<Marker> addBy(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapboxMap mapboxMap) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        if (this.nativeMapView != null && count > 0) {
            for (int i = 0; i < count; ++i) {
                BaseMarkerOptions markerOptions = markerOptionsList.get(i);
                Marker marker = this.prepareMarker(markerOptions);
                markers.add(marker);
            }
            if (markers.size() > 0) {
                long[] ids = this.nativeMapView.addMarkers(markers);
                for (int i = 0; i < ids.length; ++i) {
                    Marker createdMarker = (Marker)markers.get(i);
                    createdMarker.setMapboxMap(mapboxMap);
                    createdMarker.setId(ids[i]);
                    this.annotations.put(ids[i], (Object)createdMarker);
                }
            }
        }
        return markers;
    }

    @Override
    public void update(@NonNull Marker updatedMarker, @NonNull MapboxMap mapboxMap) {
        this.ensureIconLoaded(updatedMarker, mapboxMap);
        this.nativeMapView.updateMarker(updatedMarker);
        this.annotations.setValueAt(this.annotations.indexOfKey(updatedMarker.getId()), (Object)updatedMarker);
    }

    @Override
    @NonNull
    public List<Marker> obtainAll() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    @Override
    @NonNull
    public List<Marker> obtainAllIn(@NonNull RectF rectangle) {
        RectF rect = this.nativeMapView.getDensityDependantRectangle(rectangle);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.obtainAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    @Override
    public MarkerView addViewBy(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapboxMap mapboxMap, @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        MarkerView marker = this.prepareViewMarker(markerOptions);
        marker.setMapboxMap(mapboxMap);
        long id2 = this.nativeMapView.addMarker(marker);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        if (onMarkerViewAddedListener != null) {
            this.markerViewManager.addOnMarkerViewAddedListener(marker, onMarkerViewAddedListener);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.setWaitingForRenderInvoke(true);
        return marker;
    }

    @Override
    @NonNull
    public List<MarkerView> addViewsBy(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions, @NonNull MapboxMap mapboxMap) {
        ArrayList<MarkerView> markers = new ArrayList<MarkerView>();
        for (BaseMarkerViewOptions baseMarkerViewOptions : markerViewOptions) {
            if (markerViewOptions.indexOf(baseMarkerViewOptions) == markerViewOptions.size() - 1) {
                this.markerViewManager.setWaitingForRenderInvoke(true);
            }
            MarkerView marker = this.prepareViewMarker(baseMarkerViewOptions);
            marker.setMapboxMap(mapboxMap);
            long id2 = this.nativeMapView.addMarker(marker);
            marker.setId(id2);
            this.annotations.put(id2, (Object)marker);
            markers.add(marker);
        }
        this.markerViewManager.setEnabled(true);
        this.markerViewManager.update();
        return markers;
    }

    @Override
    @NonNull
    public List<MarkerView> obtainViewsIn(@NonNull RectF rectangle) {
        float pixelRatio = this.nativeMapView.getPixelRatio();
        RectF rect = new RectF(rectangle.left / pixelRatio, rectangle.top / pixelRatio, rectangle.right / pixelRatio, rectangle.bottom / pixelRatio);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<MarkerView> annotations = new ArrayList<MarkerView>(ids.length);
        List<Annotation> annotationList = this.obtainAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof MarkerView) || !idsList.contains(annotation.getId())) continue;
            annotations.add((MarkerView)annotation);
        }
        return new ArrayList<MarkerView>(annotations);
    }

    @Override
    public void reload() {
        this.iconManager.reloadIcons();
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            long newId = this.nativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.iconManager.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    private void ensureIconLoaded(Marker marker, @NonNull MapboxMap mapboxMap) {
        if (!(marker instanceof MarkerView)) {
            this.iconManager.ensureIconLoaded(marker, mapboxMap);
        }
    }

    @NonNull
    private List<Annotation> obtainAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    private MarkerView prepareViewMarker(BaseMarkerViewOptions markerViewOptions) {
        Object marker = markerViewOptions.getMarker();
        Icon icon = markerViewOptions.getIcon();
        if (icon == null) {
            icon = IconFactory.getInstance(this.mapView.getContext()).defaultMarkerView();
        }
        this.iconManager.loadIconForMarkerView((MarkerView)marker);
        ((MarkerView)marker).setIcon(icon);
        return marker;
    }
}

