/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.support.annotation.NonNull;
import com.mapbox.geojson.Feature;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;

class LayerSourceProvider {
    private static final String EMPTY_STRING = "";

    LayerSourceProvider() {
    }

    @NonNull
    GeoJsonSource generateSource(Feature locationFeature) {
        return new GeoJsonSource("mapbox-location-source", locationFeature, new GeoJsonOptions().withMaxZoom(16));
    }

    @NonNull
    Layer generateLayer(@NonNull String layerId) {
        SymbolLayer layer = new SymbolLayer(layerId, "mapbox-location-source");
        layer.setProperties(PropertyFactory.iconAllowOverlap(true), PropertyFactory.iconIgnorePlacement(true), PropertyFactory.iconRotationAlignment("map"), PropertyFactory.iconRotate(Expression.match(Expression.literal(layerId), Expression.literal(Float.valueOf(0.0f)), Expression.stop("mapbox-location-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-stroke-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-shadow", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-compass-bearing")))), PropertyFactory.iconImage(Expression.match(Expression.literal(layerId), Expression.literal(EMPTY_STRING), Expression.stop("mapbox-location-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-foreground-stale-icon"), Expression.get("mapbox-property-foreground-icon"))), Expression.stop("mapbox-location-stroke-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-background-stale-icon"), Expression.get("mapbox-property-background-icon"))), Expression.stop("mapbox-location-shadow", Expression.literal("mapbox-location-shadow-icon")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-shadow-icon")))), PropertyFactory.iconOffset(Expression.match(Expression.literal(layerId), Expression.literal(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}), Expression.stop(Expression.literal("mapbox-location-layer"), Expression.get("mapbox-property-foreground-icon-offset")), Expression.stop(Expression.literal("mapbox-location-shadow"), Expression.get("mapbox-property-shadow-icon-offset")))));
        return layer;
    }

    @NonNull
    Layer generateAccuracyLayer() {
        return new CircleLayer("mapbox-location-accuracy-layer", "mapbox-location-source").withProperties(PropertyFactory.circleRadius(Expression.get("mapbox-property-accuracy-radius")), PropertyFactory.circleColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circleOpacity(Expression.get("mapbox-property-accuracy-alpha")), PropertyFactory.circleStrokeColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circlePitchAlignment("map"));
    }
}

