/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.ArrayList;
import java.util.List;

public final class PolygonOptions
implements Parcelable {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new Parcelable.Creator<PolygonOptions>(){

        public PolygonOptions createFromParcel(@NonNull Parcel in) {
            return new PolygonOptions(in);
        }

        public PolygonOptions[] newArray(int size) {
            return new PolygonOptions[size];
        }
    };
    private Polygon polygon = new Polygon();

    private PolygonOptions(Parcel in) {
        ArrayList<LatLng> pointsList = new ArrayList<LatLng>();
        in.readList(pointsList, LatLng.class.getClassLoader());
        this.addAll(pointsList);
        ArrayList<List<LatLng>> holes = new ArrayList<List<LatLng>>();
        in.readList(holes, LatLng.class.getClassLoader());
        this.addAllHoles(holes);
        this.alpha(in.readFloat());
        this.fillColor(in.readInt());
        this.strokeColor(in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeList(this.getPoints());
        out.writeList(this.getHoles());
        out.writeFloat(this.getAlpha());
        out.writeInt(this.getFillColor());
        out.writeInt(this.getStrokeColor());
    }

    public PolygonOptions() {
    }

    @NonNull
    public PolygonOptions add(LatLng point) {
        this.polygon.addPoint(point);
        return this;
    }

    @NonNull
    public PolygonOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addHole(List<LatLng> hole) {
        this.polygon.addHole(hole);
        return this;
    }

    @NonNull
    public PolygonOptions addHole(List<LatLng> ... holes) {
        for (List<LatLng> hole : holes) {
            this.addHole(hole);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addAllHoles(Iterable<List<LatLng>> holes) {
        for (List<LatLng> hole : holes) {
            this.addHole(hole);
        }
        return this;
    }

    @NonNull
    public PolygonOptions alpha(float alpha) {
        this.polygon.setAlpha(alpha);
        return this;
    }

    public float getAlpha() {
        return this.polygon.getAlpha();
    }

    @NonNull
    public PolygonOptions fillColor(int color) {
        this.polygon.setFillColor(color);
        return this;
    }

    public int getFillColor() {
        return this.polygon.getFillColor();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    @NonNull
    public PolygonOptions strokeColor(int color) {
        this.polygon.setStrokeColor(color);
        return this;
    }

    public int getStrokeColor() {
        return this.polygon.getStrokeColor();
    }

    public List<LatLng> getPoints() {
        return this.polygon.getPoints();
    }

    public List<List<LatLng>> getHoles() {
        return this.polygon.getHoles();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolygonOptions polygon = (PolygonOptions)o;
        if (Float.compare(polygon.getAlpha(), this.getAlpha()) != 0) {
            return false;
        }
        if (this.getFillColor() != polygon.getFillColor()) {
            return false;
        }
        if (this.getStrokeColor() != polygon.getStrokeColor()) {
            return false;
        }
        if (this.getPoints() != null ? !this.getPoints().equals(polygon.getPoints()) : polygon.getPoints() != null) {
            return false;
        }
        return !(this.getHoles() == null ? polygon.getHoles() != null : !this.getHoles().equals(polygon.getHoles()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAlpha() != 0.0f ? Float.floatToIntBits(this.getAlpha()) : 0);
        result = 31 * result + this.getFillColor();
        result = 31 * result + this.getStrokeColor();
        result = 31 * result + (this.getPoints() != null ? this.getPoints().hashCode() : 0);
        result = 31 * result + (this.getHoles() != null ? this.getHoles().hashCode() : 0);
        return result;
    }
}

