/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.BubbleLayout;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;

public class InfoWindow {
    private WeakReference<Marker> boundMarker;
    private WeakReference<MapboxMap> mapboxMap;
    protected WeakReference<View> view;
    private float markerHeightOffset;
    private float markerWidthOffset;
    private float viewWidthOffset;
    private float viewHeightOffset;
    private PointF coordinates;
    private boolean isVisible;
    @LayoutRes
    private int layoutRes;
    @Nullable
    private final ViewTreeObserver.OnGlobalLayoutListener contentUpdateListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = (View)InfoWindow.this.view.get();
            if (view != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                InfoWindow.this.viewHeightOffset = (float)(-view.getMeasuredHeight()) + InfoWindow.this.markerHeightOffset;
                InfoWindow.this.update();
            }
        }
    };

    InfoWindow(MapView mapView, int layoutResId, MapboxMap mapboxMap) {
        this.layoutRes = layoutResId;
        View view = LayoutInflater.from((Context)mapView.getContext()).inflate(layoutResId, (ViewGroup)mapView, false);
        this.initialize(view, mapboxMap);
    }

    InfoWindow(@NonNull View view, MapboxMap mapboxMap) {
        this.initialize(view, mapboxMap);
    }

    private void initialize(@NonNull View view, MapboxMap mapboxMap) {
        this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        this.isVisible = false;
        this.view = new WeakReference<View>(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapboxMap mapboxMap = (MapboxMap)InfoWindow.this.mapboxMap.get();
                if (mapboxMap != null) {
                    MapboxMap.OnInfoWindowClickListener onInfoWindowClickListener = mapboxMap.getOnInfoWindowClickListener();
                    boolean handledDefaultClick = false;
                    if (onInfoWindowClickListener != null) {
                        handledDefaultClick = onInfoWindowClickListener.onInfoWindowClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!handledDefaultClick) {
                        InfoWindow.this.closeInfoWindow();
                    }
                }
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                MapboxMap.OnInfoWindowLongClickListener listener;
                MapboxMap mapboxMap = (MapboxMap)InfoWindow.this.mapboxMap.get();
                if (mapboxMap != null && (listener = mapboxMap.getOnInfoWindowLongClickListener()) != null) {
                    listener.onInfoWindowLongClick(InfoWindow.this.getBoundMarker());
                }
                return true;
            }
        });
    }

    private void closeInfoWindow() {
        MapboxMap mapbox = (MapboxMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        if (marker != null && mapbox != null) {
            mapbox.deselectMarker(marker);
        }
        this.close();
    }

    @NonNull
    InfoWindow open(@NonNull MapView mapView, Marker boundMarker, @NonNull LatLng position, int offsetX, int offsetY) {
        this.setBoundMarker(boundMarker);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        View view = (View)this.view.get();
        if (view != null && mapboxMap != null) {
            view.measure(0, 0);
            this.markerHeightOffset = offsetY;
            this.markerWidthOffset = -offsetX;
            this.coordinates = mapboxMap.getProjection().toScreenLocation(position);
            float x = this.coordinates.x - (float)(view.getMeasuredWidth() / 2) + (float)offsetX;
            float y = this.coordinates.y - (float)view.getMeasuredHeight() + (float)offsetY;
            if (view instanceof BubbleLayout) {
                Resources resources = mapView.getContext().getResources();
                float rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                float leftSideInfoWindow = x;
                float mapRight = mapView.getRight();
                float mapLeft = mapView.getLeft();
                float marginHorizontal = resources.getDimension(R.dimen.mapbox_infowindow_margin);
                float tipViewOffset = resources.getDimension(R.dimen.mapbox_infowindow_tipview_width) / 2.0f;
                float tipViewMarginLeft = (float)(view.getMeasuredWidth() / 2) - tipViewOffset;
                boolean outOfBoundsLeft = false;
                boolean outOfBoundsRight = false;
                if (this.coordinates.x >= 0.0f && this.coordinates.x <= (float)mapView.getWidth() && this.coordinates.y >= 0.0f && this.coordinates.y <= (float)mapView.getHeight()) {
                    if (rightSideInfowWindow > mapRight) {
                        outOfBoundsRight = true;
                        x -= rightSideInfowWindow - mapRight;
                        tipViewMarginLeft += rightSideInfowWindow - mapRight + tipViewOffset;
                        rightSideInfowWindow = x + (float)view.getMeasuredWidth();
                    }
                    if (leftSideInfoWindow < mapLeft) {
                        outOfBoundsLeft = true;
                        x += mapLeft - leftSideInfoWindow;
                        tipViewMarginLeft -= mapLeft - leftSideInfoWindow + tipViewOffset;
                        leftSideInfoWindow = x;
                    }
                    if (outOfBoundsRight && mapRight - rightSideInfowWindow < marginHorizontal) {
                        tipViewMarginLeft += marginHorizontal - (mapRight - rightSideInfowWindow) - tipViewOffset;
                        leftSideInfoWindow = x -= marginHorizontal - (mapRight - rightSideInfowWindow);
                    }
                    if (outOfBoundsLeft && leftSideInfoWindow - mapLeft < marginHorizontal) {
                        x += marginHorizontal - (leftSideInfoWindow - mapLeft);
                        tipViewMarginLeft -= marginHorizontal - (leftSideInfoWindow - mapLeft) - tipViewOffset;
                    }
                }
                ((BubbleLayout)view).setArrowPosition(tipViewMarginLeft);
            }
            view.setX(x);
            view.setY(y);
            this.viewWidthOffset = x - this.coordinates.x - (float)offsetX;
            this.viewHeightOffset = -view.getMeasuredHeight() + offsetY;
            this.close();
            mapView.addView(view, (ViewGroup.LayoutParams)lp);
            this.isVisible = true;
        }
        return this;
    }

    @NonNull
    InfoWindow close() {
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        if (this.isVisible && mapboxMap != null) {
            this.isVisible = false;
            View view = (View)this.view.get();
            if (view != null && view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            Marker marker = this.getBoundMarker();
            MapboxMap.OnInfoWindowCloseListener listener = mapboxMap.getOnInfoWindowCloseListener();
            if (listener != null) {
                listener.onInfoWindowClose(marker);
            }
            this.setBoundMarker(null);
        }
        return this;
    }

    void adaptDefaultMarker(@NonNull Marker overlayItem, MapboxMap mapboxMap, @NonNull MapView mapView) {
        View view = (View)this.view.get();
        if (view == null) {
            view = LayoutInflater.from((Context)mapView.getContext()).inflate(this.layoutRes, (ViewGroup)mapView, false);
            this.initialize(view, mapboxMap);
        }
        this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        String title = overlayItem.getTitle();
        TextView titleTextView = (TextView)view.findViewById(R.id.infowindow_title);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            titleTextView.setText((CharSequence)title);
            titleTextView.setVisibility(0);
        } else {
            titleTextView.setVisibility(8);
        }
        String snippet = overlayItem.getSnippet();
        TextView snippetTextView = (TextView)view.findViewById(R.id.infowindow_description);
        if (!TextUtils.isEmpty((CharSequence)snippet)) {
            snippetTextView.setText((CharSequence)snippet);
            snippetTextView.setVisibility(0);
        } else {
            snippetTextView.setVisibility(8);
        }
    }

    @NonNull
    InfoWindow setBoundMarker(Marker boundMarker) {
        this.boundMarker = new WeakReference<Marker>(boundMarker);
        return this;
    }

    @Nullable
    Marker getBoundMarker() {
        if (this.boundMarker == null) {
            return null;
        }
        return (Marker)this.boundMarker.get();
    }

    public void update() {
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        View view = (View)this.view.get();
        if (mapboxMap != null && marker != null && view != null) {
            this.coordinates = mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            if (view instanceof BubbleLayout) {
                view.setX(this.coordinates.x + this.viewWidthOffset - this.markerWidthOffset);
            } else {
                view.setX(this.coordinates.x - (float)(view.getMeasuredWidth() / 2) - this.markerWidthOffset);
            }
            view.setY(this.coordinates.y + this.viewHeightOffset);
        }
    }

    void onContentUpdate() {
        ViewTreeObserver viewTreeObserver;
        View view = (View)this.view.get();
        if (view != null && (viewTreeObserver = view.getViewTreeObserver()).isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(this.contentUpdateListener);
        }
    }

    @Nullable
    public View getView() {
        return this.view != null ? (View)this.view.get() : null;
    }

    boolean isVisible() {
        return this.isVisible;
    }
}

