/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;

class CameraChangeDispatcher
implements MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnCameraMoveCanceledListener,
MapboxMap.OnCameraIdleListener {
    private final CameraChangeHandler handler = new CameraChangeHandler(this);
    private boolean idle = true;
    private int moveStartedReason;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveStartedListener> onCameraMoveStarted = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveCanceledListener> onCameraMoveCanceled = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveListener> onCameraMove = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraIdleListener> onCameraIdle = new CopyOnWriteArrayList();
    private MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener;
    private MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private MapboxMap.OnCameraIdleListener onCameraIdleListener;
    private static final int MOVE_STARTED = 0;
    private static final int MOVE = 1;
    private static final int MOVE_CANCELED = 2;
    private static final int IDLE = 3;

    CameraChangeDispatcher() {
    }

    @Override
    public void onCameraMoveStarted(int reason) {
        this.moveStartedReason = reason;
        this.handler.scheduleMessage(0);
    }

    @Override
    public void onCameraMove() {
        this.handler.scheduleMessage(1);
    }

    @Override
    public void onCameraMoveCanceled() {
        this.handler.scheduleMessage(2);
    }

    @Override
    public void onCameraIdle() {
        this.handler.scheduleMessage(3);
    }

    @Deprecated
    void setOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.onCameraMoveStartedListener = onCameraMoveStartedListener;
    }

    @Deprecated
    void setOnCameraMoveCanceledListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.onCameraMoveCanceledListener = onCameraMoveCanceledListener;
    }

    @Deprecated
    void setOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        this.onCameraMoveListener = onCameraMoveListener;
    }

    @Deprecated
    void setOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        this.onCameraIdleListener = onCameraIdleListener;
    }

    void addOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        this.onCameraIdle.add(listener);
    }

    void removeOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        if (this.onCameraIdle.contains(listener)) {
            this.onCameraIdle.remove(listener);
        }
    }

    void addOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        this.onCameraMoveCanceled.add(listener);
    }

    void removeOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        if (this.onCameraMoveCanceled.contains(listener)) {
            this.onCameraMoveCanceled.remove(listener);
        }
    }

    void addOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        this.onCameraMoveStarted.add(listener);
    }

    void removeOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        if (this.onCameraMoveStarted.contains(listener)) {
            this.onCameraMoveStarted.remove(listener);
        }
    }

    void addOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        this.onCameraMove.add(listener);
    }

    void removeOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        if (this.onCameraMove.contains(listener)) {
            this.onCameraMove.remove(listener);
        }
    }

    private void executeOnCameraMoveStarted() {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        if (this.onCameraMoveStartedListener != null) {
            this.onCameraMoveStartedListener.onCameraMoveStarted(this.moveStartedReason);
        }
        if (!this.onCameraMoveStarted.isEmpty()) {
            for (MapboxMap.OnCameraMoveStartedListener cameraMoveStartedListener : this.onCameraMoveStarted) {
                cameraMoveStartedListener.onCameraMoveStarted(this.moveStartedReason);
            }
        }
    }

    private void executeOnCameraMove() {
        if (this.onCameraMoveListener != null && !this.idle) {
            this.onCameraMoveListener.onCameraMove();
        }
        if (!this.onCameraMove.isEmpty() && !this.idle) {
            for (MapboxMap.OnCameraMoveListener cameraMoveListener : this.onCameraMove) {
                cameraMoveListener.onCameraMove();
            }
        }
    }

    private void executeOnCameraMoveCancelled() {
        if (this.onCameraMoveCanceledListener != null && !this.idle) {
            this.onCameraMoveCanceledListener.onCameraMoveCanceled();
        }
        if (!this.onCameraMoveCanceled.isEmpty() && !this.idle) {
            for (MapboxMap.OnCameraMoveCanceledListener cameraMoveCanceledListener : this.onCameraMoveCanceled) {
                cameraMoveCanceledListener.onCameraMoveCanceled();
            }
        }
    }

    private void executeOnCameraIdle() {
        if (this.idle) {
            return;
        }
        this.idle = true;
        if (this.onCameraIdleListener != null) {
            this.onCameraIdleListener.onCameraIdle();
        }
        if (!this.onCameraIdle.isEmpty()) {
            for (MapboxMap.OnCameraIdleListener cameraIdleListener : this.onCameraIdle) {
                cameraIdleListener.onCameraIdle();
            }
        }
    }

    private static class CameraChangeHandler
    extends Handler {
        private WeakReference<CameraChangeDispatcher> dispatcherWeakReference;

        CameraChangeHandler(CameraChangeDispatcher dispatcher) {
            this.dispatcherWeakReference = new WeakReference<CameraChangeDispatcher>(dispatcher);
        }

        public void handleMessage(Message msg) {
            CameraChangeDispatcher dispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (dispatcher != null) {
                switch (msg.what) {
                    case 0: {
                        dispatcher.executeOnCameraMoveStarted();
                        break;
                    }
                    case 1: {
                        dispatcher.executeOnCameraMove();
                        break;
                    }
                    case 2: {
                        dispatcher.executeOnCameraMoveCancelled();
                        break;
                    }
                    case 3: {
                        dispatcher.executeOnCameraIdle();
                    }
                }
            }
        }

        void scheduleMessage(int change) {
            CameraChangeDispatcher dispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (dispatcher != null) {
                if (change == 0) {
                    boolean shouldReturn = !dispatcher.idle && (this.hasMessages(3) || this.hasMessages(2));
                    this.removeMessages(3);
                    this.removeMessages(2);
                    if (shouldReturn) {
                        return;
                    }
                }
                Message message = new Message();
                message.what = change;
                this.sendMessage(message);
            }
        }
    }
}

