/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.mapbox.mapboxsdk.maps.MapboxMap;

public final class Utils {
    private Utils() {
    }

    public static float shortestRotation(float heading, float previousHeading) {
        double diff = previousHeading - heading;
        if (diff > 180.0) {
            heading += 360.0f;
        } else if (diff < -180.0) {
            heading -= 360.0f;
        }
        return heading;
    }

    static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    static Bitmap generateShadow(Drawable drawable2, float elevation) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Utils.toEven((float)width + elevation), (int)Utils.toEven((float)height + elevation), (boolean)false);
        return bitmap;
    }

    static Drawable getDrawable(@NonNull Context context, @DrawableRes int drawableRes, @ColorInt Integer tintColor) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableRes);
        if (tintColor == null) {
            return drawable2;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            drawable2.setTint(tintColor.intValue());
        } else {
            drawable2.mutate().setColorFilter(tintColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
        return drawable2;
    }

    static float calculateZoomLevelRadius(@NonNull MapboxMap mapboxMap, @Nullable Location location) {
        if (location == null) {
            return 0.0f;
        }
        double metersPerPixel = mapboxMap.getProjection().getMetersPerPixelAtLatitude(location.getLatitude());
        return (float)((double)location.getAccuracy() * (1.0 / metersPerPixel));
    }

    private static int toEven(float value) {
        int i = (int)(value + 0.5f);
        if (i % 2 == 1) {
            return i - 1;
        }
        return i;
    }
}

