/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class HeatmapLayer
extends Layer {
    @Keep
    HeatmapLayer(long nativePtr) {
        super(nativePtr);
    }

    public HeatmapLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public HeatmapLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public HeatmapLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public HeatmapLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getHeatmapRadius() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-radius", this.nativeGetHeatmapRadius());
    }

    public TransitionOptions getHeatmapRadiusTransition() {
        this.checkThread();
        return this.nativeGetHeatmapRadiusTransition();
    }

    public void setHeatmapRadiusTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapRadiusTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getHeatmapWeight() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-weight", this.nativeGetHeatmapWeight());
    }

    public PropertyValue<Float> getHeatmapIntensity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-intensity", this.nativeGetHeatmapIntensity());
    }

    public TransitionOptions getHeatmapIntensityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapIntensityTransition();
    }

    public void setHeatmapIntensityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapIntensityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHeatmapColor() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-color", this.nativeGetHeatmapColor());
    }

    @ColorInt
    public int getHeatmapColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getHeatmapColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("heatmap-color was set as a Function");
    }

    public PropertyValue<Float> getHeatmapOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-opacity", this.nativeGetHeatmapOpacity());
    }

    public TransitionOptions getHeatmapOpacityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapOpacityTransition();
    }

    public void setHeatmapOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapOpacityTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetHeatmapRadius();

    @Keep
    private native TransitionOptions nativeGetHeatmapRadiusTransition();

    @Keep
    private native void nativeSetHeatmapRadiusTransition(long var1, long var3);

    @Keep
    private native Object nativeGetHeatmapWeight();

    @Keep
    private native Object nativeGetHeatmapIntensity();

    @Keep
    private native TransitionOptions nativeGetHeatmapIntensityTransition();

    @Keep
    private native void nativeSetHeatmapIntensityTransition(long var1, long var3);

    @Keep
    private native Object nativeGetHeatmapColor();

    @Keep
    private native Object nativeGetHeatmapOpacity();

    @Keep
    private native TransitionOptions nativeGetHeatmapOpacityTransition();

    @Keep
    private native void nativeSetHeatmapOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

