/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import java.io.File;
import timber.log.Timber;

public class OfflineManager {
    @Keep
    private long nativePtr;
    private final FileSource fileSource;
    private Handler handler;
    @SuppressLint(value={"StaticFieldLeak"})
    private static OfflineManager instance;
    private Context context;

    private OfflineManager(Context context) {
        this.context = context.getApplicationContext();
        this.fileSource = FileSource.getInstance(this.context);
        this.initialize(this.fileSource);
        this.deleteAmbientDatabase(this.context);
    }

    private void deleteAmbientDatabase(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String path = FileSource.getInternalCachePath(context) + File.separator + "mbgl-cache.db";
                    File file = new File(path);
                    if (file.exists()) {
                        file.delete();
                        Timber.d((String)"Old ambient cache database deleted to save space: %s", (Object[])new Object[]{path});
                    }
                }
                catch (Exception exception) {
                    Timber.e((Throwable)exception, (String)"Failed to delete old ambient cache database: ", (Object[])new Object[0]);
                }
            }
        }).start();
    }

    public static synchronized OfflineManager getInstance(Context context) {
        if (instance == null) {
            instance = new OfflineManager(context);
        }
        return instance;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void listOfflineRegions(final @NonNull ListOfflineRegionsCallback callback) {
        this.fileSource.activate();
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(){

            @Override
            public void onList(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onList(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        OfflineManager.this.fileSource.deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void createOfflineRegion(@NonNull OfflineRegionDefinition definition, @NonNull byte[] metadata, final CreateOfflineRegionCallback callback) {
        if (!this.isValidOfflineRegionDefinition(definition)) {
            callback.onError(String.format(this.context.getString(R.string.mapbox_offline_error_region_definition_invalid), definition.getBounds()));
            return;
        }
        ConnectivityReceiver.instance(this.context).activate();
        FileSource.getInstance(this.context).activate();
        this.createOfflineRegion(this.fileSource, definition, metadata, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        FileSource.getInstance(OfflineManager.this.context).deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    private boolean isValidOfflineRegionDefinition(OfflineRegionDefinition definition) {
        return LatLngBounds.world().contains(definition.getBounds());
    }

    @Keep
    public native void setOfflineMapboxTileCountLimit(long var1);

    @Keep
    private native void initialize(FileSource var1);

    @Keep
    protected native void finalize() throws Throwable;

    @Keep
    private native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    @Keep
    private native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    static {
        LibraryLoader.load();
    }

    @Keep
    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    @Keep
    public static interface ListOfflineRegionsCallback {
        public void onList(OfflineRegion[] var1);

        public void onError(String var1);
    }
}

