/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class HillshadeLayer
extends Layer {
    @Keep
    public HillshadeLayer(long nativePtr) {
        super(nativePtr);
    }

    public HillshadeLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public HillshadeLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public HillshadeLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getHillshadeIlluminationDirection() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-illumination-direction", this.nativeGetHillshadeIlluminationDirection());
    }

    public PropertyValue<String> getHillshadeIlluminationAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-illumination-anchor", this.nativeGetHillshadeIlluminationAnchor());
    }

    public PropertyValue<Float> getHillshadeExaggeration() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-exaggeration", this.nativeGetHillshadeExaggeration());
    }

    public TransitionOptions getHillshadeExaggerationTransition() {
        this.checkThread();
        return this.nativeGetHillshadeExaggerationTransition();
    }

    public void setHillshadeExaggerationTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHillshadeExaggerationTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeShadowColor() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-shadow-color", this.nativeGetHillshadeShadowColor());
    }

    @ColorInt
    public int getHillshadeShadowColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getHillshadeShadowColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-shadow-color was set as a Function");
    }

    public TransitionOptions getHillshadeShadowColorTransition() {
        this.checkThread();
        return this.nativeGetHillshadeShadowColorTransition();
    }

    public void setHillshadeShadowColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHillshadeShadowColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeHighlightColor() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-highlight-color", this.nativeGetHillshadeHighlightColor());
    }

    @ColorInt
    public int getHillshadeHighlightColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getHillshadeHighlightColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-highlight-color was set as a Function");
    }

    public TransitionOptions getHillshadeHighlightColorTransition() {
        this.checkThread();
        return this.nativeGetHillshadeHighlightColorTransition();
    }

    public void setHillshadeHighlightColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHillshadeHighlightColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getHillshadeAccentColor() {
        this.checkThread();
        return new PropertyValue<Object>("hillshade-accent-color", this.nativeGetHillshadeAccentColor());
    }

    @ColorInt
    public int getHillshadeAccentColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getHillshadeAccentColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("hillshade-accent-color was set as a Function");
    }

    public TransitionOptions getHillshadeAccentColorTransition() {
        this.checkThread();
        return this.nativeGetHillshadeAccentColorTransition();
    }

    public void setHillshadeAccentColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetHillshadeAccentColorTransition(options.getDuration(), options.getDelay());
    }

    @Keep
    private native Object nativeGetHillshadeIlluminationDirection();

    @Keep
    private native Object nativeGetHillshadeIlluminationAnchor();

    @Keep
    private native Object nativeGetHillshadeExaggeration();

    @Keep
    private native TransitionOptions nativeGetHillshadeExaggerationTransition();

    @Keep
    private native void nativeSetHillshadeExaggerationTransition(long var1, long var3);

    @Keep
    private native Object nativeGetHillshadeShadowColor();

    @Keep
    private native TransitionOptions nativeGetHillshadeShadowColorTransition();

    @Keep
    private native void nativeSetHillshadeShadowColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetHillshadeHighlightColor();

    @Keep
    private native TransitionOptions nativeGetHillshadeHighlightColorTransition();

    @Keep
    private native void nativeSetHillshadeHighlightColorTransition(long var1, long var3);

    @Keep
    private native Object nativeGetHillshadeAccentColor();

    @Keep
    private native TransitionOptions nativeGetHillshadeAccentColorTransition();

    @Keep
    private native void nativeSetHillshadeAccentColorTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

