/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.mapboxsdk.Mapbox;

public class Telemetry {
    static final String TWO_FINGER_TAP = "TwoFingerTap";
    static final String DOUBLE_TAP = "DoubleTap";
    static final String SINGLE_TAP = "SingleTap";
    static final String PAN = "Pan";
    static final String PINCH = "Pinch";
    static final String ROTATION = "Rotation";
    static final String PITCH = "Pitch";
    private MapboxTelemetry telemetry = new MapboxTelemetry(Mapbox.getApplicationContext(), Mapbox.getAccessToken(), "MapboxEventsAndroid/6.3.0-alpha.2");

    private Telemetry() {
        TelemetryEnabler.State telemetryState = TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        if (TelemetryEnabler.State.ENABLED.equals((Object)telemetryState)) {
            this.telemetry.enable();
        }
    }

    public static void initialize() {
        Telemetry.obtainTelemetry();
    }

    public static void updateDebugLoggingEnabled(boolean debugLoggingEnabled) {
        TelemetryHolder.INSTANCE.telemetry.updateDebugLoggingEnabled(debugLoggingEnabled);
    }

    public static boolean updateSessionIdRotationInterval(SessionInterval interval) {
        return TelemetryHolder.INSTANCE.telemetry.updateSessionIdRotationInterval(interval);
    }

    public static void enableOnUserRequest() {
        TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.ENABLED);
        TelemetryHolder.INSTANCE.telemetry.enable();
    }

    public static void disableOnUserRequest() {
        Telemetry.obtainTelemetry().disable();
        TelemetryEnabler.updateTelemetryState((TelemetryEnabler.State)TelemetryEnabler.State.DISABLED);
    }

    static MapboxTelemetry obtainTelemetry() {
        return TelemetryHolder.INSTANCE.telemetry;
    }

    private static class TelemetryHolder {
        private static final Telemetry INSTANCE = new Telemetry();

        private TelemetryHolder() {
        }
    }
}

