/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.attribution;

import android.os.Build;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.URLSpan;
import com.mapbox.mapboxsdk.attribution.Attribution;
import java.util.LinkedHashSet;
import java.util.Set;

public class AttributionParser {
    private final Set<Attribution> attributions = new LinkedHashSet<Attribution>();
    private final String attributionData;
    private final boolean withImproveMap;
    private final boolean withCopyrightSign;
    private final boolean withTelemetryAttribution;
    private final boolean withMapboxAttribution;

    AttributionParser(String attributionData, boolean withImproveMap, boolean withCopyrightSign, boolean withTelemetryAttribution, boolean withMapboxAttribution) {
        this.attributionData = attributionData;
        this.withImproveMap = withImproveMap;
        this.withCopyrightSign = withCopyrightSign;
        this.withTelemetryAttribution = withTelemetryAttribution;
        this.withMapboxAttribution = withMapboxAttribution;
    }

    public Set<Attribution> getAttributions() {
        return this.attributions;
    }

    public String createAttributionString() {
        return this.createAttributionString(false);
    }

    public String createAttributionString(boolean shortenedOutput) {
        StringBuilder stringBuilder = new StringBuilder(this.withCopyrightSign ? "" : "\u00a9 ");
        int counter = 0;
        for (Attribution attribution : this.attributions) {
            stringBuilder.append(!shortenedOutput ? attribution.getTitle() : attribution.getTitleAbbreviated());
            if (++counter == this.attributions.size()) continue;
            stringBuilder.append(" / ");
        }
        return stringBuilder.toString();
    }

    protected void parse() {
        this.parseAttributions();
        this.addAdditionalAttributions();
    }

    private void parseAttributions() {
        URLSpan[] urlSpans;
        SpannableStringBuilder htmlBuilder = (SpannableStringBuilder)AttributionParser.fromHtml(this.attributionData);
        for (URLSpan urlSpan : urlSpans = (URLSpan[])htmlBuilder.getSpans(0, htmlBuilder.length(), URLSpan.class)) {
            this.parseUrlSpan(htmlBuilder, urlSpan);
        }
    }

    private void parseUrlSpan(SpannableStringBuilder htmlBuilder, URLSpan urlSpan) {
        String url = urlSpan.getURL();
        if (this.isUrlValid(url)) {
            String anchor = this.parseAnchorValue(htmlBuilder, urlSpan);
            this.attributions.add(new Attribution(anchor, url));
        }
    }

    private boolean isUrlValid(String url) {
        return this.isValidForImproveThisMap(url) && this.isValidForMapbox(url);
    }

    private boolean isValidForImproveThisMap(String url) {
        return this.withImproveMap || !url.equals("https://www.mapbox.com/map-feedback/");
    }

    private boolean isValidForMapbox(String url) {
        return this.withMapboxAttribution || !url.equals("https://www.mapbox.com/about/maps/");
    }

    private String parseAnchorValue(SpannableStringBuilder htmlBuilder, URLSpan urlSpan) {
        int start = htmlBuilder.getSpanStart((Object)urlSpan);
        int end = htmlBuilder.getSpanEnd((Object)urlSpan);
        int length = end - start;
        char[] charKey = new char[length];
        htmlBuilder.getChars(start, end, charKey, 0);
        return this.stripCopyright(String.valueOf(charKey));
    }

    private String stripCopyright(String anchor) {
        if (!this.withCopyrightSign && anchor.startsWith("\u00a9 ")) {
            anchor = anchor.substring(2, anchor.length());
        }
        return anchor;
    }

    private void addAdditionalAttributions() {
        if (this.withTelemetryAttribution) {
            this.attributions.add(new Attribution("Telemetry Settings", "https://www.mapbox.com/telemetry/"));
        }
    }

    private static Spanned fromHtml(String html) {
        Spanned result = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)html, (int)0) : Html.fromHtml((String)html);
        return result;
    }

    public static class Options {
        private boolean withImproveMap = true;
        private boolean withCopyrightSign = true;
        private boolean withTelemetryAttribution = false;
        private boolean withMapboxAttribution = true;
        private String[] attributionDataStringArray;

        public Options withAttributionData(String ... attributionData) {
            this.attributionDataStringArray = attributionData;
            return this;
        }

        public Options withImproveMap(boolean withImproveMap) {
            this.withImproveMap = withImproveMap;
            return this;
        }

        public Options withCopyrightSign(boolean withCopyrightSign) {
            this.withCopyrightSign = withCopyrightSign;
            return this;
        }

        public Options withTelemetryAttribution(boolean withTelemetryAttribution) {
            this.withTelemetryAttribution = withTelemetryAttribution;
            return this;
        }

        public Options withMapboxAttribution(boolean withMapboxAttribution) {
            this.withMapboxAttribution = withMapboxAttribution;
            return this;
        }

        public AttributionParser build() {
            if (this.attributionDataStringArray == null) {
                throw new IllegalStateException("Using builder without providing attribution data");
            }
            String fullAttributionString = this.parseAttribution(this.attributionDataStringArray);
            AttributionParser attributionParser = new AttributionParser(fullAttributionString, this.withImproveMap, this.withCopyrightSign, this.withTelemetryAttribution, this.withMapboxAttribution);
            attributionParser.parse();
            return attributionParser;
        }

        private String parseAttribution(String[] attribution) {
            StringBuilder builder = new StringBuilder();
            for (String attr : attribution) {
                if (attr.isEmpty()) continue;
                builder.append(attr);
            }
            return builder.toString();
        }
    }
}

