/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UiThread
public class GeoJsonSource
extends Source {
    public GeoJsonSource(long nativePtr) {
        super(nativePtr);
    }

    public GeoJsonSource(String id2) {
        this.initialize(id2, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, String geoJson) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, null);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id2, String geoJson, GeoJsonOptions options) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, options);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id2, URL url) {
        this.initialize(id2, null);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id2, URL url, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id2, FeatureCollection features) {
        this.initialize(id2, null);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id2, FeatureCollection features, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id2, Feature feature) {
        this.initialize(id2, null);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id2, Feature feature, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(feature);
    }

    public GeoJsonSource(String id2, Geometry geometry) {
        this.initialize(id2, null);
        this.setGeoJson(geometry);
    }

    public GeoJsonSource(String id2, Geometry geometry, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(geometry);
    }

    public void setGeoJson(Feature feature) {
        this.checkThread();
        this.nativeSetFeature(feature);
    }

    public void setGeoJson(Geometry geometry) {
        this.checkThread();
        this.nativeSetGeometry(geometry);
    }

    public void setGeoJson(FeatureCollection features) {
        this.checkThread();
        this.nativeSetFeatureCollection(features);
    }

    public void setGeoJson(String json) {
        this.checkThread();
        this.nativeSetGeoJsonString(json);
    }

    public void setUrl(URL url) {
        this.checkThread();
        this.setUrl(url.toExternalForm());
    }

    public void setUrl(String url) {
        this.checkThread();
        this.nativeSetUrl(url);
    }

    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Expression filter) {
        this.checkThread();
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    protected native void initialize(String var1, Object var2);

    protected native void nativeSetUrl(String var1);

    protected native String nativeGetUrl();

    private native void nativeSetGeoJsonString(String var1);

    private native void nativeSetFeatureCollection(FeatureCollection var1);

    private native void nativeSetFeature(Feature var1);

    private native void nativeSetGeometry(Geometry var1);

    private native Feature[] querySourceFeatures(Object[] var1);

    protected native void finalize() throws Throwable;
}

