/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.exceptions.InvalidMarkerPositionException;
import com.mapbox.mapboxsdk.geometry.LatLng;

public final class MarkerOptions
extends BaseMarkerOptions<Marker, MarkerOptions>
implements Parcelable {
    public static final Parcelable.Creator<MarkerOptions> CREATOR = new Parcelable.Creator<MarkerOptions>(){

        public MarkerOptions createFromParcel(Parcel in) {
            return new MarkerOptions(in);
        }

        public MarkerOptions[] newArray(int size) {
            return new MarkerOptions[size];
        }
    };

    public MarkerOptions() {
    }

    protected MarkerOptions(Parcel in) {
        this.position((LatLng)in.readParcelable(LatLng.class.getClassLoader()));
        this.snippet(in.readString());
        this.title(in.readString());
        if (in.readByte() != 0) {
            String iconId = in.readString();
            Bitmap iconBitmap = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
            Icon icon = new Icon(iconId, iconBitmap);
            this.icon(icon);
        }
    }

    @Override
    public MarkerOptions getThis() {
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.getPosition(), flags);
        out.writeString(this.getSnippet());
        out.writeString(this.getTitle());
        Icon icon = this.getIcon();
        out.writeByte((byte)(icon != null ? 1 : 0));
        if (icon != null) {
            out.writeString(this.getIcon().getId());
            out.writeParcelable((Parcelable)this.getIcon().getBitmap(), flags);
        }
    }

    @Override
    public Marker getMarker() {
        if (this.position == null) {
            throw new InvalidMarkerPositionException();
        }
        return new Marker(this.position, this.icon, this.title, this.snippet);
    }

    public LatLng getPosition() {
        return this.position;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkerOptions marker = (MarkerOptions)o;
        if (this.getPosition() != null ? !this.getPosition().equals(marker.getPosition()) : marker.getPosition() != null) {
            return false;
        }
        if (this.getSnippet() != null ? !this.getSnippet().equals(marker.getSnippet()) : marker.getSnippet() != null) {
            return false;
        }
        if (this.getIcon() != null ? !this.getIcon().equals(marker.getIcon()) : marker.getIcon() != null) {
            return false;
        }
        return !(this.getTitle() == null ? marker.getTitle() != null : !this.getTitle().equals(marker.getTitle()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getPosition() != null ? this.getPosition().hashCode() : 0);
        result = 31 * result + (this.getSnippet() != null ? this.getSnippet().hashCode() : 0);
        result = 31 * result + (this.getIcon() != null ? this.getIcon().hashCode() : 0);
        result = 31 * result + (this.getTitle() != null ? this.getTitle().hashCode() : 0);
        return result;
    }
}

