/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class SymbolLayer
extends Layer {
    public SymbolLayer(long nativePtr) {
        super(nativePtr);
    }

    public SymbolLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public SymbolLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public SymbolLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public SymbolLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getSymbolPlacement() {
        return new PropertyValue<Object>("symbol-placement", this.nativeGetSymbolPlacement());
    }

    public PropertyValue<Float> getSymbolSpacing() {
        return new PropertyValue<Object>("symbol-spacing", this.nativeGetSymbolSpacing());
    }

    public PropertyValue<Boolean> getSymbolAvoidEdges() {
        return new PropertyValue<Object>("symbol-avoid-edges", this.nativeGetSymbolAvoidEdges());
    }

    public PropertyValue<Boolean> getIconAllowOverlap() {
        return new PropertyValue<Object>("icon-allow-overlap", this.nativeGetIconAllowOverlap());
    }

    public PropertyValue<Boolean> getIconIgnorePlacement() {
        return new PropertyValue<Object>("icon-ignore-placement", this.nativeGetIconIgnorePlacement());
    }

    public PropertyValue<Boolean> getIconOptional() {
        return new PropertyValue<Object>("icon-optional", this.nativeGetIconOptional());
    }

    public PropertyValue<String> getIconRotationAlignment() {
        return new PropertyValue<Object>("icon-rotation-alignment", this.nativeGetIconRotationAlignment());
    }

    public PropertyValue<Float> getIconSize() {
        return new PropertyValue<Object>("icon-size", this.nativeGetIconSize());
    }

    public PropertyValue<String> getIconTextFit() {
        return new PropertyValue<Object>("icon-text-fit", this.nativeGetIconTextFit());
    }

    public PropertyValue<Float[]> getIconTextFitPadding() {
        return new PropertyValue<Object>("icon-text-fit-padding", this.nativeGetIconTextFitPadding());
    }

    public PropertyValue<String> getIconImage() {
        return new PropertyValue<Object>("icon-image", this.nativeGetIconImage());
    }

    public PropertyValue<Float> getIconRotate() {
        return new PropertyValue<Object>("icon-rotate", this.nativeGetIconRotate());
    }

    public PropertyValue<Float> getIconPadding() {
        return new PropertyValue<Object>("icon-padding", this.nativeGetIconPadding());
    }

    public PropertyValue<Boolean> getIconKeepUpright() {
        return new PropertyValue<Object>("icon-keep-upright", this.nativeGetIconKeepUpright());
    }

    public PropertyValue<Float[]> getIconOffset() {
        return new PropertyValue<Object>("icon-offset", this.nativeGetIconOffset());
    }

    public PropertyValue<String> getIconAnchor() {
        return new PropertyValue<Object>("icon-anchor", this.nativeGetIconAnchor());
    }

    public PropertyValue<String> getIconPitchAlignment() {
        return new PropertyValue<Object>("icon-pitch-alignment", this.nativeGetIconPitchAlignment());
    }

    public PropertyValue<String> getTextPitchAlignment() {
        return new PropertyValue<Object>("text-pitch-alignment", this.nativeGetTextPitchAlignment());
    }

    public PropertyValue<String> getTextRotationAlignment() {
        return new PropertyValue<Object>("text-rotation-alignment", this.nativeGetTextRotationAlignment());
    }

    public PropertyValue<String> getTextField() {
        return new PropertyValue<Object>("text-field", this.nativeGetTextField());
    }

    public PropertyValue<String[]> getTextFont() {
        return new PropertyValue<Object>("text-font", this.nativeGetTextFont());
    }

    public PropertyValue<Float> getTextSize() {
        return new PropertyValue<Object>("text-size", this.nativeGetTextSize());
    }

    public PropertyValue<Float> getTextMaxWidth() {
        return new PropertyValue<Object>("text-max-width", this.nativeGetTextMaxWidth());
    }

    public PropertyValue<Float> getTextLineHeight() {
        return new PropertyValue<Object>("text-line-height", this.nativeGetTextLineHeight());
    }

    public PropertyValue<Float> getTextLetterSpacing() {
        return new PropertyValue<Object>("text-letter-spacing", this.nativeGetTextLetterSpacing());
    }

    public PropertyValue<String> getTextJustify() {
        return new PropertyValue<Object>("text-justify", this.nativeGetTextJustify());
    }

    public PropertyValue<String> getTextAnchor() {
        return new PropertyValue<Object>("text-anchor", this.nativeGetTextAnchor());
    }

    public PropertyValue<Float> getTextMaxAngle() {
        return new PropertyValue<Object>("text-max-angle", this.nativeGetTextMaxAngle());
    }

    public PropertyValue<Float> getTextRotate() {
        return new PropertyValue<Object>("text-rotate", this.nativeGetTextRotate());
    }

    public PropertyValue<Float> getTextPadding() {
        return new PropertyValue<Object>("text-padding", this.nativeGetTextPadding());
    }

    public PropertyValue<Boolean> getTextKeepUpright() {
        return new PropertyValue<Object>("text-keep-upright", this.nativeGetTextKeepUpright());
    }

    public PropertyValue<String> getTextTransform() {
        return new PropertyValue<Object>("text-transform", this.nativeGetTextTransform());
    }

    public PropertyValue<Float[]> getTextOffset() {
        return new PropertyValue<Object>("text-offset", this.nativeGetTextOffset());
    }

    public PropertyValue<Boolean> getTextAllowOverlap() {
        return new PropertyValue<Object>("text-allow-overlap", this.nativeGetTextAllowOverlap());
    }

    public PropertyValue<Boolean> getTextIgnorePlacement() {
        return new PropertyValue<Object>("text-ignore-placement", this.nativeGetTextIgnorePlacement());
    }

    public PropertyValue<Boolean> getTextOptional() {
        return new PropertyValue<Object>("text-optional", this.nativeGetTextOptional());
    }

    public PropertyValue<Float> getIconOpacity() {
        return new PropertyValue<Object>("icon-opacity", this.nativeGetIconOpacity());
    }

    public TransitionOptions getIconOpacityTransition() {
        return this.nativeGetIconOpacityTransition();
    }

    public void setIconOpacityTransition(TransitionOptions options) {
        this.nativeSetIconOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconColor() {
        return new PropertyValue<Object>("icon-color", this.nativeGetIconColor());
    }

    @ColorInt
    public int getIconColorAsInt() {
        PropertyValue<String> value = this.getIconColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-color was set as a Function");
    }

    public TransitionOptions getIconColorTransition() {
        return this.nativeGetIconColorTransition();
    }

    public void setIconColorTransition(TransitionOptions options) {
        this.nativeSetIconColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconHaloColor() {
        return new PropertyValue<Object>("icon-halo-color", this.nativeGetIconHaloColor());
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        PropertyValue<String> value = this.getIconHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-halo-color was set as a Function");
    }

    public TransitionOptions getIconHaloColorTransition() {
        return this.nativeGetIconHaloColorTransition();
    }

    public void setIconHaloColorTransition(TransitionOptions options) {
        this.nativeSetIconHaloColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getIconHaloWidth() {
        return new PropertyValue<Object>("icon-halo-width", this.nativeGetIconHaloWidth());
    }

    public TransitionOptions getIconHaloWidthTransition() {
        return this.nativeGetIconHaloWidthTransition();
    }

    public void setIconHaloWidthTransition(TransitionOptions options) {
        this.nativeSetIconHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getIconHaloBlur() {
        return new PropertyValue<Object>("icon-halo-blur", this.nativeGetIconHaloBlur());
    }

    public TransitionOptions getIconHaloBlurTransition() {
        return this.nativeGetIconHaloBlurTransition();
    }

    public void setIconHaloBlurTransition(TransitionOptions options) {
        this.nativeSetIconHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getIconTranslate() {
        return new PropertyValue<Object>("icon-translate", this.nativeGetIconTranslate());
    }

    public TransitionOptions getIconTranslateTransition() {
        return this.nativeGetIconTranslateTransition();
    }

    public void setIconTranslateTransition(TransitionOptions options) {
        this.nativeSetIconTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconTranslateAnchor() {
        return new PropertyValue<Object>("icon-translate-anchor", this.nativeGetIconTranslateAnchor());
    }

    public PropertyValue<Float> getTextOpacity() {
        return new PropertyValue<Object>("text-opacity", this.nativeGetTextOpacity());
    }

    public TransitionOptions getTextOpacityTransition() {
        return this.nativeGetTextOpacityTransition();
    }

    public void setTextOpacityTransition(TransitionOptions options) {
        this.nativeSetTextOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextColor() {
        return new PropertyValue<Object>("text-color", this.nativeGetTextColor());
    }

    @ColorInt
    public int getTextColorAsInt() {
        PropertyValue<String> value = this.getTextColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-color was set as a Function");
    }

    public TransitionOptions getTextColorTransition() {
        return this.nativeGetTextColorTransition();
    }

    public void setTextColorTransition(TransitionOptions options) {
        this.nativeSetTextColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextHaloColor() {
        return new PropertyValue<Object>("text-halo-color", this.nativeGetTextHaloColor());
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        PropertyValue<String> value = this.getTextHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-halo-color was set as a Function");
    }

    public TransitionOptions getTextHaloColorTransition() {
        return this.nativeGetTextHaloColorTransition();
    }

    public void setTextHaloColorTransition(TransitionOptions options) {
        this.nativeSetTextHaloColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getTextHaloWidth() {
        return new PropertyValue<Object>("text-halo-width", this.nativeGetTextHaloWidth());
    }

    public TransitionOptions getTextHaloWidthTransition() {
        return this.nativeGetTextHaloWidthTransition();
    }

    public void setTextHaloWidthTransition(TransitionOptions options) {
        this.nativeSetTextHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getTextHaloBlur() {
        return new PropertyValue<Object>("text-halo-blur", this.nativeGetTextHaloBlur());
    }

    public TransitionOptions getTextHaloBlurTransition() {
        return this.nativeGetTextHaloBlurTransition();
    }

    public void setTextHaloBlurTransition(TransitionOptions options) {
        this.nativeSetTextHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getTextTranslate() {
        return new PropertyValue<Object>("text-translate", this.nativeGetTextTranslate());
    }

    public TransitionOptions getTextTranslateTransition() {
        return this.nativeGetTextTranslateTransition();
    }

    public void setTextTranslateTransition(TransitionOptions options) {
        this.nativeSetTextTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextTranslateAnchor() {
        return new PropertyValue<Object>("text-translate-anchor", this.nativeGetTextTranslateAnchor());
    }

    private native Object nativeGetSymbolPlacement();

    private native Object nativeGetSymbolSpacing();

    private native Object nativeGetSymbolAvoidEdges();

    private native Object nativeGetIconAllowOverlap();

    private native Object nativeGetIconIgnorePlacement();

    private native Object nativeGetIconOptional();

    private native Object nativeGetIconRotationAlignment();

    private native Object nativeGetIconSize();

    private native Object nativeGetIconTextFit();

    private native Object nativeGetIconTextFitPadding();

    private native Object nativeGetIconImage();

    private native Object nativeGetIconRotate();

    private native Object nativeGetIconPadding();

    private native Object nativeGetIconKeepUpright();

    private native Object nativeGetIconOffset();

    private native Object nativeGetIconAnchor();

    private native Object nativeGetIconPitchAlignment();

    private native Object nativeGetTextPitchAlignment();

    private native Object nativeGetTextRotationAlignment();

    private native Object nativeGetTextField();

    private native Object nativeGetTextFont();

    private native Object nativeGetTextSize();

    private native Object nativeGetTextMaxWidth();

    private native Object nativeGetTextLineHeight();

    private native Object nativeGetTextLetterSpacing();

    private native Object nativeGetTextJustify();

    private native Object nativeGetTextAnchor();

    private native Object nativeGetTextMaxAngle();

    private native Object nativeGetTextRotate();

    private native Object nativeGetTextPadding();

    private native Object nativeGetTextKeepUpright();

    private native Object nativeGetTextTransform();

    private native Object nativeGetTextOffset();

    private native Object nativeGetTextAllowOverlap();

    private native Object nativeGetTextIgnorePlacement();

    private native Object nativeGetTextOptional();

    private native Object nativeGetIconOpacity();

    private native TransitionOptions nativeGetIconOpacityTransition();

    private native void nativeSetIconOpacityTransition(long var1, long var3);

    private native Object nativeGetIconColor();

    private native TransitionOptions nativeGetIconColorTransition();

    private native void nativeSetIconColorTransition(long var1, long var3);

    private native Object nativeGetIconHaloColor();

    private native TransitionOptions nativeGetIconHaloColorTransition();

    private native void nativeSetIconHaloColorTransition(long var1, long var3);

    private native Object nativeGetIconHaloWidth();

    private native TransitionOptions nativeGetIconHaloWidthTransition();

    private native void nativeSetIconHaloWidthTransition(long var1, long var3);

    private native Object nativeGetIconHaloBlur();

    private native TransitionOptions nativeGetIconHaloBlurTransition();

    private native void nativeSetIconHaloBlurTransition(long var1, long var3);

    private native Object nativeGetIconTranslate();

    private native TransitionOptions nativeGetIconTranslateTransition();

    private native void nativeSetIconTranslateTransition(long var1, long var3);

    private native Object nativeGetIconTranslateAnchor();

    private native Object nativeGetTextOpacity();

    private native TransitionOptions nativeGetTextOpacityTransition();

    private native void nativeSetTextOpacityTransition(long var1, long var3);

    private native Object nativeGetTextColor();

    private native TransitionOptions nativeGetTextColorTransition();

    private native void nativeSetTextColorTransition(long var1, long var3);

    private native Object nativeGetTextHaloColor();

    private native TransitionOptions nativeGetTextHaloColorTransition();

    private native void nativeSetTextHaloColorTransition(long var1, long var3);

    private native Object nativeGetTextHaloWidth();

    private native TransitionOptions nativeGetTextHaloWidthTransition();

    private native void nativeSetTextHaloWidthTransition(long var1, long var3);

    private native Object nativeGetTextHaloBlur();

    private native TransitionOptions nativeGetTextHaloBlurTransition();

    private native void nativeSetTextHaloBlurTransition(long var1, long var3);

    private native Object nativeGetTextTranslate();

    private native TransitionOptions nativeGetTextTranslateTransition();

    private native void nativeSetTextTranslateTransition(long var1, long var3);

    private native Object nativeGetTextTranslateAnchor();

    @Override
    protected native void finalize() throws Throwable;
}

