/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class FillExtrusionLayer
extends Layer {
    public FillExtrusionLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillExtrusionLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.nativeSetSourceLayer(sourceLayer);
    }

    public FillExtrusionLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.nativeSetFilter(filter.toArray());
    }

    public FillExtrusionLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        Expression expression = null;
        JsonArray array = this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public FillExtrusionLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<Float> getFillExtrusionOpacity() {
        return new PropertyValue<Object>("fill-extrusion-opacity", this.nativeGetFillExtrusionOpacity());
    }

    public TransitionOptions getFillExtrusionOpacityTransition() {
        return this.nativeGetFillExtrusionOpacityTransition();
    }

    public void setFillExtrusionOpacityTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillExtrusionColor() {
        return new PropertyValue<Object>("fill-extrusion-color", this.nativeGetFillExtrusionColor());
    }

    @ColorInt
    public int getFillExtrusionColorAsInt() {
        PropertyValue<String> value = this.getFillExtrusionColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-extrusion-color was set as a Function");
    }

    public TransitionOptions getFillExtrusionColorTransition() {
        return this.nativeGetFillExtrusionColorTransition();
    }

    public void setFillExtrusionColorTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getFillExtrusionTranslate() {
        return new PropertyValue<Object>("fill-extrusion-translate", this.nativeGetFillExtrusionTranslate());
    }

    public TransitionOptions getFillExtrusionTranslateTransition() {
        return this.nativeGetFillExtrusionTranslateTransition();
    }

    public void setFillExtrusionTranslateTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getFillExtrusionTranslateAnchor() {
        return new PropertyValue<Object>("fill-extrusion-translate-anchor", this.nativeGetFillExtrusionTranslateAnchor());
    }

    public PropertyValue<String> getFillExtrusionPattern() {
        return new PropertyValue<Object>("fill-extrusion-pattern", this.nativeGetFillExtrusionPattern());
    }

    public TransitionOptions getFillExtrusionPatternTransition() {
        return this.nativeGetFillExtrusionPatternTransition();
    }

    public void setFillExtrusionPatternTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionPatternTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getFillExtrusionHeight() {
        return new PropertyValue<Object>("fill-extrusion-height", this.nativeGetFillExtrusionHeight());
    }

    public TransitionOptions getFillExtrusionHeightTransition() {
        return this.nativeGetFillExtrusionHeightTransition();
    }

    public void setFillExtrusionHeightTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionHeightTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getFillExtrusionBase() {
        return new PropertyValue<Object>("fill-extrusion-base", this.nativeGetFillExtrusionBase());
    }

    public TransitionOptions getFillExtrusionBaseTransition() {
        return this.nativeGetFillExtrusionBaseTransition();
    }

    public void setFillExtrusionBaseTransition(TransitionOptions options) {
        this.nativeSetFillExtrusionBaseTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetFillExtrusionOpacity();

    private native TransitionOptions nativeGetFillExtrusionOpacityTransition();

    private native void nativeSetFillExtrusionOpacityTransition(long var1, long var3);

    private native Object nativeGetFillExtrusionColor();

    private native TransitionOptions nativeGetFillExtrusionColorTransition();

    private native void nativeSetFillExtrusionColorTransition(long var1, long var3);

    private native Object nativeGetFillExtrusionTranslate();

    private native TransitionOptions nativeGetFillExtrusionTranslateTransition();

    private native void nativeSetFillExtrusionTranslateTransition(long var1, long var3);

    private native Object nativeGetFillExtrusionTranslateAnchor();

    private native Object nativeGetFillExtrusionPattern();

    private native TransitionOptions nativeGetFillExtrusionPatternTransition();

    private native void nativeSetFillExtrusionPatternTransition(long var1, long var3);

    private native Object nativeGetFillExtrusionHeight();

    private native TransitionOptions nativeGetFillExtrusionHeightTransition();

    private native void nativeSetFillExtrusionHeightTransition(long var1, long var3);

    private native Object nativeGetFillExtrusionBase();

    private native TransitionOptions nativeGetFillExtrusionBaseTransition();

    private native void nativeSetFillExtrusionBaseTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

