/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.utils.AnimatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Deprecated
public class MarkerViewManager
implements MapView.OnMapChangedListener {
    private final ViewGroup markerViewContainer;
    private final ViewTreeObserver.OnPreDrawListener markerViewPreDrawObserver = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            MarkerViewManager.this.invalidateViewMarkersInVisibleRegion();
            MarkerViewManager.this.markerViewContainer.getViewTreeObserver().removeOnPreDrawListener(MarkerViewManager.this.markerViewPreDrawObserver);
            return false;
        }
    };
    private final Map<MarkerView, View> markerViewMap = new HashMap<MarkerView, View>();
    private final LongSparseArray<OnMarkerViewAddedListener> markerViewAddedListenerMap = new LongSparseArray();
    private final List<MapboxMap.MarkerViewAdapter> markerViewAdapters = new ArrayList<MapboxMap.MarkerViewAdapter>();
    private MapboxMap mapboxMap;
    private boolean enabled;
    private long updateTime;
    private MapboxMap.OnMarkerViewClickListener onMarkerViewClickListener;
    private boolean isWaitingForRenderInvoke;

    public MarkerViewManager(@NonNull ViewGroup container) {
        this.markerViewContainer = container;
        this.markerViewAdapters.add(new ImageMarkerViewAdapter(container.getContext()));
    }

    public void bind(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    @Override
    public void onMapChanged(int change) {
        if (this.isWaitingForRenderInvoke && change == 10) {
            this.isWaitingForRenderInvoke = false;
            this.invalidateViewMarkersInVisibleRegion();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setWaitingForRenderInvoke(boolean waitingForRenderInvoke) {
        this.isWaitingForRenderInvoke = waitingForRenderInvoke;
    }

    public void animateRotation(@NonNull MarkerView marker, float rotation) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.rotate(convertView, rotation);
        }
    }

    public void animateRotationBy(@NonNull MarkerView marker, float rotation) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            convertView.animate().cancel();
            float diff = rotation - convertView.getRotation();
            if (diff > 180.0f) {
                diff -= 360.0f;
            } else if (diff < -180.0f) {
                diff += 360.0f;
            }
            AnimatorUtils.rotateBy(convertView, diff);
        }
    }

    public void setRotation(@NonNull MarkerView marker, float rotation) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            convertView.animate().cancel();
            convertView.setRotation(rotation);
        }
    }

    public void animateAlpha(@NonNull MarkerView marker, float alpha) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            AnimatorUtils.alpha(convertView, alpha);
        }
    }

    public void animateVisible(@NonNull MarkerView marker, boolean visible) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            convertView.setVisibility(visible ? 0 : 8);
        }
    }

    public void updateMarkerViewsPosition() {
        for (MarkerView marker : this.markerViewMap.keySet()) {
            View convertView = this.markerViewMap.get(marker);
            if (convertView == null) continue;
            PointF point = this.mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            if (marker.getOffsetX() == -1.0f && marker.getWidth() == 0.0f && marker.isVisible()) {
                convertView.getViewTreeObserver().addOnPreDrawListener(this.markerViewPreDrawObserver);
            }
            marker.setWidth(convertView.getWidth());
            marker.setHeight(convertView.getHeight());
            if (marker.getWidth() != 0.0f) {
                int x = (int)(marker.getAnchorU() * marker.getWidth());
                int y = (int)(marker.getAnchorV() * marker.getHeight());
                marker.setOffset(x, y);
            }
            convertView.setX(point.x - marker.getOffsetX());
            convertView.setY(point.y - marker.getOffsetY());
            if (!marker.isVisible() || convertView.getVisibility() != 8) continue;
            this.animateVisible(marker, true);
        }
    }

    public void setTilt(float tilt) {
        for (MarkerView markerView : this.markerViewMap.keySet()) {
            View convertView;
            if (!markerView.isFlat() || (convertView = this.markerViewMap.get(markerView)) == null) continue;
            markerView.setTilt(tilt);
            convertView.setRotationX(tilt);
        }
    }

    public void updateIcon(@NonNull MarkerView markerView) {
        View convertView = this.markerViewMap.get(markerView);
        if (convertView != null && convertView instanceof ImageView) {
            ((ImageView)convertView).setImageBitmap(markerView.getIcon().getBitmap());
            markerView.invalidate();
        }
    }

    public void deselect(@NonNull MarkerView marker) {
        this.deselect(marker, true);
    }

    public void deselect(@NonNull MarkerView marker, boolean callbackToMap) {
        View convertView = this.markerViewMap.get(marker);
        if (convertView != null) {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                adapter.onDeselect(marker, convertView);
            }
        }
        if (callbackToMap) {
            this.mapboxMap.deselectMarker(marker);
        }
        marker.setSelected(false);
    }

    public void select(@NonNull MarkerView marker) {
        this.select(marker, true);
    }

    public void select(@NonNull MarkerView marker, boolean callbackToMap) {
        View convertView = this.markerViewMap.get(marker);
        for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
            if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
            this.select(marker, convertView, adapter, callbackToMap);
        }
    }

    public void select(@NonNull MarkerView marker, View convertView, MapboxMap.MarkerViewAdapter adapter) {
        this.select(marker, convertView, adapter, true);
    }

    public void select(@NonNull MarkerView marker, View convertView, MapboxMap.MarkerViewAdapter adapter, boolean callbackToMap) {
        if (convertView != null) {
            if (adapter.onSelect(marker, convertView, false) && callbackToMap) {
                this.mapboxMap.selectMarker(marker);
            }
            marker.setSelected(true);
            convertView.bringToFront();
        }
    }

    @Nullable
    public View getView(MarkerView marker) {
        return this.markerViewMap.get(marker);
    }

    @Nullable
    public MapboxMap.MarkerViewAdapter getViewAdapter(MarkerView markerView) {
        MapboxMap.MarkerViewAdapter adapter = null;
        for (MapboxMap.MarkerViewAdapter a : this.markerViewAdapters) {
            if (!a.getMarkerClass().equals(markerView.getClass())) continue;
            adapter = a;
        }
        return adapter;
    }

    public void removeMarkerView(MarkerView marker) {
        View viewHolder = this.markerViewMap.get(marker);
        if (viewHolder != null && marker != null) {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass()) || !adapter.prepareViewForReuse(marker, viewHolder)) continue;
                marker.setOffset(-1.0f, -1.0f);
                adapter.releaseView(viewHolder);
            }
        }
        marker.setMapboxMap(null);
        this.markerViewMap.remove(marker);
    }

    public void addMarkerViewAdapter(MapboxMap.MarkerViewAdapter markerViewAdapter) {
        if (markerViewAdapter.getMarkerClass().equals(MarkerView.class)) {
            throw new RuntimeException("Providing a custom MarkerViewAdapter requires subclassing MarkerView");
        }
        if (!this.markerViewAdapters.contains(markerViewAdapter)) {
            this.markerViewAdapters.add(markerViewAdapter);
            this.invalidateViewMarkersInVisibleRegion();
        }
    }

    public List<MapboxMap.MarkerViewAdapter> getMarkerViewAdapters() {
        return this.markerViewAdapters;
    }

    public void setOnMarkerViewClickListener(@Nullable MapboxMap.OnMarkerViewClickListener listener) {
        this.onMarkerViewClickListener = listener;
    }

    public void update() {
        if (this.enabled) {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.updateTime) {
                this.updateMarkerViewsPosition();
                return;
            }
            this.invalidateViewMarkersInVisibleRegion();
            this.updateTime = currentTime + 250L;
        }
    }

    public void invalidateViewMarkersInVisibleRegion() {
        View convertView;
        RectF mapViewRect = new RectF(0.0f, 0.0f, (float)this.markerViewContainer.getWidth(), (float)this.markerViewContainer.getHeight());
        List<MarkerView> markers = this.mapboxMap.getMarkerViewsInRect(mapViewRect);
        Iterator<MarkerView> iterator = this.markerViewMap.keySet().iterator();
        while (iterator.hasNext()) {
            MarkerView marker = iterator.next();
            if (markers.contains(marker)) continue;
            convertView = this.markerViewMap.get(marker);
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                adapter.prepareViewForReuse(marker, convertView);
                adapter.releaseView(convertView);
                iterator.remove();
            }
        }
        for (MarkerView marker : markers) {
            if (this.markerViewMap.containsKey(marker)) continue;
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                OnMarkerViewAddedListener onViewAddedListener;
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                convertView = (View)adapter.getViewReusePool().acquire();
                View adaptedView = adapter.getView(marker, convertView, this.markerViewContainer);
                if (adaptedView != null) {
                    adaptedView.setRotationX(marker.getTilt());
                    adaptedView.setRotation(marker.getRotation());
                    adaptedView.setAlpha(marker.getAlpha());
                    adaptedView.setVisibility(8);
                    if (this.mapboxMap.getSelectedMarkers().contains(marker) && adapter.onSelect(marker, adaptedView, true)) {
                        this.mapboxMap.selectMarker(marker);
                    }
                    marker.setMapboxMap(this.mapboxMap);
                    this.markerViewMap.put(marker, adaptedView);
                    if (convertView == null) {
                        adaptedView.setVisibility(8);
                        this.markerViewContainer.addView(adaptedView);
                    }
                }
                if ((onViewAddedListener = (OnMarkerViewAddedListener)this.markerViewAddedListenerMap.get(marker.getId())) == null) continue;
                onViewAddedListener.onViewAdded(marker);
                this.markerViewAddedListenerMap.remove(marker.getId());
            }
        }
        this.markerViewAddedListenerMap.clear();
        this.updateMarkerViewsPosition();
    }

    public boolean onClickMarkerView(MarkerView markerView) {
        boolean clickHandled = false;
        MapboxMap.MarkerViewAdapter adapter = this.getViewAdapter(markerView);
        View view = this.getView(markerView);
        if (adapter == null || view == null) {
            return true;
        }
        if (this.onMarkerViewClickListener != null) {
            clickHandled = this.onMarkerViewClickListener.onMarkerClick(markerView, view, adapter);
        }
        return clickHandled;
    }

    public void ensureInfoWindowOffset(MarkerView marker) {
        View view = null;
        if (this.markerViewMap.containsKey(marker)) {
            view = this.markerViewMap.get(marker);
        } else {
            for (MapboxMap.MarkerViewAdapter adapter : this.markerViewAdapters) {
                if (!adapter.getMarkerClass().equals(marker.getClass())) continue;
                View convertView = (View)adapter.getViewReusePool().acquire();
                view = adapter.getView(marker, convertView, this.markerViewContainer);
                break;
            }
        }
        if (view != null) {
            if (marker.getWidth() == 0.0f) {
                if (view.getMeasuredWidth() == 0) {
                    view.measure(0, 0);
                }
                marker.setWidth(view.getMeasuredWidth());
                marker.setHeight(view.getMeasuredHeight());
            }
            if (marker.getOffsetX() == -1.0f) {
                int x = (int)(marker.getAnchorU() * marker.getWidth());
                int y = (int)(marker.getAnchorV() * marker.getHeight());
                marker.setOffset(x, y);
            }
            int infoWindowOffsetX = (int)((float)view.getMeasuredWidth() * marker.getInfoWindowAnchorU() - marker.getOffsetX());
            int infoWindowOffsetY = (int)((float)view.getMeasuredHeight() * marker.getInfoWindowAnchorV() - marker.getOffsetY());
            marker.setTopOffsetPixels(infoWindowOffsetY);
            marker.setRightOffsetPixels(infoWindowOffsetX);
        }
    }

    public ViewGroup getMarkerViewContainer() {
        return this.markerViewContainer;
    }

    public void addOnMarkerViewAddedListener(MarkerView markerView, OnMarkerViewAddedListener onMarkerViewAddedListener) {
        this.markerViewAddedListenerMap.put(markerView.getId(), (Object)onMarkerViewAddedListener);
    }

    public static interface OnMarkerViewAddedListener {
        public void onViewAdded(@NonNull MarkerView var1);
    }

    private static class ImageMarkerViewAdapter
    extends MapboxMap.MarkerViewAdapter<MarkerView> {
        private LayoutInflater inflater;

        ImageMarkerViewAdapter(Context context) {
            super(context);
            this.inflater = LayoutInflater.from((Context)context);
        }

        @Override
        @Nullable
        public View getView(@NonNull MarkerView marker, @Nullable View convertView, @NonNull ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = this.inflater.inflate(R.layout.mapbox_view_image_marker, parent, false);
                viewHolder.imageView = (ImageView)convertView.findViewById(R.id.image);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.imageView.setImageBitmap(marker.getIcon().getBitmap());
            viewHolder.imageView.setContentDescription((CharSequence)marker.getTitle());
            return convertView;
        }

        private static class ViewHolder {
            ImageView imageView;

            private ViewHolder() {
            }
        }
    }
}

