/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.mapboxsdk.utils.BitmapUtils;

@Deprecated
public class MyLocationViewSettings {
    private Projection projection;
    private MyLocationView myLocationView;
    private FocalPointChangeListener focalPointChangeListener;
    private boolean enabled;
    private Drawable foregroundDrawable;
    private Drawable foregroundBearingDrawable;
    @ColorInt
    private int foregroundTintColor;
    private Drawable backgroundDrawable;
    private int[] backgroundOffset = new int[4];
    @ColorInt
    private int backgroundTintColor;
    private int accuracyAlpha;
    private float accuracyThreshold = 0.0f;
    @ColorInt
    private int accuracyTintColor;
    private int[] padding = new int[4];

    public MyLocationViewSettings(MyLocationView myLocationView, Projection projection, FocalPointChangeListener focalPointChangedListener) {
        this.myLocationView = myLocationView;
        this.projection = projection;
        this.focalPointChangeListener = focalPointChangedListener;
    }

    public void initialise(@NonNull MapboxMapOptions options) {
        CameraPosition position = options.getCamera();
        if (position != null && !position.equals(CameraPosition.DEFAULT)) {
            this.setTilt(position.tilt);
        }
        this.setForegroundDrawable(options.getMyLocationForegroundDrawable(), options.getMyLocationForegroundBearingDrawable());
        this.setForegroundTintColor(options.getMyLocationForegroundTintColor());
        this.setBackgroundDrawable(options.getMyLocationBackgroundDrawable(), options.getMyLocationBackgroundPadding());
        this.setBackgroundTintColor(options.getMyLocationBackgroundTintColor());
        this.setAccuracyAlpha(options.getMyLocationAccuracyAlpha());
        this.setAccuracyTintColor(options.getMyLocationAccuracyTintColor());
        this.setAccuracyThreshold(options.getMyLocationAccuracyThreshold());
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putBoolean("mapbox_locViewEnabled", this.isEnabled());
        outState.putByteArray("mapbox_locViewForegroundDrawable", BitmapUtils.getByteArrayFromDrawable(this.getForegroundDrawable()));
        outState.putByteArray("mapbox_locViewBearingDrawable", BitmapUtils.getByteArrayFromDrawable(this.getForegroundBearingDrawable()));
        outState.putInt("mapbox_locViewForegroundTintColor", this.getForegroundTintColor());
        outState.putByteArray("mapbox_locViewBackgroundDrawable", BitmapUtils.getByteArrayFromDrawable(this.getBackgroundDrawable()));
        outState.putIntArray("mapbox_locViewBackgroundOffset", this.getBackgroundOffset());
        outState.putInt("mapbox_locViewBackgroundTintColor", this.getBackgroundTintColor());
        outState.putInt("mapbox_locViewAccuracyAlpha", this.getAccuracyAlpha());
        outState.putInt("mapbox_locViewAccuracyTintColor", this.getAccuracyTintColor());
        outState.putFloat("mapbox_locViewAccuracyThreshold", this.getAccuracyThreshold());
        outState.putIntArray("mapbox_locViewPadding", this.getPadding());
    }

    public void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.setEnabled(savedInstanceState.getBoolean("mapbox_locViewEnabled"));
        this.setForegroundDrawable(BitmapUtils.getDrawableFromByteArray(this.myLocationView.getContext(), savedInstanceState.getByteArray("mapbox_locViewForegroundDrawable")), BitmapUtils.getDrawableFromByteArray(this.myLocationView.getContext(), savedInstanceState.getByteArray("mapbox_locViewBearingDrawable")));
        this.setForegroundTintColor(savedInstanceState.getInt("mapbox_locViewForegroundTintColor"));
        this.setBackgroundDrawable(BitmapUtils.getDrawableFromByteArray(this.myLocationView.getContext(), savedInstanceState.getByteArray("mapbox_locViewBackgroundDrawable")), savedInstanceState.getIntArray("mapbox_locViewBackgroundOffset"));
        this.setBackgroundTintColor(savedInstanceState.getInt("mapbox_locViewBackgroundTintColor"));
        this.setAccuracyAlpha(savedInstanceState.getInt("mapbox_locViewAccuracyAlpha"));
        this.setAccuracyTintColor(savedInstanceState.getInt("mapbox_locViewAccuracyTintColor"));
        this.setAccuracyThreshold(savedInstanceState.getFloat("mapbox_locViewAccuracyThreshold"));
        this.setPadding(savedInstanceState.getIntArray("mapbox_locViewPadding"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.myLocationView.setEnabled(enabled);
    }

    public void setForegroundDrawable(Drawable foregroundDrawable, Drawable foregroundBearingDrawable) {
        this.foregroundDrawable = foregroundDrawable;
        this.foregroundBearingDrawable = foregroundBearingDrawable;
        this.myLocationView.setForegroundDrawables(foregroundDrawable, foregroundBearingDrawable);
        this.myLocationView.setForegroundDrawableTint(this.foregroundTintColor);
    }

    public Drawable getForegroundDrawable() {
        return this.foregroundDrawable;
    }

    public Drawable getForegroundBearingDrawable() {
        return this.foregroundBearingDrawable;
    }

    public void setForegroundTintColor(@ColorInt int foregroundTintColor) {
        this.foregroundTintColor = foregroundTintColor;
        this.myLocationView.setForegroundDrawableTint(foregroundTintColor);
    }

    public int getForegroundTintColor() {
        return this.foregroundTintColor;
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable, int[] padding) {
        this.backgroundDrawable = backgroundDrawable;
        this.backgroundOffset = padding;
        if (padding != null && padding.length == 4) {
            this.myLocationView.setShadowDrawable(backgroundDrawable, padding[0], padding[1], padding[2], padding[3]);
        } else {
            this.myLocationView.setShadowDrawable(backgroundDrawable);
        }
        this.myLocationView.setShadowDrawableTint(this.backgroundTintColor);
    }

    public Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    public void setBackgroundTintColor(@ColorInt int backgroundTintColor) {
        this.backgroundTintColor = backgroundTintColor;
        this.myLocationView.setShadowDrawableTint(backgroundTintColor);
    }

    public int getBackgroundTintColor() {
        return this.backgroundTintColor;
    }

    public int[] getBackgroundOffset() {
        return this.backgroundOffset;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.padding = new int[]{left, top, right, bottom};
        this.setPadding(this.padding);
    }

    private void setPadding(int[] padding) {
        this.myLocationView.setContentPadding(padding);
        this.projection.invalidateContentPadding(padding);
        this.invalidateFocalPointForTracking(this.myLocationView);
    }

    public int[] getPadding() {
        return this.padding;
    }

    public int getAccuracyAlpha() {
        return this.accuracyAlpha;
    }

    public void setAccuracyAlpha(@IntRange(from=0L, to=255L) int accuracyAlpha) {
        this.accuracyAlpha = accuracyAlpha;
        this.myLocationView.setAccuracyAlpha(accuracyAlpha);
    }

    public int getAccuracyTintColor() {
        return this.accuracyTintColor;
    }

    public void setAccuracyTintColor(@ColorInt int accuracyTintColor) {
        this.accuracyTintColor = accuracyTintColor;
        this.myLocationView.setAccuracyTint(accuracyTintColor);
    }

    public float getAccuracyThreshold() {
        return this.accuracyThreshold;
    }

    public void setAccuracyThreshold(float accuracyThreshold) {
        this.accuracyThreshold = accuracyThreshold;
        this.myLocationView.setAccuracyThreshold(accuracyThreshold);
    }

    public void setTilt(double tilt) {
        this.myLocationView.setTilt(tilt);
    }

    private void invalidateFocalPointForTracking(MyLocationView myLocationView) {
        if (myLocationView.getMyLocationTrackingMode() != 0) {
            this.focalPointChangeListener.onFocalPointChanged(myLocationView.getCenter());
        } else {
            this.focalPointChangeListener.onFocalPointChanged(null);
        }
    }
}

