/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.ShoveGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapEventFactory;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.Events;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.utils.MathUtils;
import java.util.concurrent.CopyOnWriteArrayList;

final class MapGestureDetector {
    private final Transform transform;
    private final Projection projection;
    private final UiSettings uiSettings;
    private final TrackingSettings trackingSettings;
    private final AnnotationManager annotationManager;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private GestureDetectorCompat gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private RotateGestureDetector rotateGestureDetector;
    private ShoveGestureDetector shoveGestureDetector;
    private MapboxMap.OnMapClickListener onMapClickListener;
    private MapboxMap.OnMapLongClickListener onMapLongClickListener;
    private MapboxMap.OnFlingListener onFlingListener;
    private MapboxMap.OnScrollListener onScrollListener;
    private final CopyOnWriteArrayList<MapboxMap.OnMapClickListener> onMapClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnMapLongClickListener> onMapLongClickListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnFlingListener> onFlingListenerList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnScrollListener> onScrollListenerList = new CopyOnWriteArrayList();
    private PointF focalPoint;
    private boolean twoTap;
    private boolean quickZoom;
    private boolean tiltGestureOccurred;
    private boolean scrollGestureOccurred;
    private boolean scaleGestureOccurred;
    private boolean recentScaleGestureOccurred;
    private long scaleBeginTime;
    private boolean scaleAnimating;
    private boolean rotateAnimating;
    private VelocityTracker velocityTracker;
    private boolean wasZoomingIn;
    private boolean wasClockwiseRotating;
    private boolean rotateGestureOccurred;

    MapGestureDetector(Context context, Transform transform, Projection projection, UiSettings uiSettings, TrackingSettings trackingSettings, AnnotationManager annotationManager, CameraChangeDispatcher cameraChangeDispatcher) {
        this.annotationManager = annotationManager;
        this.transform = transform;
        this.projection = projection;
        this.uiSettings = uiSettings;
        this.trackingSettings = trackingSettings;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        if (context != null) {
            this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
            this.gestureDetector.setIsLongpressEnabled(true);
            this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
            ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.scaleGestureDetector, (boolean)true);
            this.rotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
            this.shoveGestureDetector = new ShoveGestureDetector(context, new ShoveGestureListener());
        }
    }

    void setFocalPoint(PointF focalPoint) {
        if (focalPoint == null && this.uiSettings.getFocalPoint() != null) {
            focalPoint = this.uiSettings.getFocalPoint();
        }
        this.focalPoint = focalPoint;
    }

    @Nullable
    PointF getFocalPoint() {
        return this.focalPoint;
    }

    boolean onTouchEvent(MotionEvent event) {
        if (event == null) {
            return false;
        }
        if (event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.scaleGestureDetector.onTouchEvent(event);
        this.rotateGestureDetector.onTouchEvent(event);
        this.shoveGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                } else {
                    this.velocityTracker.clear();
                }
                this.velocityTracker.addMovement(event);
                this.recentScaleGestureOccurred = false;
                this.transform.setGestureInProgress(true);
                break;
            }
            case 5: {
                boolean bl = this.twoTap = event.getPointerCount() == 2 && this.uiSettings.isZoomGesturesEnabled();
                if (!this.twoTap || !this.isZoomValid(this.transform)) break;
                MapEventFactory mapEventFactory = new MapEventFactory();
                LatLng latLng = this.projection.fromScreenLocation(new PointF(event.getX(), event.getY()));
                MapState twoFingerTap = new MapState(latLng.getLatitude(), latLng.getLongitude(), this.transform.getZoom());
                twoFingerTap.setGesture("TwoFingerTap");
                Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, twoFingerTap));
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                boolean inProgress;
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean bl = inProgress = this.rotateGestureDetector.isInProgress() || this.scaleGestureDetector.isInProgress() || this.shoveGestureDetector.isInProgress();
                if (this.twoTap && isTap && !inProgress) {
                    if (this.focalPoint != null) {
                        this.transform.zoom(false, this.focalPoint);
                    } else {
                        PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                        this.transform.zoom(false, focalPoint);
                    }
                    this.twoTap = false;
                    return true;
                }
                if (this.scrollGestureOccurred) {
                    if (this.isZoomValid(this.transform)) {
                        MapEventFactory mapEventFactory = new MapEventFactory();
                        LatLng latLng = this.projection.fromScreenLocation(new PointF(event.getX(), event.getY()));
                        MapState dragend = new MapState(latLng.getLatitude(), latLng.getLongitude(), this.transform.getZoom());
                        Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_DRAGEND, dragend));
                    }
                    this.scrollGestureOccurred = false;
                    if (!this.scaleAnimating && !this.rotateAnimating) {
                        this.cameraChangeDispatcher.onCameraIdle();
                    }
                }
                this.twoTap = false;
                this.transform.setGestureInProgress(false);
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                }
                this.velocityTracker = null;
                break;
            }
            case 3: {
                this.twoTap = false;
                this.transform.setGestureInProgress(false);
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                }
                this.velocityTracker = null;
                break;
            }
            case 2: {
                if (this.velocityTracker == null) break;
                this.velocityTracker.addMovement(event);
                this.velocityTracker.computeCurrentVelocity(1000);
            }
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.uiSettings.isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.transform.zoomBy(scrollDist, event.getX(), event.getY());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    void notifyOnMapClickListeners(PointF tapPoint) {
        if (this.onMapClickListener != null) {
            this.onMapClickListener.onMapClick(this.projection.fromScreenLocation(tapPoint));
        }
        for (MapboxMap.OnMapClickListener listener : this.onMapClickListenerList) {
            listener.onMapClick(this.projection.fromScreenLocation(tapPoint));
        }
    }

    void notifyOnMapLongClickListeners(PointF longClickPoint) {
        if (this.onMapLongClickListener != null) {
            this.onMapLongClickListener.onMapLongClick(this.projection.fromScreenLocation(longClickPoint));
        }
        for (MapboxMap.OnMapLongClickListener listener : this.onMapLongClickListenerList) {
            listener.onMapLongClick(this.projection.fromScreenLocation(longClickPoint));
        }
    }

    void notifyOnFlingListeners() {
        if (this.onFlingListener != null) {
            this.onFlingListener.onFling();
        }
        for (MapboxMap.OnFlingListener listener : this.onFlingListenerList) {
            listener.onFling();
        }
    }

    void notifyOnScrollListeners() {
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll();
        }
        for (MapboxMap.OnScrollListener listener : this.onScrollListenerList) {
            listener.onScroll();
        }
    }

    void setOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListener = onMapClickListener;
    }

    void setOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListener = onMapLongClickListener;
    }

    void setOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListener = onFlingListener;
    }

    void setOnScrollListener(MapboxMap.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    void addOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.add(onMapClickListener);
    }

    void removeOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListenerList.remove(onMapClickListener);
    }

    void addOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.add(onMapLongClickListener);
    }

    void removeOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListenerList.remove(onMapLongClickListener);
    }

    void addOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.add(onFlingListener);
    }

    void removeOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListenerList.remove(onFlingListener);
    }

    void addOnScrollListener(MapboxMap.OnScrollListener onScrollListener) {
        this.onScrollListenerList.add(onScrollListener);
    }

    void removeOnScrollListener(MapboxMap.OnScrollListener onScrollListener) {
        this.onScrollListenerList.remove(onScrollListener);
    }

    private boolean isZoomValid(Transform transform) {
        if (transform == null) {
            return false;
        }
        double mapZoom = transform.getZoom();
        return !(mapZoom < 0.0) && !(mapZoom > 25.5);
    }

    private class ShoveGestureListener
    implements ShoveGestureDetector.OnShoveGestureListener {
        private long beginTime = 0L;
        private float totalDelta = 0.0f;

        private ShoveGestureListener() {
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
            this.beginTime = 0L;
            this.totalDelta = 0.0f;
            MapGestureDetector.this.tiltGestureOccurred = false;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!MapGestureDetector.this.tiltGestureOccurred && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            this.totalDelta += detector.getShovePixelsDelta();
            if (!MapGestureDetector.this.tiltGestureOccurred && (this.totalDelta > 10.0f || this.totalDelta < -10.0f)) {
                MapGestureDetector.this.tiltGestureOccurred = true;
                this.beginTime = detector.getEventTime();
                if (MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) {
                    MapEventFactory mapEventFactory = new MapEventFactory();
                    LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(detector.getFocusX(), detector.getFocusY()));
                    MapState pitch = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                    pitch.setGesture("Pitch");
                    Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, pitch));
                }
            }
            if (!MapGestureDetector.this.tiltGestureOccurred) {
                return false;
            }
            double pitch = MapGestureDetector.this.transform.getTilt();
            pitch -= 0.1 * (double)detector.getShovePixelsDelta();
            pitch = Math.max(0.0, Math.min(60.0, pitch));
            MapGestureDetector.this.transform.setTilt(pitch);
            return true;
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        private static final float ROTATE_INVOKE_ANGLE = 15.3f;
        private static final float ROTATE_LIMITATION_ANGLE = 3.35f;
        private static final float ROTATE_LIMITATION_DURATION = 6.1974998f;
        private long beginTime = 0L;
        private boolean started = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (!MapGestureDetector.this.trackingSettings.isRotateGestureCurrentlyEnabled()) {
                return false;
            }
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            this.beginTime = detector.getEventTime();
            return true;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (!MapGestureDetector.this.trackingSettings.isRotateGestureCurrentlyEnabled() || MapGestureDetector.this.tiltGestureOccurred) {
                return false;
            }
            float angle = detector.getRotationDegreesDelta();
            if (Math.abs(angle) >= 15.3f) {
                if (MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) {
                    MapEventFactory mapEventFactory = new MapEventFactory();
                    LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(detector.getFocusX(), detector.getFocusY()));
                    MapState rotation = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                    rotation.setGesture("Rotation");
                    Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, rotation));
                }
                this.started = true;
            }
            if (!this.started) {
                return false;
            }
            MapGestureDetector.this.wasClockwiseRotating = detector.getRotationDegreesDelta() > 0.0f;
            if (MapGestureDetector.this.scaleBeginTime != 0L) {
                MapGestureDetector.this.rotateGestureOccurred = true;
            }
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, true, false);
            double bearing = MapGestureDetector.this.transform.getRawBearing() + (double)angle;
            if (MapGestureDetector.this.focalPoint != null) {
                MapGestureDetector.this.transform.setBearing(bearing, ((MapGestureDetector)MapGestureDetector.this).focalPoint.x, ((MapGestureDetector)MapGestureDetector.this).focalPoint.y);
            } else {
                MapGestureDetector.this.transform.setBearing(bearing, detector.getFocusX(), detector.getFocusY());
            }
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            long interval = detector.getEventTime() - this.beginTime;
            if (!this.started && interval <= (long)ViewConfiguration.getTapTimeout() || MapGestureDetector.this.scaleAnimating || interval > 500L) {
                this.reset();
                return;
            }
            double angularVelocity = this.calculateVelocityVector(detector);
            if (Math.abs(angularVelocity) > 0.001 && MapGestureDetector.this.rotateGestureOccurred && !MapGestureDetector.this.rotateAnimating) {
                this.animateRotateVelocity();
            } else if (!MapGestureDetector.this.rotateAnimating) {
                this.reset();
            }
        }

        private void reset() {
            this.beginTime = 0L;
            this.started = false;
            MapGestureDetector.this.rotateAnimating = false;
            MapGestureDetector.this.rotateGestureOccurred = false;
            if (!MapGestureDetector.this.twoTap) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraIdle();
            }
        }

        private void animateRotateVelocity() {
            MapGestureDetector.this.rotateAnimating = true;
            double currentRotation = MapGestureDetector.this.transform.getRawBearing();
            double rotateAdditionDegrees = this.calculateVelocityInDegrees();
            this.createAnimator(currentRotation, rotateAdditionDegrees).start();
        }

        private double calculateVelocityVector(RotateGestureDetector detector) {
            return (double)(detector.getFocusX() * MapGestureDetector.this.velocityTracker.getYVelocity() + detector.getFocusY() * MapGestureDetector.this.velocityTracker.getXVelocity()) / (Math.pow(detector.getFocusX(), 2.0) + Math.pow(detector.getFocusY(), 2.0));
        }

        private double calculateVelocityInDegrees() {
            double angleRadians = Math.atan2(MapGestureDetector.this.velocityTracker.getXVelocity(), MapGestureDetector.this.velocityTracker.getYVelocity());
            double angle = angleRadians / (Math.PI / 180);
            if (angle <= 0.0) {
                angle += 360.0;
            }
            angle /= (double)3.35f;
            if (!MapGestureDetector.this.wasClockwiseRotating) {
                angle = -angle;
            }
            return angle;
        }

        private Animator createAnimator(double currentRotation, double rotateAdditionDegrees) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{(float)currentRotation, (float)(currentRotation + rotateAdditionDegrees)});
            animator.setDuration((long)(Math.abs(rotateAdditionDegrees) * 6.197499752044678));
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    MapGestureDetector.this.transform.setBearing(((Float)animation.getAnimatedValue()).floatValue());
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(3);
                }

                public void onAnimationCancel(Animator animation) {
                    RotateGestureListener.this.reset();
                }

                public void onAnimationEnd(Animator animation) {
                    RotateGestureListener.this.reset();
                }
            });
            return animator;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private static final int ANIMATION_TIME_MULTIPLIER = 77;
        private static final double ZOOM_DISTANCE_DIVIDER = 5.0;
        private float scaleFactor = 1.0f;
        private PointF scalePointBegin;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.recentScaleGestureOccurred = true;
            this.scalePointBegin = new PointF(detector.getFocusX(), detector.getFocusY());
            MapGestureDetector.this.scaleBeginTime = detector.getEventTime();
            if (MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) {
                MapEventFactory mapEventFactory = new MapEventFactory();
                LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(detector.getFocusX(), detector.getFocusY()));
                MapState pinch = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                pinch.setGesture("Pinch");
                Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, pinch));
            }
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return super.onScale(detector);
            }
            MapGestureDetector.this.wasZoomingIn = Math.log(detector.getScaleFactor()) / Math.log(1.5707963267948966) > 0.0;
            if (MapGestureDetector.this.tiltGestureOccurred) {
                return false;
            }
            long time = detector.getEventTime();
            long interval = time - MapGestureDetector.this.scaleBeginTime;
            if (!MapGestureDetector.this.scaleGestureOccurred && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            this.scaleFactor *= detector.getScaleFactor();
            if (this.scaleFactor > 1.1f || this.scaleFactor < 0.9f) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                MapGestureDetector.this.scaleGestureOccurred = true;
            }
            if (!MapGestureDetector.this.scaleGestureOccurred) {
                return false;
            }
            if (!MapGestureDetector.this.quickZoom && !MapGestureDetector.this.twoTap) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            }
            MapGestureDetector.this.quickZoom = !MapGestureDetector.this.twoTap;
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(!MapGestureDetector.this.quickZoom, false, false);
            if (MapGestureDetector.this.focalPoint != null) {
                MapGestureDetector.this.transform.zoomBy(Math.log(detector.getScaleFactor()) / Math.log(1.5707963267948966), ((MapGestureDetector)MapGestureDetector.this).focalPoint.x, ((MapGestureDetector)MapGestureDetector.this).focalPoint.y);
            } else if (MapGestureDetector.this.quickZoom) {
                MapGestureDetector.this.cameraChangeDispatcher.onCameraMove();
                float scaleFactor = detector.getScaleFactor();
                double zoomBy = Math.log(scaleFactor) / Math.log(1.5707963267948966);
                boolean negative = zoomBy < 0.0;
                zoomBy = MathUtils.clamp(Math.abs(zoomBy), 0.0, (double)0.45f);
                MapGestureDetector.this.transform.zoomBy(negative ? -zoomBy : zoomBy, MapGestureDetector.this.uiSettings.getWidth() / 2.0f, MapGestureDetector.this.uiSettings.getHeight() / 2.0f);
                MapGestureDetector.this.recentScaleGestureOccurred = true;
            } else {
                MapGestureDetector.this.transform.zoomBy(Math.log(detector.getScaleFactor()) / Math.log(1.5707963267948966), this.scalePointBegin.x, this.scalePointBegin.y);
            }
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (MapGestureDetector.this.velocityTracker == null) {
                return;
            }
            if (MapGestureDetector.this.rotateGestureOccurred || MapGestureDetector.this.quickZoom) {
                this.reset();
                return;
            }
            double velocityXY = Math.abs(MapGestureDetector.this.velocityTracker.getYVelocity()) + Math.abs(MapGestureDetector.this.velocityTracker.getXVelocity());
            if (velocityXY > 500.0) {
                MapGestureDetector.this.scaleAnimating = true;
                double zoomAddition = this.calculateScale(velocityXY);
                double currentZoom = MapGestureDetector.this.transform.getRawZoom();
                long animationTime = (long)(Math.log(velocityXY) * 77.0);
                this.createScaleAnimator(currentZoom, zoomAddition, animationTime).start();
            } else if (!MapGestureDetector.this.scaleAnimating) {
                this.reset();
            }
        }

        private void reset() {
            MapGestureDetector.this.scaleAnimating = false;
            MapGestureDetector.this.scaleGestureOccurred = false;
            MapGestureDetector.this.scaleBeginTime = 0L;
            this.scaleFactor = 1.0f;
            MapGestureDetector.this.cameraChangeDispatcher.onCameraIdle();
        }

        private double calculateScale(double velocityXY) {
            double zoomAddition = (float)(Math.log(velocityXY) / 5.0);
            if (!MapGestureDetector.this.wasZoomingIn) {
                zoomAddition = -zoomAddition;
            }
            return zoomAddition;
        }

        private Animator createScaleAnimator(double currentZoom, double zoomAddition, long animationTime) {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{(float)currentZoom, (float)(currentZoom + zoomAddition)});
            animator.setDuration(animationTime);
            animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    MapGestureDetector.this.transform.setZoom(((Float)animation.getAnimatedValue()).floatValue(), ScaleGestureListener.this.scalePointBegin, 0L, true);
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(3);
                }

                public void onAnimationCancel(Animator animation) {
                    ScaleGestureListener.this.reset();
                }

                public void onAnimationEnd(Animator animation) {
                    ScaleGestureListener.this.reset();
                }
            });
            return animator;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent event) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() || !MapGestureDetector.this.uiSettings.isDoubleTapGesturesEnabled()) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (MapGestureDetector.this.quickZoom) {
                        MapGestureDetector.this.cameraChangeDispatcher.onCameraIdle();
                        MapGestureDetector.this.quickZoom = false;
                        break;
                    }
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                    if (MapGestureDetector.this.focalPoint != null) {
                        MapGestureDetector.this.transform.zoom(true, MapGestureDetector.this.focalPoint);
                    } else {
                        MapGestureDetector.this.transform.zoom(true, new PointF(e.getX(), e.getY()));
                    }
                    if (!MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) break;
                    MapEventFactory mapEventFactory = new MapEventFactory();
                    LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(e.getX(), e.getY()));
                    MapState doubleTap = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                    doubleTap.setGesture("DoubleTap");
                    Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, doubleTap));
                }
            }
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            MapGestureDetector.this.transform.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            PointF tapPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            boolean tapHandled = MapGestureDetector.this.annotationManager.onTap(tapPoint);
            if (!tapHandled) {
                if (MapGestureDetector.this.uiSettings.isDeselectMarkersOnTap()) {
                    MapGestureDetector.this.annotationManager.deselectMarkers();
                }
                MapGestureDetector.this.notifyOnMapClickListeners(tapPoint);
            }
            if (MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) {
                MapEventFactory mapEventFactory = new MapEventFactory();
                LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(motionEvent.getX(), motionEvent.getY()));
                MapState singleTap = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                singleTap.setGesture("SingleTap");
                Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, singleTap));
            }
            return true;
        }

        public void onLongPress(MotionEvent motionEvent) {
            PointF longClickPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            if (!MapGestureDetector.this.quickZoom) {
                MapGestureDetector.this.notifyOnMapLongClickListeners(longClickPoint);
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapGestureDetector.this.trackingSettings.isScrollGestureCurrentlyEnabled() || MapGestureDetector.this.recentScaleGestureOccurred) {
                return false;
            }
            float screenDensity = MapGestureDetector.this.uiSettings.getPixelRatio();
            double velocityXY = Math.hypot(velocityX / screenDensity, velocityY / screenDensity);
            if (velocityXY < 1000.0) {
                return false;
            }
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, false, false);
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
            double tilt = MapGestureDetector.this.transform.getTilt();
            double tiltFactor = 1.5 + (tilt != 0.0 ? tilt / 10.0 : 0.0);
            double offsetX = (double)velocityX / tiltFactor / (double)screenDensity;
            double offsetY = (double)velocityY / tiltFactor / (double)screenDensity;
            long animationTime = (long)(velocityXY / 7.0 / tiltFactor + 150.0);
            MapGestureDetector.this.transform.moveBy(offsetX, offsetY, animationTime);
            MapGestureDetector.this.notifyOnFlingListeners();
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapGestureDetector.this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                return false;
            }
            if (MapGestureDetector.this.tiltGestureOccurred) {
                return false;
            }
            if (!MapGestureDetector.this.scrollGestureOccurred) {
                MapGestureDetector.this.scrollGestureOccurred = true;
                if (!MapGestureDetector.this.scaleGestureOccurred) {
                    MapGestureDetector.this.transform.cancelTransitions();
                    MapGestureDetector.this.cameraChangeDispatcher.onCameraMoveStarted(1);
                }
                if (MapGestureDetector.this.isZoomValid(MapGestureDetector.this.transform)) {
                    MapEventFactory mapEventFactory = new MapEventFactory();
                    LatLng latLng = MapGestureDetector.this.projection.fromScreenLocation(new PointF(e1.getX(), e1.getY()));
                    MapState pan = new MapState(latLng.getLatitude(), latLng.getLongitude(), MapGestureDetector.this.transform.getZoom());
                    pan.setGesture("Pan");
                    Events.obtainTelemetry().push(mapEventFactory.createMapGestureEvent(Event.Type.MAP_CLICK, pan));
                }
            }
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, false, false);
            MapGestureDetector.this.transform.moveBy(-distanceX, -distanceY, 0L);
            MapGestureDetector.this.notifyOnScrollListeners();
            return true;
        }
    }
}

