/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;

@UiThread
public final class Mapbox {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Mapbox INSTANCE;
    private Context context;
    private String accessToken;
    private Boolean connected;
    private LocationEngine locationEngine;

    @UiThread
    public static synchronized Mapbox getInstance(@NonNull Context context, @NonNull String accessToken) {
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            LocationEngineProvider locationEngineProvider = new LocationEngineProvider(context);
            LocationEngine locationEngine = locationEngineProvider.obtainBestLocationEngineAvailable();
            INSTANCE = new Mapbox(appContext, accessToken, locationEngine);
            locationEngine.setPriority(LocationEnginePriority.NO_POWER);
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    Mapbox(@NonNull Context context, @NonNull String accessToken, LocationEngine locationEngine) {
        this.context = context;
        this.accessToken = accessToken;
        this.locationEngine = locationEngine;
    }

    public static String getAccessToken() {
        Mapbox.validateMapbox();
        Mapbox.validateAccessToken();
        return Mapbox.INSTANCE.accessToken;
    }

    private static void validateMapbox() throws MapboxConfigurationException {
        if (INSTANCE == null) {
            throw new MapboxConfigurationException();
        }
    }

    private static void validateAccessToken() throws MapboxConfigurationException {
        String accessToken = Mapbox.INSTANCE.accessToken;
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("pk.") && !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("sk.")) {
            throw new MapboxConfigurationException();
        }
    }

    public static Context getApplicationContext() {
        return Mapbox.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapbox.INSTANCE.connected = connected;
    }

    public static synchronized Boolean isConnected() {
        if (Mapbox.INSTANCE.connected != null) {
            return Mapbox.INSTANCE.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)Mapbox.INSTANCE.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    @Deprecated
    public static LocationEngine getLocationEngine() {
        return Mapbox.INSTANCE.locationEngine;
    }
}

