/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.Attribution;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

class AttributionDialogManager
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final String MAP_FEEDBACK_URL = "https://www.mapbox.com/map-feedback";
    private static final String MAP_FEEDBACK_LOCATION_FORMAT = "https://www.mapbox.com/map-feedback/#/%f/%f/%d";
    private final Context context;
    private final MapboxMap mapboxMap;
    private String[] attributionTitles;
    private Set<Attribution> attributionSet;

    AttributionDialogManager(@NonNull Context context, @NonNull MapboxMap mapboxMap) {
        this.context = context;
        this.mapboxMap = mapboxMap;
    }

    public void onClick(View view) {
        this.attributionSet = new AttributionBuilder(this.mapboxMap).build();
        boolean isActivityFinishing = false;
        if (this.context instanceof Activity) {
            isActivityFinishing = ((Activity)this.context).isFinishing();
        }
        if (!isActivityFinishing) {
            this.showAttributionDialog();
        }
    }

    private void showAttributionDialog() {
        this.attributionTitles = this.getAttributionTitles();
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionsDialogTitle);
        builder.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.mapbox_attribution_list_item, (Object[])this.attributionTitles), (DialogInterface.OnClickListener)this);
        builder.show();
    }

    private String[] getAttributionTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Attribution attribution : this.attributionSet) {
            titles.add(attribution.getTitle());
        }
        return titles.toArray(new String[titles.size()]);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.isLatestEntry(which)) {
            this.showTelemetryDialog();
        } else {
            this.showMapFeedbackWebPage(which);
        }
    }

    private boolean isLatestEntry(int attributionKeyIndex) {
        return attributionKeyIndex == this.attributionTitles.length - 1;
    }

    private void showTelemetryDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionTelemetryTitle);
        builder.setMessage(R.string.mapbox_attributionTelemetryMessage);
        builder.setPositiveButton(R.string.mapbox_attributionTelemetryPositive, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapboxTelemetry.getInstance().setTelemetryEnabled(true);
                dialog.cancel();
            }
        });
        builder.setNeutralButton(R.string.mapbox_attributionTelemetryNeutral, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AttributionDialogManager.this.showWebPage(AttributionDialogManager.this.context.getResources().getString(R.string.mapbox_telemetryLink));
                dialog.cancel();
            }
        });
        builder.setNegativeButton(R.string.mapbox_attributionTelemetryNegative, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MapboxTelemetry.getInstance().setTelemetryEnabled(false);
                dialog.cancel();
            }
        });
        builder.show();
    }

    private void showMapFeedbackWebPage(int which) {
        Attribution[] attributions = this.attributionSet.toArray(new Attribution[this.attributionSet.size()]);
        String url = attributions[which].getUrl();
        if (url.contains(MAP_FEEDBACK_URL)) {
            url = this.buildMapFeedbackMapUrl(this.mapboxMap.getCameraPosition());
        }
        this.showWebPage(url);
    }

    private String buildMapFeedbackMapUrl(CameraPosition cameraPosition) {
        return cameraPosition != null ? String.format(Locale.getDefault(), MAP_FEEDBACK_LOCATION_FORMAT, cameraPosition.target.getLongitude(), cameraPosition.target.getLatitude(), (int)cameraPosition.zoom) : MAP_FEEDBACK_URL;
    }

    private void showWebPage(@NonNull String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Toast.makeText((Context)this.context, (int)R.string.mapbox_attributionErrorNoBrowser, (int)1).show();
        }
    }

    private static class AttributionBuilder {
        private final MapboxMap mapboxMap;

        AttributionBuilder(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        private Set<Attribution> build() {
            ArrayList<String> attributions = new ArrayList<String>();
            for (Source source : this.mapboxMap.getSources()) {
                attributions.add(source.getAttribution());
            }
            return new AttributionParser.Options().withCopyrightSign(true).withImproveMap(true).withTelemetryAttribution(true).withAttributionData(attributions.toArray(new String[attributions.size()])).build().getAttributions();
        }
    }
}

