/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ZoomButtonsController;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.maps.AnnotationContainer;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.MapKeyListener;
import com.mapbox.mapboxsdk.maps.MapZoomButtonController;
import com.mapbox.mapboxsdk.maps.MapboxEventWrapper;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.MarkerContainer;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.PolygonContainer;
import com.mapbox.mapboxsdk.maps.PolylineContainer;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotationContainer;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.GLSurfaceViewMapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import timber.log.Timber;

public class MapView
extends FrameLayout {
    private final MapCallback mapCallback = new MapCallback();
    private MapboxMap mapboxMap;
    private NativeMapView nativeMapView;
    private MapboxMapOptions mapboxMapOptions;
    private boolean destroyed;
    private MyLocationView myLocationView;
    private CompassView compassView;
    private PointF focalPoint;
    private ImageView attrView;
    private ImageView logoView;
    private MapGestureDetector mapGestureDetector;
    private MapKeyListener mapKeyListener;
    private MapZoomButtonController mapZoomButtonController;
    private Bundle savedInstanceState;
    private final CopyOnWriteArrayList<OnMapChangedListener> onMapChangedListeners = new CopyOnWriteArrayList();
    private MapRenderer mapRenderer;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;
    public static final int DID_FINISH_LOADING_STYLE = 14;
    public static final int SOURCE_DID_CHANGE = 15;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialise(context, options == null ? MapboxMapOptions.createFromAttributes(context, null) : options);
    }

    private void initialise(@NonNull Context context, final @NonNull MapboxMapOptions options) {
        if (this.isInEditMode()) {
            return;
        }
        this.mapboxMapOptions = options;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapbox_mapview_internal, (ViewGroup)this);
        this.compassView = (CompassView)view.findViewById(R.id.compassView);
        this.myLocationView = (MyLocationView)view.findViewById(R.id.userLocationView);
        this.attrView = (ImageView)view.findViewById(R.id.attributionView);
        this.logoView = (ImageView)view.findViewById(R.id.logoView);
        this.setContentDescription(context.getString(R.string.mapbox_mapActionDescription));
        this.setWillNotDraw(false);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    MapView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    MapView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                MapView.this.initialiseDrawingSurface(options);
            }
        });
    }

    private void initialiseMap() {
        Context context = this.getContext();
        this.addOnMapChangedListener(this.mapCallback);
        FocalPointInvalidator focalPointInvalidator = new FocalPointInvalidator();
        focalPointInvalidator.addListener(this.createFocalPointChangeListener());
        RegisterTouchListener registerTouchListener = new RegisterTouchListener();
        CameraZoomInvalidator zoomInvalidator = new CameraZoomInvalidator();
        CameraChangeDispatcher cameraChangeDispatcher = new CameraChangeDispatcher();
        Projection proj = new Projection(this.nativeMapView);
        UiSettings uiSettings = new UiSettings(proj, focalPointInvalidator, this.compassView, this.attrView, (View)this.logoView);
        TrackingSettings trackingSettings = new TrackingSettings(this.myLocationView, uiSettings, focalPointInvalidator, zoomInvalidator);
        MyLocationViewSettings myLocationViewSettings = new MyLocationViewSettings(this.myLocationView, proj, focalPointInvalidator);
        LongSparseArray annotationsArray = new LongSparseArray();
        MarkerViewManager markerViewManager = new MarkerViewManager((ViewGroup)this.findViewById(R.id.markerViewContainer));
        IconManager iconManager = new IconManager(this.nativeMapView);
        AnnotationContainer annotations = new AnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        MarkerContainer markers = new MarkerContainer(this.nativeMapView, this, (LongSparseArray<Annotation>)annotationsArray, iconManager, markerViewManager);
        PolygonContainer polygons = new PolygonContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        PolylineContainer polylines = new PolylineContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        ShapeAnnotationContainer shapeAnnotations = new ShapeAnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        AnnotationManager annotationManager = new AnnotationManager(this.nativeMapView, this, (LongSparseArray<Annotation>)annotationsArray, markerViewManager, iconManager, annotations, markers, polygons, polylines, shapeAnnotations);
        Transform transform = new Transform(this.nativeMapView, annotationManager.getMarkerViewManager(), trackingSettings, cameraChangeDispatcher);
        this.mapboxMap = new MapboxMap(this.nativeMapView, transform, uiSettings, trackingSettings, myLocationViewSettings, proj, registerTouchListener, annotationManager, cameraChangeDispatcher);
        focalPointInvalidator.addListener(this.mapboxMap.createFocalPointChangeListener());
        this.mapCallback.attachMapboxMap(this.mapboxMap);
        this.mapGestureDetector = new MapGestureDetector(context, transform, proj, uiSettings, trackingSettings, annotationManager, cameraChangeDispatcher);
        this.mapKeyListener = new MapKeyListener(transform, trackingSettings, uiSettings);
        this.mapZoomButtonController = new MapZoomButtonController(new ZoomButtonsController((View)this));
        MapZoomControllerListener zoomListener = new MapZoomControllerListener(this.mapGestureDetector, uiSettings, transform, cameraChangeDispatcher, this.getWidth(), this.getHeight());
        this.mapZoomButtonController.bind(uiSettings, zoomListener);
        this.compassView.injectCompassAnimationListener(this.createCompassAnimationListener(cameraChangeDispatcher));
        this.compassView.setOnClickListener(this.createCompassClickListener(cameraChangeDispatcher));
        this.myLocationView.setMapboxMap(this.mapboxMap);
        this.attrView.setOnClickListener((View.OnClickListener)new AttributionDialogManager(context, this.mapboxMap));
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.nativeMapView.setReachability(ConnectivityReceiver.instance(context).isConnected(context));
        if (this.savedInstanceState == null) {
            this.mapboxMap.initialise(context, this.mapboxMapOptions);
        } else {
            this.mapboxMap.onRestoreInstanceState(this.savedInstanceState);
        }
    }

    private FocalPointChangeListener createFocalPointChangeListener() {
        return new FocalPointChangeListener(){

            @Override
            public void onFocalPointChanged(PointF pointF) {
                MapView.this.focalPoint = pointF;
            }
        };
    }

    private MapboxMap.OnCompassAnimationListener createCompassAnimationListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new MapboxMap.OnCompassAnimationListener(){

            @Override
            public void onCompassAnimation() {
                cameraChangeDispatcher.onCameraMove();
            }

            @Override
            public void onCompassAnimationFinished() {
                MapView.this.compassView.isAnimating(false);
                cameraChangeDispatcher.onCameraIdle();
            }
        };
    }

    private View.OnClickListener createCompassClickListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (MapView.this.mapboxMap != null && MapView.this.compassView != null) {
                    if (MapView.this.focalPoint != null) {
                        MapView.this.mapboxMap.setFocalBearing(0.0, ((MapView)MapView.this).focalPoint.x, ((MapView)MapView.this).focalPoint.y, 150L);
                    } else {
                        MapView.this.mapboxMap.setFocalBearing(0.0, MapView.this.mapboxMap.getWidth() / 2.0f, MapView.this.mapboxMap.getHeight() / 2.0f, 150L);
                    }
                    cameraChangeDispatcher.onCameraMoveStarted(3);
                    MapView.this.compassView.isAnimating(true);
                    MapView.this.compassView.postDelayed(MapView.this.compassView, 650L);
                }
            }
        };
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            MapboxTelemetry.getInstance().pushEvent(MapboxEventWrapper.buildMapLoadEvent());
        } else if (savedInstanceState.getBoolean("mapbox_savedState")) {
            this.savedInstanceState = savedInstanceState;
        }
    }

    private void initialiseDrawingSurface(MapboxMapOptions options) {
        if (options.getTextureMode()) {
            TextureView textureView = new TextureView(this.getContext());
            this.mapRenderer = new TextureViewMapRenderer(this.getContext(), textureView, options.getLocalIdeographFontFamily()){

                @Override
                protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.initRenderSurface();
                    super.onSurfaceCreated(gl, config);
                }
            };
            this.addView((View)textureView, 0);
        } else {
            GLSurfaceView glSurfaceView = (GLSurfaceView)this.findViewById(R.id.surfaceView);
            glSurfaceView.setZOrderMediaOverlay(this.mapboxMapOptions.getRenderSurfaceOnTop());
            this.mapRenderer = new GLSurfaceViewMapRenderer(this.getContext(), glSurfaceView, options.getLocalIdeographFontFamily()){

                @Override
                public void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.initRenderSurface();
                    super.onSurfaceCreated(gl, config);
                }
            };
            glSurfaceView.setVisibility(0);
        }
        this.nativeMapView = new NativeMapView(this, this.mapRenderer);
        this.nativeMapView.resizeView(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    private void initRenderSurface() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MapView.this.destroyed && MapView.this.mapboxMap == null) {
                    MapView.this.initialiseMap();
                    MapView.this.mapboxMap.onStart();
                }
            }
        });
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mapboxMap != null) {
            outState.putBoolean("mapbox_savedState", true);
            this.mapboxMap.onSaveInstanceState(outState);
        }
    }

    @UiThread
    public void onStart() {
        ConnectivityReceiver.instance(this.getContext()).activate();
        FileSource.getInstance(this.getContext()).activate();
        if (this.mapboxMap != null) {
            this.mapboxMap.onStart();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStart();
        }
    }

    @UiThread
    public void onResume() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onResume();
        }
    }

    @UiThread
    public void onPause() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onPause();
        }
    }

    @UiThread
    public void onStop() {
        if (this.mapboxMap != null) {
            this.mapboxMap.onStop();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStop();
        }
        ConnectivityReceiver.instance(this.getContext()).deactivate();
        FileSource.getInstance(this.getContext()).deactivate();
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.mapCallback.clearOnMapReadyCallbacks();
        if (this.nativeMapView != null) {
            this.nativeMapView.destroy();
            this.nativeMapView = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onDestroy();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isMapInitialized() || !this.isZoomButtonControllerInitialized()) {
            return super.onTouchEvent(event);
        }
        if (event.getAction() == 0) {
            this.mapZoomButtonController.setVisible(true);
        }
        return this.mapGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyLongPress(keyCode, event) || super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyUp(keyCode, event) || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return this.mapKeyListener.onTrackballEvent(event) || super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.mapGestureDetector == null) {
            return super.onGenericMotionEvent(event);
        }
        return this.mapGestureDetector.onGenericMotionEvent(event) || super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isZoomButtonControllerInitialized()) {
            return super.onHoverEvent(event);
        }
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                this.mapZoomButtonController.setVisible(true);
                return true;
            }
            case 10: {
                this.mapZoomButtonController.setVisible(false);
                return true;
            }
        }
        return false;
    }

    @UiThread
    public void onLowMemory() {
        this.nativeMapView.onLowMemory();
    }

    public void setStyleUrl(@NonNull String url) {
        if (this.destroyed) {
            return;
        }
        if (!this.isMapInitialized()) {
            this.mapboxMapOptions.styleUrl(url);
            return;
        }
        this.nativeMapView.setStyleUrl(url);
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (this.destroyed) {
            return;
        }
        if (!this.isInEditMode() && this.isMapInitialized()) {
            this.nativeMapView.resizeView(width, height);
        }
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isZoomButtonControllerInitialized()) {
            this.mapZoomButtonController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.isZoomButtonControllerInitialized()) {
            this.mapZoomButtonController.setVisible(visibility == 0);
        }
    }

    void onMapChange(int rawChange) {
        for (OnMapChangedListener onMapChangedListener : this.onMapChangedListeners) {
            try {
                onMapChangedListener.onMapChanged(rawChange);
            }
            catch (RuntimeException err) {
                Timber.e((Throwable)err, (String)"Exception in MapView.OnMapChangedListener", (Object[])new Object[0]);
            }
        }
    }

    public void addOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.onMapChangedListeners.add(listener);
        }
    }

    public void removeOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.onMapChangedListeners.remove(listener);
        }
    }

    @UiThread
    public void getMapAsync(OnMapReadyCallback callback) {
        if (!this.mapCallback.isInitialLoad() && callback != null) {
            callback.onMapReady(this.mapboxMap);
        } else if (callback != null) {
            this.mapCallback.addOnMapReadyCallback(callback);
        }
    }

    private boolean isMapInitialized() {
        return this.nativeMapView != null;
    }

    private boolean isZoomButtonControllerInitialized() {
        return this.mapZoomButtonController != null;
    }

    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    private static class MapCallback
    implements OnMapChangedListener {
        private MapboxMap mapboxMap;
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
        private boolean initialLoad = true;

        private MapCallback() {
        }

        void attachMapboxMap(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        @Override
        public void onMapChanged(int change) {
            if (change == 14 && this.initialLoad) {
                this.initialLoad = false;
                this.mapboxMap.onPreMapReady();
                this.onMapReady();
                this.mapboxMap.onPostMapReady();
            } else if (change == 9 || change == 10) {
                this.mapboxMap.onUpdateFullyRendered();
            } else if (change == 2 || change == 3 || change == 6) {
                this.mapboxMap.onUpdateRegionChange();
            }
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator = this.onMapReadyCallbackList.iterator();
                while (iterator.hasNext()) {
                    OnMapReadyCallback callback = iterator.next();
                    callback.onMapReady(this.mapboxMap);
                    iterator.remove();
                }
            }
        }

        boolean isInitialLoad() {
            return this.initialLoad;
        }

        void addOnMapReadyCallback(OnMapReadyCallback callback) {
            this.onMapReadyCallbackList.add(callback);
        }

        void clearOnMapReadyCallbacks() {
            this.onMapReadyCallbackList.clear();
        }
    }

    private class CameraZoomInvalidator
    implements TrackingSettings.CameraZoomInvalidator {
        private CameraZoomInvalidator() {
        }

        @Override
        public void zoomTo(double zoomLevel) {
            Transform transform = MapView.this.mapboxMap.getTransform();
            double currentZoomLevel = transform.getCameraPosition().zoom;
            if (currentZoomLevel < zoomLevel) {
                this.setZoom(zoomLevel, MapView.this.mapGestureDetector.getFocalPoint(), transform);
            }
        }

        private void setZoom(double zoomLevel, @Nullable PointF focalPoint, @NonNull Transform transform) {
            if (focalPoint != null) {
                transform.setZoom(zoomLevel, focalPoint);
            } else {
                PointF centerPoint = new PointF((float)(MapView.this.getMeasuredWidth() / 2), (float)(MapView.this.getMeasuredHeight() / 2));
                transform.setZoom(zoomLevel, centerPoint);
            }
        }
    }

    private static class MapZoomControllerListener
    implements ZoomButtonsController.OnZoomListener {
        private final MapGestureDetector mapGestureDetector;
        private final UiSettings uiSettings;
        private final Transform transform;
        private final CameraChangeDispatcher cameraChangeDispatcher;
        private final float mapWidth;
        private final float mapHeight;

        MapZoomControllerListener(MapGestureDetector detector, UiSettings uiSettings, Transform transform, CameraChangeDispatcher dispatcher, float mapWidth, float mapHeight) {
            this.mapGestureDetector = detector;
            this.uiSettings = uiSettings;
            this.transform = transform;
            this.cameraChangeDispatcher = dispatcher;
            this.mapWidth = mapWidth;
            this.mapHeight = mapHeight;
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (this.uiSettings.isZoomGesturesEnabled()) {
                this.cameraChangeDispatcher.onCameraMoveStarted(3);
                this.onZoom(zoomIn, this.mapGestureDetector.getFocalPoint());
            }
        }

        private void onZoom(boolean zoomIn, @Nullable PointF focalPoint) {
            if (focalPoint != null) {
                this.transform.zoom(zoomIn, focalPoint);
            } else {
                PointF centerPoint = new PointF(this.mapWidth / 2.0f, this.mapHeight / 2.0f);
                this.transform.zoom(zoomIn, centerPoint);
            }
        }
    }

    private class RegisterTouchListener
    implements MapboxMap.OnRegisterTouchListener {
        private RegisterTouchListener() {
        }

        @Override
        public void onSetMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapClickListener(listener);
        }

        @Override
        public void onAddMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapClickListener(listener);
        }

        @Override
        public void onRemoveMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapClickListener(listener);
        }

        @Override
        public void onSetMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapLongClickListener(listener);
        }

        @Override
        public void onAddMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapLongClickListener(listener);
        }

        @Override
        public void onRemoveMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapLongClickListener(listener);
        }

        @Override
        public void onSetScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.setOnScrollListener(listener);
        }

        @Override
        public void onAddScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.addOnScrollListener(listener);
        }

        @Override
        public void onRemoveScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.removeOnScrollListener(listener);
        }

        @Override
        public void onSetFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.setOnFlingListener(listener);
        }

        @Override
        public void onAddFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.addOnFlingListener(listener);
        }

        @Override
        public void onRemoveFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.removeOnFlingListener(listener);
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final List<FocalPointChangeListener> focalPointChangeListeners = new ArrayList<FocalPointChangeListener>();

        private FocalPointInvalidator() {
        }

        void addListener(FocalPointChangeListener focalPointChangeListener) {
            this.focalPointChangeListeners.add(focalPointChangeListener);
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            for (FocalPointChangeListener focalPointChangeListener : this.focalPointChangeListeners) {
                focalPointChangeListener.onFocalPointChanged(pointF);
            }
        }
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }
}

