/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.concurrent.CopyOnWriteArrayList;

class CameraChangeDispatcher
implements MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnCameraMoveCanceledListener,
MapboxMap.OnCameraIdleListener {
    private final Handler handler = new Handler();
    private boolean idle = true;
    private int moveStartedReason;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveStartedListener> onCameraMoveStarted = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveCanceledListener> onCameraMoveCanceled = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveListener> onCameraMove = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraIdleListener> onCameraIdle = new CopyOnWriteArrayList();
    private MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener;
    private MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private MapboxMap.OnCameraIdleListener onCameraIdleListener;
    private final Runnable onCameraMoveStartedRunnable = new Runnable(){

        @Override
        public void run() {
            if (CameraChangeDispatcher.this.onCameraMoveStartedListener != null) {
                CameraChangeDispatcher.this.onCameraMoveStartedListener.onCameraMoveStarted(CameraChangeDispatcher.this.moveStartedReason);
            }
            if (!CameraChangeDispatcher.this.onCameraMoveStarted.isEmpty()) {
                for (MapboxMap.OnCameraMoveStartedListener cameraMoveStartedListener : CameraChangeDispatcher.this.onCameraMoveStarted) {
                    cameraMoveStartedListener.onCameraMoveStarted(CameraChangeDispatcher.this.moveStartedReason);
                }
            }
        }
    };
    private final Runnable onCameraMoveRunnable = new Runnable(){

        @Override
        public void run() {
            if (CameraChangeDispatcher.this.onCameraMoveListener != null && !CameraChangeDispatcher.this.idle) {
                CameraChangeDispatcher.this.onCameraMoveListener.onCameraMove();
            }
            if (!CameraChangeDispatcher.this.onCameraMove.isEmpty() && !CameraChangeDispatcher.this.idle) {
                for (MapboxMap.OnCameraMoveListener cameraMoveListener : CameraChangeDispatcher.this.onCameraMove) {
                    cameraMoveListener.onCameraMove();
                }
            }
        }
    };
    private final Runnable onCameraMoveCancelRunnable = new Runnable(){

        @Override
        public void run() {
            if (CameraChangeDispatcher.this.onCameraMoveCanceledListener != null && !CameraChangeDispatcher.this.idle) {
                CameraChangeDispatcher.this.onCameraMoveCanceledListener.onCameraMoveCanceled();
            }
            if (!CameraChangeDispatcher.this.onCameraMoveCanceled.isEmpty() && !CameraChangeDispatcher.this.idle) {
                for (MapboxMap.OnCameraMoveCanceledListener cameraMoveCanceledListener : CameraChangeDispatcher.this.onCameraMoveCanceled) {
                    cameraMoveCanceledListener.onCameraMoveCanceled();
                }
            }
        }
    };
    private final Runnable onCameraIdleRunnable = new Runnable(){

        @Override
        public void run() {
            if (CameraChangeDispatcher.this.onCameraIdleListener != null) {
                CameraChangeDispatcher.this.onCameraIdleListener.onCameraIdle();
            }
            if (!CameraChangeDispatcher.this.onCameraIdle.isEmpty()) {
                for (MapboxMap.OnCameraIdleListener cameraIdleListener : CameraChangeDispatcher.this.onCameraIdle) {
                    cameraIdleListener.onCameraIdle();
                }
            }
        }
    };

    CameraChangeDispatcher() {
    }

    @Deprecated
    void setOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.onCameraMoveStartedListener = onCameraMoveStartedListener;
    }

    @Deprecated
    void setOnCameraMoveCanceledListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.onCameraMoveCanceledListener = onCameraMoveCanceledListener;
    }

    @Deprecated
    void setOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        this.onCameraMoveListener = onCameraMoveListener;
    }

    @Deprecated
    void setOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        this.onCameraIdleListener = onCameraIdleListener;
    }

    @Override
    public void onCameraMoveStarted(int reason) {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        this.moveStartedReason = reason;
        this.handler.post(this.onCameraMoveStartedRunnable);
    }

    @Override
    public void onCameraMove() {
        this.handler.post(this.onCameraMoveRunnable);
    }

    @Override
    public void onCameraMoveCanceled() {
        this.handler.post(this.onCameraMoveCancelRunnable);
    }

    @Override
    public void onCameraIdle() {
        if (!this.idle) {
            this.idle = true;
            this.handler.post(this.onCameraIdleRunnable);
        }
    }

    void addOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        this.onCameraIdle.add(listener);
    }

    void removeOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        if (this.onCameraIdle.contains(listener)) {
            this.onCameraIdle.remove(listener);
        }
    }

    void addOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        this.onCameraMoveCanceled.add(listener);
    }

    void removeOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        if (this.onCameraMoveCanceled.contains(listener)) {
            this.onCameraMoveCanceled.remove(listener);
        }
    }

    void addOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        this.onCameraMoveStarted.add(listener);
    }

    void removeOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        if (this.onCameraMoveStarted.contains(listener)) {
            this.onCameraMoveStarted.remove(listener);
        }
    }

    void addOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        this.onCameraMove.add(listener);
    }

    void removeOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        if (this.onCameraMove.contains(listener)) {
            this.onCameraMove.remove(listener);
        }
    }
}

