/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.concurrent.CopyOnWriteArrayList;

class CameraChangeDispatcher
implements MapboxMap.OnCameraMoveStartedListener,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnCameraMoveCanceledListener,
MapboxMap.OnCameraIdleListener {
    private boolean idle = true;
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveStartedListener> onCameraMoveStarted = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveCanceledListener> onCameraMoveCanceled = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraMoveListener> onCameraMove = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapboxMap.OnCameraIdleListener> onCameraIdle = new CopyOnWriteArrayList();
    private MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener;
    private MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private MapboxMap.OnCameraIdleListener onCameraIdleListener;

    CameraChangeDispatcher() {
    }

    @Deprecated
    void setOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.onCameraMoveStartedListener = onCameraMoveStartedListener;
    }

    @Deprecated
    void setOnCameraMoveCanceledListener(MapboxMap.OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.onCameraMoveCanceledListener = onCameraMoveCanceledListener;
    }

    @Deprecated
    void setOnCameraMoveListener(MapboxMap.OnCameraMoveListener onCameraMoveListener) {
        this.onCameraMoveListener = onCameraMoveListener;
    }

    @Deprecated
    void setOnCameraIdleListener(MapboxMap.OnCameraIdleListener onCameraIdleListener) {
        this.onCameraIdleListener = onCameraIdleListener;
    }

    @Override
    public void onCameraMoveStarted(int reason) {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        if (this.onCameraMoveStartedListener != null) {
            this.onCameraMoveStartedListener.onCameraMoveStarted(reason);
        }
        if (!this.onCameraMoveStarted.isEmpty()) {
            for (MapboxMap.OnCameraMoveStartedListener cameraMoveStartedListener : this.onCameraMoveStarted) {
                cameraMoveStartedListener.onCameraMoveStarted(reason);
            }
        }
    }

    @Override
    public void onCameraMove() {
        if (this.onCameraMoveListener != null && !this.idle) {
            this.onCameraMoveListener.onCameraMove();
        }
        if (!this.onCameraMove.isEmpty() && !this.idle) {
            for (MapboxMap.OnCameraMoveListener cameraMoveListener : this.onCameraMove) {
                cameraMoveListener.onCameraMove();
            }
        }
    }

    @Override
    public void onCameraMoveCanceled() {
        if (this.onCameraMoveCanceledListener != null && !this.idle) {
            this.onCameraMoveCanceledListener.onCameraMoveCanceled();
        }
        if (!this.onCameraMoveCanceled.isEmpty() && !this.idle) {
            for (MapboxMap.OnCameraMoveCanceledListener cameraMoveCanceledListener : this.onCameraMoveCanceled) {
                cameraMoveCanceledListener.onCameraMoveCanceled();
            }
        }
    }

    @Override
    public void onCameraIdle() {
        if (!this.idle) {
            this.idle = true;
            if (this.onCameraIdleListener != null) {
                this.onCameraIdleListener.onCameraIdle();
            }
            if (!this.onCameraIdle.isEmpty()) {
                for (MapboxMap.OnCameraIdleListener cameraIdleListener : this.onCameraIdle) {
                    cameraIdleListener.onCameraIdle();
                }
            }
        }
    }

    void addOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        this.onCameraIdle.add(listener);
    }

    void removeOnCameraIdleListener(@NonNull MapboxMap.OnCameraIdleListener listener) {
        if (this.onCameraIdle.contains(listener)) {
            this.onCameraIdle.remove(listener);
        }
    }

    void addOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        this.onCameraMoveCanceled.add(listener);
    }

    void removeOnCameraMoveCancelListener(MapboxMap.OnCameraMoveCanceledListener listener) {
        if (this.onCameraMoveCanceled.contains(listener)) {
            this.onCameraMoveCanceled.remove(listener);
        }
    }

    void addOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        this.onCameraMoveStarted.add(listener);
    }

    void removeOnCameraMoveStartedListener(MapboxMap.OnCameraMoveStartedListener listener) {
        if (this.onCameraMoveStarted.contains(listener)) {
            this.onCameraMoveStarted.remove(listener);
        }
    }

    void addOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        this.onCameraMove.add(listener);
    }

    void removeOnCameraMoveListener(MapboxMap.OnCameraMoveListener listener) {
        if (this.onCameraMove.contains(listener)) {
            this.onCameraMove.remove(listener);
        }
    }
}

