/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import com.mapbox.mapboxsdk.geometry.LatLng;
import java.util.HashMap;
import java.util.Map;

public class TileSet {
    private final String tilejson;
    private String name;
    private String description;
    private String version;
    private String attribution;
    private String template;
    private String legend;
    private String scheme;
    private final String[] tiles;
    private String[] grids;
    private String[] data;
    private Float minZoom;
    private Float maxZoom;
    private Float[] bounds;
    private Float[] center;

    public TileSet(String tilejson, String ... tiles) {
        this.tilejson = tilejson;
        this.tiles = tiles;
    }

    public String getTilejson() {
        return this.tilejson;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String[] getTiles() {
        return this.tiles;
    }

    public String[] getGrids() {
        return this.grids;
    }

    public void setGrids(String ... grids) {
        this.grids = grids;
    }

    public String[] getData() {
        return this.data;
    }

    public void setData(String ... data) {
        this.data = data;
    }

    public float getMinZoom() {
        return this.minZoom.floatValue();
    }

    public void setMinZoom(float minZoom) {
        this.minZoom = Float.valueOf(minZoom);
    }

    public float getMaxZoom() {
        return this.maxZoom.floatValue();
    }

    public void setMaxZoom(float maxZoom) {
        this.maxZoom = Float.valueOf(maxZoom);
    }

    public Float[] getBounds() {
        return this.bounds;
    }

    public void setBounds(Float ... bounds) {
        this.bounds = bounds;
    }

    public Float[] getCenter() {
        return this.center;
    }

    public void setCenter(Float ... center) {
        this.center = center;
    }

    public void setCenter(LatLng center) {
        this.center = new Float[]{Float.valueOf((float)center.getLongitude()), Float.valueOf((float)center.getLatitude())};
    }

    Map<String, Object> toValueObject() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tilejson", this.tilejson);
        result.put("tiles", this.tiles);
        if (this.name != null) {
            result.put("name", this.name);
        }
        if (this.description != null) {
            result.put("description", this.description);
        }
        if (this.version != null) {
            result.put("version", this.version);
        }
        if (this.attribution != null) {
            result.put("attribution", this.attribution);
        }
        if (this.template != null) {
            result.put("template", this.template);
        }
        if (this.legend != null) {
            result.put("legend", this.legend);
        }
        if (this.scheme != null) {
            result.put("scheme", this.scheme);
        }
        if (this.grids != null) {
            result.put("grids", this.grids);
        }
        if (this.data != null) {
            result.put("data", this.data);
        }
        if (this.minZoom != null) {
            result.put("minzoom", this.minZoom);
        }
        if (this.maxZoom != null) {
            result.put("maxzoom", this.maxZoom);
        }
        if (this.bounds != null) {
            result.put("bounds", this.bounds);
        }
        if (this.center != null) {
            result.put("center", this.center);
        }
        return result;
    }
}

