/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapbox.services.android.telemetry.permissions.PermissionsManager;
import timber.log.Timber;

@Deprecated
public final class TrackingSettings {
    private final MyLocationView myLocationView;
    private final UiSettings uiSettings;
    private final FocalPointChangeListener focalPointChangedListener;
    private final CameraZoomInvalidator zoomInvalidator;
    private LocationEngine locationSource;
    private LocationEngineListener myLocationListener;
    private boolean locationChangeAnimationEnabled = true;
    private boolean isCustomLocationSource;
    private boolean myLocationEnabled;
    private boolean dismissLocationTrackingOnGesture = true;
    private boolean dismissBearingTrackingOnGesture = true;
    private MapboxMap.OnMyLocationTrackingModeChangeListener onMyLocationTrackingModeChangeListener;
    private MapboxMap.OnMyBearingTrackingModeChangeListener onMyBearingTrackingModeChangeListener;

    TrackingSettings(@NonNull MyLocationView myLocationView, UiSettings uiSettings, FocalPointChangeListener focalPointChangedListener, CameraZoomInvalidator zoomInvalidator) {
        this.myLocationView = myLocationView;
        this.focalPointChangedListener = focalPointChangedListener;
        this.uiSettings = uiSettings;
        this.zoomInvalidator = zoomInvalidator;
    }

    void initialise(MapboxMapOptions options) {
        this.locationSource = Mapbox.getLocationEngine();
        this.setMyLocationEnabled(options.getLocationEnabled());
    }

    void onSaveInstanceState(Bundle outState) {
        outState.putInt("mapbox_myLocationTracking", this.getMyLocationTrackingMode());
        outState.putInt("mapbox_myBearingTracking", this.getMyBearingTrackingMode());
        outState.putBoolean("mapbox_myLocationTrackingDismiss", this.isDismissLocationTrackingOnGesture());
        outState.putBoolean("mapbox_myBearingTrackingDismiss", this.isDismissBearingTrackingOnGesture());
        outState.putBoolean("mapbox_myLocationEnabled", this.isMyLocationEnabled());
        outState.putBoolean("mapbox_locationChangeAnimationEnabled", this.isLocationChangeAnimationEnabled());
        outState.putBoolean("mapbox_usingCustomLocationSource", this.isCustomLocationSource());
    }

    void onRestoreInstanceState(Bundle savedInstanceState) {
        try {
            this.setMyLocationEnabled(savedInstanceState.getBoolean("mapbox_myLocationEnabled"), savedInstanceState.getBoolean("mapbox_usingCustomLocationSource"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setMyLocationTrackingMode(savedInstanceState.getInt("mapbox_myLocationTracking", 0));
        this.setMyBearingTrackingMode(savedInstanceState.getInt("mapbox_myBearingTracking", 0));
        this.setDismissLocationTrackingOnGesture(savedInstanceState.getBoolean("mapbox_myLocationTrackingDismiss", true));
        this.setDismissBearingTrackingOnGesture(savedInstanceState.getBoolean("mapbox_myBearingTrackingDismiss", true));
        this.setLocationChangeAnimationEnabled(savedInstanceState.getBoolean("mapbox_locationChangeAnimationEnabled", true));
    }

    @UiThread
    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.myLocationView.setLocationChangeAnimationEnabled(this.isLocationChangeAnimationEnabled());
        this.myLocationView.setMyLocationTrackingMode(myLocationTrackingMode);
        if (myLocationTrackingMode == 4) {
            this.zoomInvalidator.zoomTo(2.0);
            this.focalPointChangedListener.onFocalPointChanged(this.myLocationView.getCenter());
        } else {
            this.focalPointChangedListener.onFocalPointChanged(null);
        }
        if (this.onMyLocationTrackingModeChangeListener != null) {
            this.onMyLocationTrackingModeChangeListener.onMyLocationTrackingModeChange(myLocationTrackingMode);
        }
    }

    @UiThread
    public int getMyLocationTrackingMode() {
        return this.myLocationView.getMyLocationTrackingMode();
    }

    @UiThread
    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.myLocationView.setMyBearingTrackingMode(myBearingTrackingMode);
        if (this.onMyBearingTrackingModeChangeListener != null) {
            this.onMyBearingTrackingModeChangeListener.onMyBearingTrackingModeChange(myBearingTrackingMode);
        }
    }

    @UiThread
    public int getMyBearingTrackingMode() {
        return this.myLocationView.getMyBearingTrackingMode();
    }

    public boolean isAllDismissTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture && this.dismissBearingTrackingOnGesture;
    }

    public void setDismissAllTrackingOnGesture(boolean dismissTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissTrackingOnGesture;
        this.dismissBearingTrackingOnGesture = dismissTrackingOnGesture;
    }

    public void setDismissLocationTrackingOnGesture(boolean dismissLocationTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissLocationTrackingOnGesture;
    }

    public boolean isDismissLocationTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture;
    }

    public void setDismissBearingTrackingOnGesture(boolean dismissBearingTrackingOnGesture) {
        this.dismissBearingTrackingOnGesture = dismissBearingTrackingOnGesture;
    }

    public boolean isDismissBearingTrackingOnGesture() {
        return this.dismissBearingTrackingOnGesture;
    }

    public boolean isLocationTrackingDisabled() {
        return this.myLocationView.getMyLocationTrackingMode() == 0;
    }

    public boolean isBearingTrackingDisabled() {
        return this.myLocationView.getMyBearingTrackingMode() == 0;
    }

    public boolean isRotateGestureCurrentlyEnabled() {
        return this.uiSettings.isRotateGesturesEnabled() && (this.dismissBearingTrackingOnGesture || this.myLocationView.getMyBearingTrackingMode() == 0 || this.myLocationView.getMyLocationTrackingMode() == 0);
    }

    public boolean isScrollGestureCurrentlyEnabled() {
        return this.uiSettings.isScrollGesturesEnabled() && (this.dismissLocationTrackingOnGesture || this.myLocationView.getMyLocationTrackingMode() == 0);
    }

    public boolean isLocationChangeAnimationEnabled() {
        return this.locationChangeAnimationEnabled;
    }

    public void setLocationChangeAnimationEnabled(boolean locationChangeAnimationEnabled) {
        this.locationChangeAnimationEnabled = locationChangeAnimationEnabled;
        this.myLocationView.setLocationChangeAnimationEnabled(locationChangeAnimationEnabled);
    }

    void resetTrackingModesIfRequired(boolean translate, boolean rotate, boolean isFromLocation) {
        if (translate && !this.isLocationTrackingDisabled() && this.isDismissLocationTrackingOnGesture() && !isFromLocation) {
            this.setMyLocationTrackingMode(0);
        }
        if (rotate && !this.isBearingTrackingDisabled() && this.isDismissBearingTrackingOnGesture()) {
            this.setMyBearingTrackingMode(0);
        }
    }

    void resetTrackingModesIfRequired(CameraPosition currentCameraPosition, CameraPosition targetCameraPosition, boolean isFromLocation) {
        if (currentCameraPosition.target != null) {
            this.resetTrackingModesIfRequired(!currentCameraPosition.target.equals(targetCameraPosition.target), false, isFromLocation);
        }
    }

    Location getMyLocation() {
        return this.myLocationView.getLocation();
    }

    void setOnMyLocationChangeListener(final @Nullable MapboxMap.OnMyLocationChangeListener listener) {
        if (listener != null) {
            this.myLocationListener = new LocationEngineListener(){

                public void onConnected() {
                }

                public void onLocationChanged(Location location) {
                    if (listener != null) {
                        listener.onMyLocationChange(location);
                    }
                }
            };
            this.locationSource.addLocationEngineListener(this.myLocationListener);
        } else {
            this.locationSource.removeLocationEngineListener(this.myLocationListener);
            this.myLocationListener = null;
        }
    }

    public boolean isCustomLocationSource() {
        return this.isCustomLocationSource;
    }

    void setOnMyLocationTrackingModeChangeListener(MapboxMap.OnMyLocationTrackingModeChangeListener listener) {
        this.onMyLocationTrackingModeChangeListener = listener;
    }

    void setOnMyBearingTrackingModeChangeListener(MapboxMap.OnMyBearingTrackingModeChangeListener listener) {
        this.onMyBearingTrackingModeChangeListener = listener;
    }

    MyLocationView getMyLocationView() {
        return this.myLocationView;
    }

    boolean isMyLocationEnabled() {
        return this.myLocationEnabled;
    }

    void setMyLocationEnabled(boolean locationEnabled) {
        this.setMyLocationEnabled(locationEnabled, this.isCustomLocationSource());
    }

    private void setMyLocationEnabled(boolean locationEnabled, boolean isCustomLocationSource) {
        if (!PermissionsManager.areLocationPermissionsGranted((Context)this.myLocationView.getContext())) {
            Timber.e((String)"Could not activate user location tracking: user did not accept the permission or permissions were not requested.", (Object[])new Object[0]);
            return;
        }
        this.myLocationEnabled = locationEnabled;
        this.isCustomLocationSource = isCustomLocationSource;
        this.myLocationView.setEnabled(locationEnabled, isCustomLocationSource);
    }

    void setLocationSource(LocationEngine locationSource) {
        if (this.locationSource != null && this.locationSource.equals(locationSource)) {
            return;
        }
        boolean bl = this.isCustomLocationSource = locationSource != null;
        if (locationSource == null) {
            locationSource = Mapbox.getLocationEngine();
        }
        this.locationSource = locationSource;
        this.myLocationView.setLocationSource(locationSource);
    }

    void update() {
        if (!this.myLocationView.isEnabled()) {
            return;
        }
        this.myLocationView.update();
    }

    void onStart() {
        this.myLocationView.onStart();
    }

    void onStop() {
        this.myLocationView.onStop();
    }

    static interface CameraZoomInvalidator {
        public void zoomTo(double var1);
    }
}

