/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.view.MotionEvent;

public abstract class BaseGestureDetector {
    protected final Context context;
    protected boolean gestureInProgress;
    protected MotionEvent prevEvent;
    protected MotionEvent currEvent;
    protected float currPressure;
    protected float prevPressure;
    protected long timeDelta;
    protected static final float PRESSURE_THRESHOLD = 0.67f;

    public BaseGestureDetector(Context context) {
        this.context = context;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int actionCode = event.getAction() & 0xFF;
        if (!this.gestureInProgress) {
            this.handleStartProgressEvent(actionCode, event);
        } else {
            this.handleInProgressEvent(actionCode, event);
        }
        return true;
    }

    protected abstract void handleStartProgressEvent(int var1, MotionEvent var2);

    protected abstract void handleInProgressEvent(int var1, MotionEvent var2);

    protected void updateStateByEvent(MotionEvent curr) {
        MotionEvent prev = this.prevEvent;
        if (this.currEvent != null) {
            this.currEvent.recycle();
            this.currEvent = null;
        }
        this.currEvent = MotionEvent.obtain((MotionEvent)curr);
        this.timeDelta = curr.getEventTime() - prev.getEventTime();
        this.currPressure = curr.getPressure(curr.getActionIndex());
        this.prevPressure = prev.getPressure(prev.getActionIndex());
    }

    protected void resetState() {
        if (this.prevEvent != null) {
            this.prevEvent.recycle();
            this.prevEvent = null;
        }
        if (this.currEvent != null) {
            this.currEvent.recycle();
            this.currEvent = null;
        }
        this.gestureInProgress = false;
    }

    public boolean isInProgress() {
        return this.gestureInProgress;
    }

    public long getTimeDelta() {
        return this.timeDelta;
    }

    public long getEventTime() {
        return this.currEvent.getEventTime();
    }
}

