/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.net.ConnectivityListener;
import com.mapbox.mapboxsdk.net.NativeConnectivityListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import timber.log.Timber;

public class ConnectivityReceiver
extends BroadcastReceiver {
    @SuppressLint(value={"StaticFieldLeak"})
    private static ConnectivityReceiver INSTANCE;
    private List<ConnectivityListener> listeners = new CopyOnWriteArrayList<ConnectivityListener>();
    private Context context;
    private int activationCounter;

    public static synchronized ConnectivityReceiver instance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ConnectivityReceiver(context.getApplicationContext());
            INSTANCE.addListener(new NativeConnectivityListener());
        }
        return INSTANCE;
    }

    private ConnectivityReceiver(@NonNull Context context) {
        this.context = context;
    }

    @UiThread
    public void activate() {
        if (this.activationCounter == 0) {
            this.context.registerReceiver((BroadcastReceiver)INSTANCE, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        ++this.activationCounter;
    }

    @UiThread
    public void deactivate() {
        --this.activationCounter;
        if (this.activationCounter == 0) {
            this.context.unregisterReceiver((BroadcastReceiver)INSTANCE);
        }
    }

    public void onReceive(Context context, Intent intent) {
        boolean connected = this.isConnected(context);
        Timber.v((String)"Connected: %s", (Object[])new Object[]{connected});
        for (ConnectivityListener listener : this.listeners) {
            listener.onNetworkStateChanged(connected);
        }
    }

    public void addListener(@NonNull ConnectivityListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull ConnectivityListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isConnected(Context context) {
        Boolean connected = Mapbox.isConnected();
        if (connected != null) {
            return connected;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }
}

