/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.functions.stops;

import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import java.util.HashMap;
import java.util.Map;

public class Stop<I, O> {
    public final I in;
    public final O out;

    public static <I, O> Stop<I, O> stop(I in, PropertyValue<O> output) {
        return new Stop(in, output.value);
    }

    public static <Z extends Number, I, O> Stop<CompositeValue<Z, I>, O> stop(Z zoom, I value, PropertyValue<O> output) {
        return new Stop(new CompositeValue<Z, I>(zoom, value), output.value);
    }

    Stop(I in, O out) {
        this.in = in;
        this.out = out;
    }

    Object[] toValueObject() {
        return new Object[]{this.in instanceof CompositeValue ? ((CompositeValue)this.in).toValueObject() : this.in, this.out};
    }

    public String toString() {
        return String.format("[%s, %s]", this.in, this.out);
    }

    public static class CompositeValue<Z extends Number, V> {
        public final Z zoom;
        public final V value;

        CompositeValue(Z zoom, V value) {
            this.zoom = zoom;
            this.value = value;
        }

        Map<String, Object> toValueObject() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("zoom", this.zoom);
            map.put("value", this.value);
            return map;
        }

        public String toString() {
            return String.format("[zoom: %s, value: %s]", this.zoom, this.value);
        }
    }
}

